#!/usr/bin/perl
#  Copyright 2001-2021 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


# *** Outline ***
# Remove Function to remove students entered by mistake.


my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Attendance' => 'Attendance',
	   'Records' => 'Records',
	   'Birthdate' => 'Birthdate',
	   'Age' => 'Age',
	   'Transfers' => 'Transfers',
	   'Student' => 'Student',
	   'Records Deleted' => 'Records Deleted',
	   'Delete' => 'Delete',
	   'Password' => 'Password',
	   'Continue' => 'Continue',
	   'Audit' => 'Audit',
	   'Record(s) Stored' => 'Record(s) Stored',
	   'Count' => 'Count',
	   'Course' => 'Course',
	   'Enrollments' => 'Enrollments',
	   'Grade' => 'Grade',
	   'Homeroom' => 'Homeroom',
	   'Not Found' => 'Not Found',
	   'Record' => 'Record',
	   'Remove' => 'Remove',
	   'Student Number' => 'Student Number',
	   'Students' => 'Students',
	   'Transfer' => 'Transfer',
	   'Name' => 'Name',

	   );


my $self = 'remove.pl';
my $pass = 'embrayer';

use DBI;
use CGI;

# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

# Load audit write function
eval require "../../lib/libaudit.pl";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

# Get Date
my @tim = localtime(time);
my $year = @tim[5] + 1900;
my $month = @tim[4] + 1;
my $day = @tim[3];
if ( length( $day ) == 1 ) { $day = '0'. $day; }
if ( length( $month ) == 1 ) { $month = '0'. $month; }
my $currdate = "$year-$month-$day";

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# HTML Header
my $title = "$lex{Remove} $lex{Students} Enrolled by Mistake";

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body style="padding:1em 2em;">\n};

print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    confirmStudent();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    deleteStudent();
} 


#----------------
sub showStartPage {
#----------------

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<p><b>Local $lex{'Student Number'}</b> <input type="text" name="studnum" size="8"></p>\n};
    print qq{<p><b>$lex{Password}</b> <input type="text" name="pass" size="8"></p>\n};
    print qq{<p><input type="submit" value="$lex{Continue}"></p>\n};

    print qq{</form>\n};
    print qq{</body></html>\n};

    exit;
}



#----------------
sub confirmStudent {
#----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # check password;
    if ( $arr{pass} ne $pass ) {
	print qq{<h2>$lex{Password} $lex{Error}</h2>\n};
	print qq{</body></html>\n};
	exit;
    }

    # Get table, in case withdrawn.
    my $studtable = 'student';
    my $sth = $dbh->prepare("select count(*) from studentwd where studnum = ?");
    $sth->execute( $arr{studnum} );
    if ($DBI::errstr) { print $DBI::errstr; die "$DBI::errstr : $! \n";}
    my $studcount = $sth->fetchrow;
    if ( $studcount > 0 ) {
	$studtable = 'studentwd';
    }


    # Get Name
    my $sth = $dbh->prepare("select lastname, firstname, initial, studnum, birthdate, grade, homeroom
     from $studtable where studnum = ?");
    $sth->execute( $arr{studnum} );
    if ($DBI::errstr) { print $DBI::errstr; die "$DBI::errstr : $! \n";}
    my $ref = $sth->fetchrow_hashref;
    if ( not $ref ) {
	print qq{<h3>$lex{Student} $lex{'Not Found'}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }
    my %sr = %$ref;

    # Start Table
    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<tr><td class="bra">$lex{Name}</td>};
    print qq{<td class="la">$sr{firstname} $sr{initial} $sr{lastname}</td></tr>\n};
    print qq{<tr><td class="bra">$lex{Birthdate}</td><td class="la">$sr{birthdate}</td></tr>\n};
    print qq{<tr><td class="bra">$lex{Grade}</td><td class="la">$sr{grade}</td></tr>\n};
    if ( $sr{homeroom} ) {
	print qq{<tr><td class="bra">$lex{Homeroom}</td><td class="la">$sr{homeroom}</td></tr>\n};
    }
#    print qq{<tr><td class="bra"></td><td class="la"></td></tr>\n};


    # Get Transfers
    my $sth = $dbh->prepare("select * from transfer where studnum = ? order by date desc");
    $sth->execute( $arr{studnum} );
    if ($DBI::errstr) { print $DBI::errstr; die "$DBI::errstr : $! \n";}
    my $tcount = 1;
    while ( my $tref = $sth->fetchrow_hashref ) {
	my %tr = %$tref;
	print qq{<tr><td class="bra">$lex{Transfer} $tcount</td>};
	print qq{<td class="la">$tr{date} - $tr{type} - $tr{description}</td></tr>\n};
	$tcount++;
    }

    # Display Attendance, Courses, if any.
    my $failflag;
    $sth = $dbh->prepare("select count(*) from attend where studentid = ?");
    $sth->execute( $arr{studnum} );
    if ($DBI::errstr) { print $DBI::errstr; die "$DBI::errstr : $! \n";}
    my $attcount = $sth->fetchrow;

    print qq{<tr><td class="bra">$lex{Attendance} $lex{Count}</td>};
    print qq{<td class="la">$attcount</td></tr>\n};
    if ( $attcount ) {
	print qq{<tr><td class="bcn" style="color:red;" colspan="2">};
	print qq{$lex{Remove} $lex{Attendance} $lex{Records}</td></tr>\n};
	$failflag = 1;
    }

    $sth = $dbh->prepare("select count(distinct subjcode) from eval where studnum = ?");
    $sth->execute( $arr{studnum} );
    if ($DBI::errstr) { print $DBI::errstr; die "$DBI::errstr : $! \n";}
    my $coursecount = $sth->fetchrow;

    print qq{<tr><td class="bra">$lex{Course} $lex{Count}</td><td class="la">$coursecount</td></tr>\n};
    if ( $coursecount ) {
	print qq{<tr><td class="bcn" style="color:red;" colspan="2">};
	print qq{$lex{Remove} $lex{Course} $lex{Enrollments}</td></tr>\n};
	$failflag = 1;
    }
    print qq{</table>\n};

    if ( $failflag ) {
	print qq{</body></html>\n};
	exit;
    }

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="hidden" name="studnum" value="$arr{studnum}">\n};
    print qq{<input type="hidden" name="studtable" value="$studtable">\n};

    print qq{<p><input type="submit" value="$lex{Delete} $lex{Record}"></p>\n};
    print qq{</form>};

    print qq{</body></html>\n};

    exit;
}


#----------------
sub deleteStudent {
#----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }


    # Read Student record
    my $sth = $dbh->prepare("select * from $arr{studtable} where studnum = ?");
    $sth->execute( $arr{studnum} );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my $sref = $sth->fetchrow_hashref;
    
#    print qq{SREF:$sref<br>\n};


    my %audit;
    $audit{userid} = $ENV{REMOTE_USER};
    $audit{ipaddr} = $ENV{REMOTE_ADDR};
    $audit{scriptname} = $self;
    $audit{tablename} = 'studentwd';
    $audit{tableid} = $sref->{studid};
    $audit{startval} = $sref;
    # $audit{endval} = '';  # blank.

    addAudit( \%audit, $dbh );


    # Remove Student record
    my $sth = $dbh->prepare("delete from $arr{studtable} where studnum = ?");
    $sth->execute( $arr{studnum} );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }


    # Remove Transfer records
    $sth = $dbh->prepare("delete from transfer where studnum = ?");
    $sth->execute( $arr{studnum} );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	    
    print qq{<h3>$lex{'Records Deleted'}<br>$lex{Audit} $lex{'Record(s) Stored'}</h3>\n};
    print qq{</body></html>\n};

    exit;

} # end of deleteStudent
