#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.


my %lex = ('Add Transfer' => 'Add Transfer',
	   'Main' => 'Main',
	   'Last Name' => 'Last Name',
	   'First Name' => 'First Name',
	   'Middle Name' => 'Middle Name',
	   'Birthdate' => 'Birthdate',
	   'YYYY-MM-DD' => 'YYYY-MM-DD',
	   'Student Number' => 'Student Number',
	   'Provincial Student Number' => 'Provincial Student Number',
	   'Date' => 'Date',
	   'Type' => 'Type',
	   'Withdraw' => 'Withdraw',
	   'Enrol' => 'Enrol',
	   'Description' => 'Description',
	   'Save' => 'Save',
	   'Error' => 'Error',
	   'Contact' => 'Contact',
	   'Record(s) Stored' => 'Record(s) Stored',
	   'Add Another' => 'Add Another',

	   );

$self = 'transadd.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

# pull in global enrol/withdraw descriptors
eval require "$globdir/global.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


$q = new CGI;
print $q->header( -charset, $charset ); 
%arr = $q->Vars;


# Setup Database
my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



print qq{$doctype\n<html><head><title>$lex{'Add Transfer'}</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body style="margin:1em;">\n};
print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};
print qq{<h1>$lex{'Add Transfer'}</h1>\n};


if ( $arr{page} ) {
    delete $arr{page};
    writeRecord();
}

print qq{<form action="$self" method="post" style="margin:1.5em;"> \n};
print qq{Student Number <input type="text" name="studnum" style="width:7ch;">\n};
print qq{<input type="submit" value="Populate Form"></form>\n\n};

my %r;
if ( $arr{studnum} ) { # load record to populate form.
    my $sth = $dbh->prepare("select * from studentall where studnum = ?");
    $sth->execute( $arr{studnum} );
    if ( $DBI::errstr ) {
	print qq{<h3>$lex{Error} $DBI::errstr;</h3>\n};
	print qq{</body></html>\n};
	exit;
    }
    my $ref = $sth->fetchrow_hashref;
    %r = %$ref;
}


print qq{<form action="$self" method="post"> \n};
print qq{<input type="hidden" name="page" value="1">\n};

print qq{<table cellpadding = "3" cellspacing="0" border="0" style="border:1px solid gray;">\n};

print qq{<tr><td class="bra">$lex{'Last Name'}</td>\n<td>};
print qq{<input type="text" name="lastname" value="$r{lastname}" style="width:25ch;"></td></tr>\n};

print qq{<tr><td class="bra">$lex{'First Name'}</td>\n<td>};
print qq{<input type="text" name="firstname" value="$r{firstname}" style="width:25ch;"></td></tr>\n};

print qq{<tr><td class="bra">$lex{'Middle Name'}</td>\n<td>};
print qq{<input type="text" name="middlename" value="$r{initial}" style="width:25ch;"></td></tr>\n};

print qq{<tr><td class="bra">$lex{'Birthdate'}</td>\n<td>};
print qq{<input type="text" name="birthdate" style="width:12ch;" value="$r{birthdate}">};
print qq{ $lex{'YYYY-MM-DD'}</td></tr>\n};

print qq{<tr><td class="bra">$lex{'Student Number'}</td>\n<td>};
print qq{<input type="text" name="studnum" style="width:8ch;" value="$r{studnum}"></td></tr>\n};

print qq{<tr><td class="bra">$lex{'Provincial Student Number'}</td>\n<td>};
print qq{<input type="text" name="provnum" style="width:12ch;" value="$r{provnum}"></td></tr>\n};

print qq{<tr><td class="bra">$lex{Date}</td>\n<td>};
print qq{<input type="text" name="date" size="12"> $lex{'YYYY-MM-DD'}</td></tr>\n};

print qq{<tr><td class="bra">$lex{Type}</td>\n<td>};
print qq{<select name="type"><option></option>};
print qq{<option value="withdraw">$lex{Withdraw}</option>\n};
print qq{<option value="enrol">$lex{Enrol}</option>};
print qq{</select></td></tr>\n};

print qq{<tr><td></td><td style="font-weight:bold;font-size:120%;">};
print qq{Only fill in ONE of the following based on type above</td></tr>\n};

# Enrol code
print qq{<tr><td class="bra">Entry Type - if type is enrol</td>\n<td>};
print qq{<select name="entrytype"><option></option>\n};
foreach my $key ( @g_enrol ) { 
    print qq{<option value="$key">$g_enrol{$key} ($key)</option>\n}; 
}
print qq{<option></option></select></td></tr>\n};


# Withdraw (Exit) Code
print qq{<tr><td class="bra">Exit Type - if type is withdraw</td>\n<td>};
print qq{<select name="exittype"><option></option>\n};

# NOTE: g_enrol and g_wdraw are ARRAY values in global.conf and control the ordering.
foreach my $key ( @g_wdraw ) { # reverse order to show FN xfers
    print qq{<option value="$key">$g_wdraw{$key} ($key)</option>\n}; 
}
print qq{<option></option></select></td></tr>\n};

print qq{<tr><td colspan="2"></td></tr>\n}; # Blank Line

print qq{<tr><td class="bra">$lex{Description}</td>\n<td>};
print qq{<input type="text" name="description" size="50"></td></tr>\n};

print qq{<tr><td></td><td class="la">\n};
print qq{<input type="submit" value="$lex{Save}"></td></tr>\n};

print qq{</table></form>\n};
print qq{</body></html>\n};



#--------------
sub writeRecord {
#--------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Error checking
    if ( $arr{entrytype} and $arr{exittype} ) {
	print qq{<h3>You cannot have both an entry type AND an exit type!</h3>\n};
	print qq{</body></html>\n};
	exit;
	
    } elsif ( $arr{entrytype} and $arr{type} eq 'withdraw' ) {
	print qq{<h3>You cannot have a withdrawal and an entry type!</h3>\n};
	print qq{</body></html>\n};
	exit;
	
    } elsif ( $arr{exittype} and $arr{type} eq 'enrol' ) {
	print qq{<h3>You cannot have a withdrawal and an entry type!</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    

    $sth = $dbh->prepare("insert into transfer ( 
      studnum, date, type, description, entrytype, exittype, prov, country,
      lastname, firstname, middlename, birthdate, provnum )
      values ( ?,?,?,?,?,?,?,?,?,?,?,?,? )");

    $sth->execute( $arr{studnum}, $arr{date}, $arr{type}, $arr{description},
      $arr{entrytype}, $arr{exittype}, $arr{prov}, $arr{country},
      $arr{lastname}, $arr{firstname}, $arr{middlename}, $arr{birthdate}, $arr{provnum} );

    if ( not $DBI::errstr ) {
	print qq{<h3>$lex{'Record(s) Stored'}</h3>\n};

    } else {
	print qq{<h3>$lex{Error} $DBI::errstr;<br>$lex{Contact}};
	print qq{: $adminname <a href="mailto:$adminemail">$adminemail</a></h3>\n};
    }


    print qq{<h3>[ <a href="$self">$lex{'Add Another'}</a> ]</h3>\n};
    print qq{</body></html>\n};

    exit;
}
