#!/usr/bin/perl
#  Copyright 2001-2025 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ( 'Edit' => 'Edit',
	    'Transfers' => 'Transfers',
	    'Main' => 'Main',
	    'Last Name' => 'Last Name',
	    'First Name' => 'First Name',
	    'Middle Name' => 'Middle Name',
	    'Birthdate' => 'Birthdate',
	    'Update Record' => 'Update Record',
	    'Another' => 'Another',
	    'Record' => 'Record',
	    'Updated' => 'Updated',
	    'Contact' => 'Contact',
	    'Error' => 'Error',
	    'Student Number' => 'Student Number',
	    'Date' => 'Date',
	    'Type' => 'Type',
	    'Entry Type' => 'Entry Type',
	    'Exit Type' => 'Exit Type',
	    'Province' => 'Province',
	    'Country' => 'Country',
	    'Description' => 'Description',
	    'Identity Number' => 'Identity Number',
	    'School Enrollments' => 'School Enrollments',

	   );

my $self = 'transferEd.pl';

use CGI;
use DBI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

# pull in global enrol/withdraw descriptors
eval require "$globdir/global.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

# Load audit write function
eval require "../../lib/libaudit.pl";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Head
my $title = qq{$lex{Edit} $lex{Transfers}/$lex{'School Enrollments'}};

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};

if ( not $arr{page} ) { # calendar popup.
    print qq{<link rel="stylesheet" type="text/css" media="all" };
    print qq{href="/js/calendar-blue.css" title="blue">\n};
    print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};
}


print qq{$chartype\n</head><body>[ <a href="$homepage">$lex{Main}</a> ]\n};

print qq{<h1>$title</h1>\n};

if ( $arr{page} ) {
    delete $arr{page};
    updateRecord();
}

print qq{<div style="margin:2em;font-weight:bold;font-size:120%;">};
print qq{If you are enrolling or withdrawing a student from your school please use the<br>\n};
print qq{[ <a href="./enrol.pl">Enrol</a> ] or [ <a href="withdraw.pl">Withdraw</a> ] buttons.<br><br>\n};

print qq{You <span style="color:red;">cannot</span> enrol/withdraw students here. You can only use this screen to fix a <br>\n};
print qq{date or other minor description error.</div>\n};


my $sth = $dbh->prepare("select * from transfer where id = ?"); 
$sth->execute( $arr{id} );
if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr;}
my $ref = $sth->fetchrow_hashref;


print qq{<form action="$self" method="post">\n};
print qq{<input type="hidden" name="page" value="1">\n};
print qq{<input type="hidden" name="id" value="$arr{id}">\n};

print qq{<table cellpadding="3" cellspacing="0" border="1">\n};

print qq{<tr><td class="bra">Record ID</td>\n};
print qq{<td><b>$ref->{id}</b></td></tr>\n};

print qq{<tr><td class="bra">$lex{'Student Number'}</td>\n};
print qq{<td><b>$ref->{studnum}</b></td></tr>\n};

print qq{<tr><td class="bra">$lex{'Last Name'}</td>\n<td>};
print qq{<input type="text" name="lastname" size="20" value="$ref->{lastname}" };
print qq{maxlength="40"></td></tr>\n};

print qq{<tr><td class="bra">$lex{'First Name'}</td>\n<td>};
print qq{<input type="text" name="firstname" size="20" value="$ref->{firstname}" };
print qq{maxlength="40"></td></tr>\n};

print qq{<tr><td class="bra">$lex{'Middle Name'}</td>\n<td>};
print qq{<input type="text" name="middlename" size="20" value="$ref->{middlename}" };
print qq{maxlength="40"></td></tr>\n};

print qq{<tr><td class="bra">$lex{Birthdate}</td>\n<td>};
print qq{<input type="text" name="birthdate" size="12" value="$ref->{birthdate}">\n};
print qq{</td></tr>\n};

print qq{<tr><td class="bra">$lex{'Identity Number'}/Provnum</td>\n<td>};
print qq{<input type="text" name="provnum" size="11" value="$ref->{provnum}"></td></tr>\n};

print qq{<tr><td class="bra">Enrol/Withdraw $lex{Date}</td>\n<td>};
print qq{<input type="text" };
print qq{name="date" id="date" style="width:12ch;" value="$ref->{date}">\n};
print qq{<button type="reset" id="start_trigger">...</button>\n};
print qq{</td></tr>\n};

# Change Type
if ( $arr{advanced} ) {
    print qq{<tr><td class="bra">$lex{Type}</td>\n<td>};
    print qq{<select name="type"><option>$ref->{type}</option>};
    print qq{<option value="withdraw">Withdraw</option>\n};
    print qq{<option value="enrol">Enrol</option>};
    print qq{</select></td></tr>\n};
} else {
    print qq{<tr><td class="bra">$lex{Type}</td>\n};
    print qq{<td style="font-weight:bold;font-size:120%;">$ref->{type}</td></tr>\n};
}
my $type = $ref->{type};

# Entry Type
if ( $type ne 'withdraw' or $arr{advanced} ) {
    print qq{<tr><td class="bra">$lex{'Entry Type'}</td>\n<td>};
    print qq{<select name="entrytype"><option value="$ref->{entrytype}">};
    print qq{$g_enrol{$ref->{entrytype}} ($ref->{entrytype})</option>\n};

    foreach my $key ( @g_enrol ) { 
	if ( $key eq $ref->{entrytype} ) { next; }
	print qq{<option value="$key">$g_enrol{$key} ($key)</option>\n}; 
    }
    print qq{<option value=""></option></select></td></tr>\n};
}


# Exit Type
if ( $type eq 'withdraw' or $arr{advanced} ) {
    print qq{<tr><td class="bra">$lex{'Exit Type'}</td>\n<td>};
    print qq{<select name="exittype"><option value="$ref->{exittype}">};
    print qq{$g_wdraw{ $ref->{exittype} } ($ref->{exittype})</option>\n};

    # NOTE: g_enrol and g_wdraw are ARRAY values in global.conf and control the ordering.
    foreach my $key ( @g_wdraw ) { # reverse order to show FN xfers
	if ( $key eq $ref->{exittype} ) { next; }
	print qq{<option value="$key">$g_wdraw{$key} ($key)</option>\n}; 
    }
    print qq{<option value=""></option></select></td></tr>\n};
}

print qq{<tr><td class="bra">$lex{Province}</td>\n};
print qq{<td><input type="text" name="prov" size="8" value="$ref->{prov}" maxlength="8">};
print qq{ 2 characters</td></tr>\n};

print qq{<tr><td class="bra">$lex{Country}</td>\n<td>};
print qq{<input type="text" name="country" size="8" value="$ref->{country}" };
print qq{maxlength="8"></td></tr>\n};

print qq{<tr><td class="bra">$lex{Description}</td>\n};
print qq{<td><textarea name="description" rows="2" cols="60" maxlength="255">$ref->{description}\n};
print qq{</textarea></td></tr>\n};

print qq{<tr><td></td><td><input type="submit" value="$lex{'Update Record'}"></td></tr>\n};

print qq{</table></form>\n};

print qq{<script type="text/javascript">
    Calendar.setup({
        inputField     :    "date", 
        ifFormat       :    "%Y-%m-%d",
        button         :    "start_trigger",
        singleClick    :    false,
        step           :    1
    });
</script>\n};

print qq{</body></html>\n};


#---------------
sub updateRecord {
#---------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $id = $arr{id};
    delete $arr{id};

    # Read original record.
    my $sth1 = $dbh->prepare("select * from transfer where id = ?");    
    $sth1->execute( $id );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $tref = $sth1->fetchrow_hashref;


    # Add Audit record.
    my %audit;
    $audit{userid} = $ENV{REMOTE_USER};
    $audit{ipaddr} = $ENV{REMOTE_ADDR};
    $audit{scriptname} = $self;
    $audit{tablename} = 'transfer';
    $audit{tableid} = $id;
    $audit{startval} = $tref; 
    $audit{endval} = \%arr;

    addAudit( \%audit, $dbh );


    my $sth;
    foreach my $key ( sort keys %arr ) { 
	$sth = $dbh->prepare("update transfer set $key = ? where id = ?");    
	$sth->execute( $arr{$key}, $id );
    }

    if ( not $DBI::errstr ) {
	print qq{<h3>$lex{Record} $lex{Updated}</h3>\n};
    } else {
	print qq{<h3>$lex{Error}: $DBI::errstr. Record not updated</h3>\n};
    }

    
    # print qq{<p>[ <a href="transview.pl">$lex{Edit} $lex{Another} $lex{Record}</a> | };
    # print qq{[ <a href="$homepage">$lex{Main}</a> ]</p>\n};

    print qq{<form style="margin:1em;"><input type="hidden" name="none">\n};
    print qq{<input type="button" value="Close Tab" onClick="parent.close()"></form>\n};

    
    print qq{</body></html>\n};

    exit;

}
