#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

use CGI;
use DBI;

my %lex = ('Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'Are you sure' => 'Are you sure',
	   'Delete the Record' => 'Delete the Record',
	   'Contact' => 'Contact',
	   'Waiting List' => 'Waiting List',
	   'deleted' => 'deleted',
	   'Name' => 'Name',
	   'Enrol Date' => 'Enrol Date',
	   'Wait Number' => 'Wait Number',
	   'Description' => 'Description',
	   'Error' => 'Error',
	   'Yes' => 'Yes',
	   'View' => 'View',
	   'Delete' => 'Delete',
	   'Member' => 'Member',

	    );

my $self = 'waitdel.pl';

# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


$sth = $dbh->prepare("select studnum, enroldate, waitnumber, description 
  from prereg_waitlist where id = ?"); 
$sth->execute( $arr{id} );
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
my ($studnum, $enroldate, $waitnumber, $description) = $sth->fetchrow;


$sth = $dbh->prepare("select lastname, firstname from prereg where studnum = ?");
$sth->execute( $studnum );
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
my ( $lastname, $firstname ) = $sth->fetchrow;

my $title = "$lex{Delete} $lex{'Waiting List'} $lex{Member}";

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$eoypage">$lex{Eoy}</a> ]\n};
print qq{<h1>$title</h1>\n};

if ( $arr{deleteflag} ) {
    deleteRecord();
}

print qq{<table>
 <tr><td class="ra"><b>$lex{'Name'}</b></td><td>$firstname $lastname</td></tr>
 <tr><td class="ra"><b>$lex{'Enrol Date'}</b></td><td>$enroldate</td></tr>
 <tr><td class="ra"><b>$lex{'Wait Number'}</b></td><td>$waitnumber</td></tr>
 <tr><td class="ra"><b>$lex{'Description'}</b></td><td>$description</td></tr>
 </table>\n};

print qq{<h3>$lex{Delete}: $lex{'Are you sure'}?</h3>\n};
print qq{<form action="$self" method="post">
 <input type="hidden" name="itemid" value="$arr{id}">
 <input type="hidden" name="name" value="$firstname $lastname">
 <input type="hidden" name="studnum" value="$studnum">
 <input type="hidden" name="deleteflag" value="1">
 <input type="submit" value="$lex{Yes}, $lex{'Delete the Record'}">
 </form></body></html>\n};


#---------------
sub deleteRecord {
#---------------

    delete $arr{deleteflag}; # don't need this...
    #foreach my $key (keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }

    $sth = $dbh->prepare("delete from prereg_waitlist where id = ?");
    $sth->execute( $arr{itemid} );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    $sth = $dbh->prepare("delete from prereg where studnum = ?");
    $sth->execute( $arr{studnum} );

    if ( $DBI::errstr ) {
	print qq{<h3>$lex{Error}: $DBI::errstr<br>\n};
	print qq{$lex{Contact} $adminname</h3>>\n};
    } else {
	print qq{<h1>$arr{name} $lex{deleted}</h1>\n};
    }

    print qq{<p>[ <a href="waitview.pl">$lex{View} $lex{'Waiting List'}</a> ]</p>\n};
    print qq{</body></html>\n};

    exit;
}
