#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'Reset' => 'Reset',
	   'Grade' => 'Grade',
	   'Student' => 'Student',
	   'New' => 'New',
	   'Update Record(s)' => 'Update Record(s)',
	   'Homeroom' => 'Homeroom',
	   'Record(s) Updated' => 'Record(s) Updated',
	   'Contact' => 'Contact',
	   'Error' => 'Error',
	   'HRm' => 'HRm',
	   'Gr' => 'Gr',
	   'Promote' => 'Promote',
	   'Demote' => 'Demote',

	   );

my $self = 'resetgrade.pl';


use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

$q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $promote = $arr{promote};
my $demote = $arr{demote};


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
my $title = qq{$lex{Reset} $lex{Grade}};
print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$eoypage">$lex{Eoy}</a> ]\n};

print qq{<form action="$self" method="post" style="display:inline;">\n};
print qq{<input type="hidden" name="promote" value="1">\n};
print qq{<input type="submit" value="$lex{Promote}"></form>\n};

print qq{<form action="$self" method="post" style="display:inline;">\n};
print qq{<input type="hidden" name="demote" value="1">\n};
print qq{<input type="submit" value="$lex{Demote}"></form>\n};



print qq{<h1>$schoolname &ndash; $title</h1>\n};

if ( $arr{writeflag} ) {
    delete $arr{writeflag};
    resetGrades();
}


# Stuff all grades into an array;
my $sth = $dbh->prepare("select distinct grade from student
 where grade is not NULL and grade != ''");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
my (@grades, %grades );
while ( my $grade = $sth->fetchrow ) {
    $grades{$grade} = 1;
}

# Load defaults from metadata also.
$sth = $dbh->prepare("select defaultvalue from meta 
where tableid = 'student' and fieldid = 'grade'");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
my $gradevalues = $sth->fetchrow;
my @temp = split /\s+/, $gradevalues;
foreach my $val ( @temp ) {
    if ($val eq '~') { next; }
    $grades{$val} = 1;
}

@grades = sort {$a <=> $b} keys %grades;


# Start Form
print qq{<form action="$self" method="post">\n};
print qq{<input type="hidden" name="writeflag" value="1">\n};

print qq{<table border="1" cellpadding="3" cellspacing="0">\n};
print qq{<tr><th>$lex{Student}</th><th>$lex{Homeroom}<br>$lex{Grade}</th>};
print qq{<th>$lex{New} $lex{Grade}</th></tr>\n};

print qq{<tr><td colspan="3" class="cn">\n};
print qq{<input type="submit" value="$lex{'Update Record(s)'}"></td></tr>\n};


my $sth = $dbh->prepare("select studid, lastname, firstname, homeroom, grade,
			CAST(grade as SIGNED) as castgrade from student
			order by castgrade, homeroom, grade, lastname,firstname");
# CAST(grade as SIGNED) as castgrade from student 
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

while ( my ($studid, $lastname, $firstname, $homeroom, $grade) = $sth->fetchrow ) {

    my $newgrade;
    if ( $promote ){
	if ($grade eq 'P3'){ $newgrade = 'PK'; }
	elsif ( $grade eq 'PK'){ $newgrade = 'K'; }
	elsif ( $grade eq 'K'){ $newgrade = '1'; }
	else { $newgrade = $grade + 1; }

    } elsif ( $demote ){
	if ($grade eq 'PK'){ $newgrade = 'P3';}
	elsif ($grade eq 'K'){ $newgrade = 'PK';}
	elsif ($grade eq '1'){ $newgrade = 'K';}
	else { $newgrade = $grade - 1; }

    } else {
	$newgrade = $grade;
    }

    print qq{<tr><td><b>$lastname</b>, $firstname</td>};
    print qq{<td>$homeroom / $grade</td>\n};
    print qq{<td><select name="$studid"><option>$newgrade</option>\n};
      
    foreach my $grade ( @grades ) {
	print qq{<option>$grade</option>};
    }
 
    print qq{</select></td></tr>\n\n};

} # End of loop 

print qq{<tr><td colspan="3" class="cn">\n};
print qq{<input type="submit" value="$lex{'Update Record(s)'}"></td></tr>\n};
print qq{</table></form></body></html>\n};



#--------------
sub resetGrades {
#--------------

    #foreach my $key (keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    $sth = $dbh->prepare("select grade from student where studid = ?");
    $sth1 = $dbh->prepare("update student set grade = ? where studid = ?");

    foreach my $key ( keys %arr ) { 

	# Get Current Grade
	$sth->execute( $key );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $grade = $sth->fetchrow;

	# Update if necessary
	if ( $grade ne $arr{$key} ){ # different; do an update
	    $sth1->execute( $arr{$key}, $key );
	    #print qq{K:$key V:$arr{$key}<br>\n};
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	}
    }

    if (not $DBI::errstr ) {
	print qq{<h3>$lex{'Record(s) Updated'}</h3>\n};
    } else {
	print qq{<h3>$lex{Error}: $DBI::errstr<br>\n};
	print qq{$lex{Contact} $adminname <a href="mailto:$adminemail">$adminemail</a></h3>\n};

    }
    print qq{[ <a href="$homepage">$lex{Main}</a> | };
    print qq{<a href="$eoypage">$lex{Eoy}</a> ]</p>\n};
    print qq{</body></html>\n};

    exit;

}
