#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# Do a complete dump using mysqldump, zip it, then allow for download.

# my $tempdir = '/tmp'; 
# temporary working area when creating zip for complete backup.

my %lex = ('Export All' => 'Export All',
	   'Export' => 'Export',
	   'Main' => 'Main',
	   'Download School Database Backup' => 'Download School Database Backup',
	   'Error' => 'Error',

	   );

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Set Date Values
my ($sec, $min, $hour, $mday, $mon, $year, $wday, 
 $yday, $iddst) = localtime(time);
$mon++;
$year = $year + 1900;
$wday++;
if (length($mon) == 1){ $mon = '0'.$mon;}
if (length($mday) == 1){ $mday = '0'.$mday;}
my $currsdate = "$year$mon$mday";
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";

# Set File names and executable
my $filename = "backup$$-$currsdate.sql";
my $zipfile = "backup$$-$currsdate.zip";
my $dumper = 'mysqldump';  # change for Pg..

my $q = CGI->new;
print $q->header( -charset, $charset );
# %arr = $q->Vars; # Get passed values


# Print Page Header
print qq{$doctype\n<html><head><title>$lex{'Export All'}</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$exppage">$lex{Export}</a> ]\n};

system("$dumper -p$password -u $user $dbase >$filename");
system("zip $zipfile $filename >/dev/null");
unlink $filename;
system("mv $zipfile $downloaddir");

print qq{<p><a href="$webdownloaddir/$zipfile">\n};
print qq{<span style="font-size:160%;">$lex{'Download School Database Backup'}</span>\n};
print qq{</a></p></body></html>\n};

