#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Delete Fees' => 'Delete Fees',
	   'Main' => 'Main',
	   'Fees' => 'Fees',
	   'Withdrawn Students' => 'Withdrawn Students',
	   'No' => 'No',
	   'Delete Charges' => 'Delete Charges',
	   'Current Students' => 'Current Students',
	   'Record(s) Deleted' => 'Record(s) Deleted',
	   'Delete More Records' => 'Delete More Records',
	   'Error' => 'Error',

	   );

my $self = 'assessdeled.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = CGI->new;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Page Header
my $title = $lex{'Delete Fees'};
print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};
print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$feespage">$lex{'Fees'}</a> ]\n};

print qq{<h1>$title</h1>\n};


if ( not $arr{studnum} ) {
    showStartPage();
} else {
    if ( not $arr{deleteflag} ) {
	selectTransactions( $arr{studnum} );
    } else {
	# remove extra hash elements
	delete $arr{deleteflag};
	delete $arr{studnum};

	deleteTransactions();
    }
}


#---------------------
sub selectTransactions {
#---------------------

    my $studnum = shift;

    # Display student name
    my $sth = $dbh->prepare("select lastname, firstname from studentall
     where studnum = ?");
    $sth->execute( $studnum );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my ($lastname, $firstname) = $sth->fetchrow;
    print qq{<h3>$firstname $lastname</h3>\n};

    # Find and display the transactions
    $sth = $dbh->prepare("select id, trans_date, name, description, total 
     from fees_jrl where trans_type = 'chg' and paid_id is NULL and studnum = ?");
    $sth->execute( $studnum );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    # Start form and table
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="submit" value="$lex{'Delete Charges'}">\n};
    print qq{<input type="hidden" name="studnum" value="$studnum">\n};
    print qq{<input type="hidden" name="deleteflag" value="1">\n};
    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};

    while ( my ($id, $trans_date, $name, $description, $total ) = $sth->fetchrow ) {

	print qq{<tr><td><input type="checkbox" name="$id" value="1"></td>\n};
	print qq{<td>$trans_date</td><td>$name</td><td>$description</td><td>$total</td></tr>\n};

    }

    print qq{</table></form>\n};
    print qq{</body></html>\n};

    exit;

}


#----------------
sub showStartPage {
#----------------

    # Find outstanding Bills
    my $sth1 = $dbh->prepare("select lastname, firstname from studentall
     where studnum = ?");

    my $sth = $dbh->prepare("select distinct studnum from fees_jrl as f 
     where f.trans_type = 'chg' and f.paid_id is NULL and f.studnum != ''");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my %students;
    while ( my $studnum = $sth->fetchrow ) {

	$sth1->execute( $studnum );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	my ($lastname, $firstname) = $sth1->fetchrow;

	$students{"$lastname:$firstname:$studnum"} = $studnum;
    }

    my $sth2 = $dbh->prepare("select count(*) from student
     where studnum = ?");
    
    my (@active, @inactive);
    foreach my $key ( sort keys %students ) {
	my ($ln, $fn, $studnum ) = split /:/, $key;

	$sth2->execute( $studnum );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	if ( $sth2->fetchrow ) { # if true (1), then active student
	    push @active, $studnum;
	} else { # withdrawn
	    push @inactive, $studnum;
	}
	    
    }

    # Now parse each array, starting with withdrawn.
    print qq{<h3>$lex{'Withdrawn Students'}</h3>\n};
    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};

    if ( not @inactive ) { # no withdrawn students
	print qq{<tr><td>$lex{No} $lex{'Withdrawn Students'}</td></tr>\n};
    } else {
	foreach my $studnum ( @inactive ) {
	    $sth1->execute( $studnum );
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    my ($lastname, $firstname) = $sth1->fetchrow;

	    print qq{<tr><td>$firstname $lastname</td><td>\n};
	    print qq{<form action="$self" method="post">\n};
	    print qq{<input type="submit" value="$lex{'Delete Charges'}">\n};
	    print qq{<input type="hidden" name="studnum" value="$studnum"></form>\n};
	    print qq{</td></tr>\n};

	}
    }

    print qq{</table><p></p>\n};


    # Now do active students
    print qq{<h3>$lex{'Current Students'}</h3>\n};
    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};

    if ( not @active ) { # no Active students
	print qq{<tr><td>$lex{No} $lex{'Current Students'}</td></tr>\n};
    } else {
	foreach my $studnum ( @active ) {
	    $sth1->execute( $studnum );
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    my ($lastname, $firstname) = $sth1->fetchrow;

	    print qq{<tr><td>$firstname $lastname</td><td>\n};
	    print qq{<form action="$self" method="post">\n};
	    print qq{<input type="submit" value="$lex{'Delete Charges'}">\n};
	    print qq{<input type="hidden" name="studnum" value="$studnum"></form>\n};
	    print qq{</td></tr>\n};

	}
    }


    print qq{</table></body></html>\n};

    exit;

}


#---------------------
sub deleteTransactions {
#---------------------

    #foreach my $key (keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $sth = $dbh->prepare("delete from fees_jrl where id = ?");

    # Loop through all id's and remove.
    foreach my $id ( keys %arr ) {
	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    }

    print qq{<h1>$lex{'Record(s) Deleted'}</h1>\n};

    print qq{[ <a href="$self">$lex{'Delete More Records'}</a> ]\n};
    print qq{</body></html>\n};

    exit;

}
