#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Change Lunch Paid' => 'Change Lunch Paid',
	   'Start Date' => 'Start Date',
	   'End Date' => 'End Date',
	   'View Selected' => 'View Selected',
	   'Select Dates' => 'Select Dates',
	   'Select All' => 'Select All',
	   'Select None' => 'Select None',
	   'Lunch Attendance' => 'Lunch Attendance',
	   'Update' => 'Update',
	   'Change' => 'Change',
	   'Name' => 'Name',
	   'Date' => 'Date',
	   'Fee Type' => 'Fee Type',
	   'Meal' => 'Meal',
	   'Amount' => 'Amount',
	   'Paid' => 'Paid',
	   'Fees' => 'Fees',
	   'Main' => 'Main',
	   'Error' => 'Error',

	   );

my $self = 'changepaid.pl'; # - change the state of the paid field.

use DBI;
use CGI;
use Cwd;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get current dir so know what CSS to display;
if (getcwd() =~ /tcgi/){ # we are in tcgi
    $css = $tchcss;
}


# Print Page Header
my $title = $lex{'Change Lunch Paid'};
print qq{$doctype\n<html><head><title>$title</title>
 <link rel="stylesheet" href="$css" type="text/css">
 </head><body><a name="top"></a>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$feespage">$lex{Fees}</a> ]\n};

if ($arr{writeflag}){ # passed an id to delete...
    delete $arr{writeflag};
    updateRecords();
    print qq{</body></html>\n};
    exit;
}


print qq{<form action="$self" method="post" style="display:inline;">\n};
print qq{<input type="submit" value="$lex{'Select All'}">\n};
print qq{<input type="hidden" name="selectall" value="1">\n};
print qq{<input type="hidden" name="startdate" value="$arr{startdate}">\n};
print qq{<input type="hidden" name="enddate" value="$arr{enddate}">\n};
print qq{</form>\n};

print qq{<form action="$self" method="post" style="display:inline;">\n};
print qq{<input type="submit" value="$lex{'Select None'}">\n};
print qq{<input type="hidden" name="selectnone" value="1">\n};
print qq{<input type="hidden" name="startdate" value="$arr{startdate}">\n};
print qq{<input type="hidden" name="enddate" value="$arr{enddate}">\n};
print qq{</form>\n};



if (not $arr{startdate}) {
    showEntryPage();
    exit;
}

if ( $arr{selectall} ) {
    $checked = 'CHECKED';
} elsif ( $arr{selectnone} ) {
    $checked = q{};
}


$sth = $dbh->prepare("select * from attend_lunch
  where to_days(attdate) >= to_days(?) and to_days(attdate) <= to_days(?)
  order by attdate,studnum");
$sth->execute( $arr{startdate}, $arr{enddate} );
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
$rows = $sth->rows;

print qq{<h1>$title</h1>\n};


print qq{<form action="$self" method="post">\n};
print qq{<input type="hidden" name="writeflag" value="1">\n};
print qq{<input type="submit" value="$lex{'Update'}">\n};
print qq{<table border="1" cellpadding="2" cellspacing="0">\n};

print qq{<tr><th>$lex{Name}</th><th>$lex{Date}</th>\n};
print qq{<th>$lex{'Fee Type'}</th><th>$lex{Meal}</th><th>$lex{Amount}</th>};
print qq{<th>$lex{Paid}</th><th>$lex{Change}</th></tr>\n};

my $colcolor = 'gray'; # tr colors are blue or gray;
my $currdate = -1;


$sth1 = $dbh->prepare("select lastname, firstname from studentall 
  where studnum = ?");

while ( my ( $id,$studnum,$attdate,$feeType,$mealType,$amount,$paid,$posted)
	= $sth->fetchrow ) {

    $sth1->execute($studnum);
    my ($lastname, $firstname) = $sth1->fetchrow;

    $prevdate = $currdate;
    $currdate = $attdate;

    if ($prevdate ne $currdate){
	if ($colcolor eq 'blue'){ 
	    $colcolor = 'gray';
	} else { 
	    $colcolor = 'blue';
	}
    }

    print qq{<tr class="$colcolor"><td>$firstname $lastname ($studnum)</td>\n};
    print qq{<td>$attdate</td><td>$feeType</td><td>$mealType</td><td>$amount</td><td>$paid</td>\n};
    print qq{<td class="cn">};
    print qq{<input type="checkbox" name="$id" value="1" $checked></td></tr>\n};
}

print qq{</table>};
print qq{<input type="submit" value="$lex{'Update'}">\n};
print qq{</form>\n};

print qq{[ <a href="$homepage">Main</a> | <a href="#top">Top</a> ]\n};
print qq{</center><p></p></body></html>};



#---------------
sub updateRecords { # update paid status of a record.
#---------------

    # foreach my $key (keys %arr){ print qq{KEY: $key VAL:$arr{$key}<br>\n}; }

    my $sth1 = $dbh->prepare("select paid, studnum, amount, attdate from attend_lunch where id = ?");
    my $sth2 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");


    foreach my $id (sort keys %arr) {

	$sth1->execute($id);
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my ($paid, $studnum, $amount, $attdate) = $sth1->fetchrow; 

	$sth2->execute($studnum);
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my ($lastname, $firstname) = $sth2->fetchrow;

	my $newpaid;
	if ($paid == 1) { 
	    $newpaid = $sql{default};
	} else {
	    $newpaid = '1';
	}
	

	my $sth = $dbh->prepare("update attend_lunch set paid = $newpaid where id = ? ");
	$sth->execute( $id );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	print qq{Updated $firstname $lastname - $attdate - Paid: $newpaid<br>\n};

    }


}


#----------------
sub showEntryPage {
#----------------
   
    print qq{<h1>$lex{'Select Dates'}</h1>\n};
    print qq{<form action="$self" method="post">\n};

    print qq{<table border="0" cellpadding="3" cellspacing="0">\n};

    print qq{<tr><td class="ra">$lex{'Start Date'}</td><td>};
    print qq{<input type="text" size="10" name="startdate"></td></tr>\n};

    print qq{<tr><td class="ra">$lex{'End Date'}</td><td>};
    print qq{<input type="text" size="10" name="enddate"></td></tr>\n};

    print qq{<tr><td class="cn" colspan="2">};
    print qq{<input type="submit" value="$lex{'View Selected'}"></td></tr>\n};

    print qq{</table></form>\n};



}
