#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Record(s) Deleted' => 'Record(s) Deleted',
	   'Lunch Attendance' => 'Lunch Attendance',
	   'View Lunch Attendance' => 'View Lunch Attendance',
	   'Name' => 'Name',
	   'Date' => 'Date',
	   'Fee Type' => 'Fee Type',
	   'Meal' => 'Meal',
	   'Amount' => 'Amount',
	   'Delete' => 'Delete',
	   'Paid' => 'Paid',
	   'Post' => 'Post',
	   'Grade' => 'Grade',
	   'Fees' => 'Fees',
	   'Main' => 'Main',
	   'No Records Found' => 'No Records Found',
	   'Error' => 'Error',

	   );


use DBI;
use CGI;
use Cwd;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

if ( $arr{group} eq $lex{Grade} ){ 
    $group = 'grade';
} else {
    $group = 'homeroom';
}

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get current dir so know what CSS to display;
if (getcwd() =~ /tcgi/){ # we are in tcgi
    $css = $tchcss;
}

# Print Page Header
print "$doctype\n<html><head><title>". $lex{'View Lunch Attendance'}. "</title>
 <link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
 </head><body><a name=\"top\"></a>[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print "<a href=\"$feespage\">". $lex{Fees}. "</a> ]\n";

if ( $arr{id} ){ # passed an id to delete...
    deleteRecord();
    print "</body></html>\n";
    return;
}


$sth = $dbh->prepare("select * from attend_lunch 
  order by attdate desc, studnum");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
$rows = $sth->rows;

print "<center><h1>". $lex{'Lunch Attendance'}. "</h1>\n";

if ($rows < 1 ) {
    print "<p>". $lex{'No Records Found'}. "</p>\n";
    print "</body></html>\n";
    return;
}

print "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n";
print "<tr><th>". $lex{Name}. "</th><th>". $lex{Date}. "</th><th>\n";
print $lex{'Fee Type'}. "</th><th>". $lex{Meal}. "</th><th>". $lex{Amount};
print "</th><th>". $lex{Paid}. "</th><th>". $lex{Post};
print "</th><th>". $lex{Delete}. "</th></tr>\n";

my $colcolor = 'gray'; # tr colors are blue or gray;
my $currdate = -1;


$sth1 = $dbh->prepare("select lastname, firstname from studentall 
  where studnum = ?");

while (my ($id,$studnum,$attdate,$feeType,$mealType,$amount,$paid,$posted) = $sth->fetchrow){

    $sth1->execute($studnum);
    my ($lastname, $firstname) = $sth1->fetchrow;

    $prevdate = $currdate;
    $currdate = $attdate;

    if ($prevdate ne $currdate){
	if ($colcolor eq 'blue'){ 
	    $colcolor = 'gray';
	} else { 
	    $colcolor = 'blue';
	}
    }

    print "<tr class=\"$colcolor\"><td>$firstname $lastname ($studnum)</td>\n";
    print "<td>$attdate</td><td>$feeType</td><td>$mealType</td><td>$amount</td>\n";
    print "<td>$paid</td><td>$posted</td><td><a href=\"lunchview.pl?id=$id\">Delete</a></tr>\n";
}

print "</table>\n";
print "[ <a href=\"$homepage\">Main</a> | <a href=\"#top\">Top</a> ]\n";
print "</center><p></p></body></html>\n";



#---------------
sub deleteRecord { # delete a single lunch record
#---------------

    #foreach my $key (keys %arr){ print "KEY: $key VAL:$arr{$key}<br>\n"; }

    my $sth = $dbh->prepare("delete from attend_lunch where id = ?");
    $sth->execute( $arr{id} );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}

    print "<h1>". $lex{'Record(s) Deleted'}. "</h1>\n";

}
