#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Add' => 'Add',
	   'Save' => 'Save',
	   'Predefined Fees' => 'Predefined Fees',
	   'Grade' => 'Grade',
	   'Homeroom' => 'Homeroom',
	   'Main' => 'Main',
	   'Fees' => 'Fees',
	   'Name' => 'Name',
	   'Description' => 'Description',
	   'Amount' => 'Amount',
	   'Percent Discount' => 'Percent Discount',
	   'Group' => 'Group',
	   'Record(s) stored' => 'Record(s) stored',
	   'Student Number' => 'Student Number',
	   'Separate with Spaces' => 'Separate with Spaces',
	   'Error' => 'Error',

	   );

my $self = 'predefadd.pl';


use CGI;
use DBI;
use Cwd;


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

eval require "../../etc/fees.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

# calc current date
my @tim = localtime(time);
my $year = @tim[5] + 1900;
my $month = @tim[4] + 1;
my $day = @tim[3];
my $currdate = "$year-$month-$day";

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Page Header
my $title = qq{$lex{Add} $lex{'Predefined Fees'}};

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$feespage">$lex{Fees}</a> ]\n};

print qq{<h1>$title</h1>\n};

if ( $arr{writeflag} ){ # Write values and exit;
    delete $arr{writeflag};
    writeRecords();
}


# Start form and start of table.
print qq{<form action="$self" method="post">\n};
print qq{<input type="hidden" name="writeflag" value="1">\n};
print qq{<table cellpadding="3" border="0" cellspacing="0">\n};

print qq{<tr><td class="bra">$lex{Name}</td><td class="la">\n};
print qq{<input type="text" name="name" size="12" maxlength="16">\n};
print qq{</td></tr>\n};

print qq{<tr><td class="bra">$lex{Description}</td><td class="la">\n};
print qq{<input type="text" name="description" size="30" maxlength="255">\n};
print qq{</td></tr>\n};

print qq{<tr><td class="bra">$lex{Amount}</td><td class="la">\n};
print qq{<input type="text" name="amount" size="6">\n};
print qq{</td></tr>\n};

print qq{<tr><td class="bra">$lex{'Percent Discount'}</td><td class="la">\n};
print qq{<input type="text" name="discount" size="3">\n};
print qq{</td></tr>\n};

for my $i (1..4) {
    my $taxname = 'f_Tax'. $i;
    if ( $$taxname{'rate'} ) {
	my $fieldname = 'tax'. $i. '_flag';
	print qq{<tr><td class="bra">$$taxname{'name'}</td><td class="la">\n};
	print qq{<input type="checkbox" name="$fieldname" value="1">\n};
	print qq{</td></tr>\n};
    }
}


# Group and Value
print qq{<tr><td class="bra">$lex{Group}</td><td class="la">\n};
print qq{<select name="group_name">\n};
print qq{<option value="grade">$lex{Grade}</option>\n};
print qq{<option value="homeroom">$lex{Homeroom}</option>\n};
#print qq{<option value="studnum">$lex{'Student Number'}</option>\n};
print qq{</select> <input type="text" name="group_value" size="7"> $lex{'Separate with Spaces'}</td></tr>\n};


# Print Submit Row
print qq{<tr><td colspan="4" class="cn">\n};
print qq{<input type="submit" value="$lex{Save}"></td></tr>\n};

print qq{</table>\n</form></body></html>\n};



#---------------
sub writeRecords {
#---------------

    # foreach my $key ( sort keys %arr){ print qq{K:$key VAL:$arr{$key}<br>\n}; }

    my @groupvalues = split(/\s+/, $arr{group_value});

    my $sth = $dbh->prepare("insert into fees_predefined 
      ( name, description, amount, discount, tax1_flag, tax2_flag, 
        tax3_flag, tax4_flag, group_name, group_value )
        values( ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");

    foreach my $grp ( @groupvalues ) {

	my $name = "$arr{name}-$grp";

	$sth->execute( $name, $arr{description}, $arr{amount}, $arr{discount}, 
		       $arr{tax1_flag}, $arr{tax2_flag}, $arr{tax3_flag}, $arr{tax4_flag}, 
		       $arr{group_name}, $grp );

	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    }


    print qq{<h3>$lex{'Record(s) stored'}</h3>\n};
    print qq{<p>[ <a href="$self">$title</a> | };
    print qq{<a href="$feespage">$lex{Fees}</a> ]</p></body></html>\n};

    exit;

} # End of updateRecord
