#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Save' => 'Save',
	   'Records Updated' => 'Records Updated',
	   'Edit' => 'Edit',
	   'Transactions' => 'Transactions',
	   'Date' => 'Date',
	   'Type' => 'Type',
	   'Name' => 'Name',
	   'Description' => 'Description',
	   'Amount' => 'Amount',
	   'Receipt' => 'Receipt',
	   'Id' => 'Id',
	   'No Records Found' => 'No Records Found',
	   'Paid' => 'Paid',
	   'Balance' => 'Balance',
	   'Fees' => 'Fees',
	   'Main' => 'Main',
	   'Error' => 'Error',

	   );

my $self = 'transacted.pl';

use DBI;
use CGI;
use Number::Format qw(:all);

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@<br>\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $studnum = $arr{studnum};

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Head.
my $title = "$lex{Edit} $lex{Transactions}";

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};

# No links so have to use back button.
#print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
#print qq{<a href="$attpage">$lex{Fees}</a> ]\n};

print qq{<center><h1>$title</h1>\n};

if ( not $arr{page} ) {
    showStartPage();
} else {
    delete $arr{page};
    updateRecord();
}



#----------------
sub showStartPage {
#----------------

    showTransactions( $studnum ); # prints a table.
    print qq{<p>Fill Paid_Id and Receipt fields (if blank) with the id value };
    print qq{and receipt value from the final payment.</p>\n};

    my $sth = $dbh->prepare("select * from fees_jrl where studnum = ? 
      and paid_id is NULL or paid_id = 0"); 
    $sth->execute( $studnum );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellspacing="0" cellpadding="3" border="1">\n};
    # Print Table Header
    print qq{<table border="1" cellpadding ="3" cellspacing="0">\n};
    print qq{<tr><th>$lex{Id}</th><th>$lex{Date}</th><th>$lex{Type}</th>};
    print qq{<th>$lex{Name}</th><th>$lex{Description}</th>};
    print qq{<th>$lex{Amount}</th><th>$lex{Paid} $lex{Id}</th><th>$lex{Receipt}</th></tr>\n};
    
    while ( my $ref = $sth->fetchrow_hashref ) {

	print qq{<tr><td>$ref->{id}</td><td>$ref->{trans_date}</td><td>$ref->{trans_type}</td>\n};
	print qq{<td>$ref->{name}</td><td>$ref->{description}</td><td>$ref->{total}</td>\n};

	print qq{<td><input type="text" size="6" name="P:$ref->{id}" value="$ref->{paid_id}"></td>\n};
	print qq{<td><input type="text" size="6" name="R:$ref->{id}" value="$ref->{receipt}"></td>\n};
	print qq{</tr>\n};

    }

    print qq{<tr><td colspan="8" class="cn"><input type="submit" value="$lex{Save}"></td></tr>\n};
    print qq{</table></form>\n};

}



#---------------
sub updateRecord {
#---------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    foreach my $key ( keys %arr ) {
	if ( not $arr{$key} ) { next; } # skip over blank values
	my ( $type, $id ) = split(':', $key);

	if ( $type eq 'P' ) {
	    $field = 'paid_id';
	} elsif ( $type eq 'R' ) {
	    $field = 'receipt';
	} else {
	    print qq{Error in Type: $key<br>\n};
	    exit;
	}

	my $sth = $dbh->prepare("update fees_jrl set $field = ? where id = ?");
	$sth->execute( $arr{$key}, $id );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    }

    print qq{<h3>$lex{'Records Updated'}</h3>\n};
    print qq{</body></html>\n};

    exit;

}


#-------------------
sub showTransactions {
#-------------------

    my $studnum = shift; # studnum passed.

    # Find  student transactions.
    my $sth1 = $dbh->prepare("select id, trans_date, trans_type, name, description, total, 
     paid_id, receipt from fees_jrl where studnum = ? order by trans_date, id");
    $sth1->execute( $studnum );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

    my $balance;
    my $first = 1;

    while ( my ($id, $trans_date, $trans_type, $name, 
		$description, $total, $paid_id, $receipt ) = $sth1->fetchrow ) {

	if ( $first ) {
	    # Print Table Header
	    print qq{<table border="1" cellpadding ="3" cellspacing="0">\n};
	    print qq{<tr><th>$lex{Id}</th><th>$lex{Date}</th><th>$lex{Type}</th>};
	    print qq{<th>$lex{Name}</th><th>$lex{Description}</th>};
	    print qq{<th>$lex{Amount}</th><th>$lex{Paid} $lex{Id}</th><th>$lex{Receipt}</th></tr>\n};
	    $first = 0;
	}
 
	$balance += $total;

	print qq{<tr><td>$id</td><td>$trans_date</td><td>$trans_type</td><td>$name</td><td>$description</td>\n};
	print qq{<td>$total</td><td>$paid_id</td><td>$receipt</td></tr>\n};
    }

    if ( $first ) {
	print qq{<p><span style="border:1px solid gray;padding:0.4em;">$lex{'No Records Found'}</span></p>\n};
    } else {
	# Show Balance Due
	$balanceduefmt = format_number( $balance, 2,2);
	print qq{<tr style="font-weight:bold;font-size:130%;">\n};
	print qq{<td colspan="5" style="text-align:right;"><b>$lex{Balance}</b></td>};
	print qq{<td>$balanceduefmt</td><td></td><td></td></tr>\n};
    }

    print qq{</table>\n};

}
