#!/usr/bin/perl
#  Copyright 2001-2023 Leslie Richardson

my %lex = ('View Special Needs Students' => 'View Special Needs Students',
	   'Main' => 'Main',
	   'Name' => 'Name',
	   'Id' => 'Id',
	   'Description' => 'Description',
	   'Designation' => 'Designation',
	   'DDPF Level' => 'DDPF Level',
	   'Des Date' => 'Des Date',
	   'Medical' => 'Medical',
	   'Medication' => 'Medication',
	   'Equipment' => 'Equipment',
	   'Adaptations' => 'Adaptations',
	   'History' => 'History',
	   'View Detailed Report' => 'View Detailed Report',
	   'Error' => 'Error',
	   'Bdate' => 'Bdate',
	   'Grade' => 'Grade',
	   'School' => 'School',
	   'Gender' => 'Gender',
	   'Studnum' => 'Studnum',
	   'ProvNum' => 'ProvNum',
	   
	   );


use DBI;
use CGI;
use Cwd;

# Set prepath for config file: (/tcgi or cgi/schedule)
my $prepath = '../..';
if ( getcwd() =~ /tcgi/){ # we are in tcgi
    $prepath = '..';
}

# Read config variables
eval require "$prepath/etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


if ( getcwd() =~ m/tcgi/){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;



my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, 
 $iddst) = localtime(time);
$year = $year + 1900;
$mon++;
$wday++;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";

my $schooldbase = $dbase; # from admin.conf


# Disable for associate schools.
if ( not $iepdir ) { # associate school only, using local IEP system.
    print qq{$doctype\n<html><head><title>$title</title>\n};
    print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
    print qq{<h2>Global IEP records not available</h2>\n};
    print qq{</body></html>\n};
    exit;
}

# don't move this up...
require "$iepdir/cgi/ppp.conf" || die "Cannot read the ppp.conf file!";

# Reset these values;
if ( getcwd() =~ m/tcgi/){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}

my $userid = $ENV{'REMOTE_USER'};


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# print qq{DB:$dbase School:$schooldbase<br>\n};

my $sortorder = "lastname, firstname";

$sth = $dbh->prepare("select * from special where school = ? order by $sortorder");
$sth->execute($schooldbase);
if ($DBI::errstr){ print $DBI::errstr; die; }

my $sth1 = $dbh->prepare("select count(*) from team where studnum = ? and userid = ?"); 
my $sth2 = $dbh->prepare("select * from special where studnum = ?"); 

my $title = $lex{'View Special Needs Students'};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};


print qq{<style>td.rat { text-align:right;vertical-align:top; }};
print qq{ td.brat { text-align:right;vertical-align:top;font-weight:bold; }</style>\n};
print qq{$chartype</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};
print qq{<span><b>Userid</b> $userid</span>\n};

# check students' team for this userid....
my @students;
while ( my $ref = $sth->fetchrow_hashref ) {
    my %r = %$ref;
    my $studnum = $r{studnum};

    $sth1->execute( $studnum, $userid );
    if ($DBI::errstr){ print $DBI::errstr; die; }
    my $count = $sth1->fetchrow;
    if ( $count ) {
	push @students, $studnum;
    }
}


print qq{<h1>$title - $schoolname</h1><h3>$currdate</h3>\n};

if ( not @students ) {
    print qq{<h2 style="color:red;">Access Denied</h2>\n};
    print qq{</body></html>\n};
    exit;
} else {
#    print qq{<div>A Member of these Student Teams: @students</div>\n};
}


print qq{<table border="1" cellspacing="0" cellpadding="3">\n};
print qq{<tr><th>$lex{Name}/$lex{Id}</th><th>$lex{Description}</th></tr>\n};

foreach my $studnum ( @students ) {

    $sth2->execute( $studnum );
    if ($DBI::errstr){ print $DBI::errstr; die; }
    my $ref = $sth2->fetchrow_hashref;
    my %r = %$ref;
    my $school = $r{school};

    
    print qq{<tr><td style="vertical-align:top;">\n<table>\n};
    print qq{<tr><td colspan="2" class="cn"><b>$r{firstname} $r{lastname}</b></td></tr>\n};
    print qq{<tr><td class="ra"><em>$lex{Bdate}:</em></td><td>$r{birthdate}</td></tr>\n};
    print qq{<tr><td class="ra"><em>$lex{Grade}:</em></td><td>$r{grade}</td></tr>\n};

    print qq{<tr><td class="ra"><em>$lex{Gender}:</em></td><td>$r{sex}</td></tr>\n};
    print qq{<tr><td class="ra"><em>$lex{Studnum}:</em></td><td>$r{studnum}</td></tr>\n};
    print qq{<tr><td class="ra"><em>$lex{ProvNum}:</em></td><td>$r{provnum}</td></tr>\n};
    print qq{<tr><td class="cn" colspan="2">\n};
    
    print qq{<form action="specedfull.pl" method="post">\n};
    print qq{<input type="hidden" name="studnum" value="$r{studnum}">\n};
    print qq{<input type="hidden" name="school" value="$school">\n};

    
    print qq{<input type="submit" value=" $lex{'View Detailed Report'} "></form>\n};
    print qq{</td></tr></table>\n};

    print qq{</td><td style="vertical-align:top;">\n};

    print qq{<table>\n<tr><td class="brat">$lex{Designation}</td>\n};
    print qq{<td style="vertical-align:top;">$r{designation}</td></tr>\n};

    print qq{<tr><td class="ra" style="vertical-align:top;"><b>$lex{Medical}</b></td>\n};
    print qq{<td style="vertical-align:top;">$r{medical}</td></tr>\n};

    print qq{<tr><td class="ra" style="vertical-align:top;"><b>$lex{Medication} };
    print qq{</b></td><td style="vertical-align:top;">$r{medication}</td></tr>\n};

    print qq{<tr><td class="ra" style="vertical-align:top;"><b>$lex{Equipment} };
    print qq{</b></td><td style="vertical-align:top;">$r{equipment}</td></tr>\n};

    print qq{<tr><td class="ra" style="vertical-align:top;"><b>$lex{Adaptations} };
    print qq{</b></td><td style="vertical-align:top;">$r{adapt}</td></tr>\n};


    
    print qq{<tr><td class="bra" style="vertical-align:top;">$lex{History}</td>};
    print qq{<td style="vertical-align:top;">$r{history}</td></tr>\n};

    print qq{<tr><td class="bra" style="vertical-align:top;">Strengths</td> };
    print qq{<td style="vertical-align:top;">$r{strengths}</td></tr>\n};
   

    print qq{<tr><td class="bra" style="vertical-align:top;">Challenges</td> };
    print qq{<td style="vertical-align:top;">$r{challenges}</td></tr>\n};

    print qq{<tr><td class="bra" style="vertical-align:top;">Assessments</td> };
    print qq{<td style="vertical-align:top;">$r{assessments}</td></tr>\n};

    print qq{<tr><td class="bra" style="vertical-align:top;">Additional</td> };
    print qq{<td style="vertical-align:top;">$r{Additional}</td></tr>\n};

    print qq{</table>\n};


}

print qq{</table></body></html>\n};
