#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# Student Picture View. View Students who have pictures.

my %lex = ('Main' => 'Main',
	   'Export' => 'Export',
	   'View Students by Grade' => 'View Students by Grade',
	   'No Pictures Found' => 'No Pictures Found',
	   'Grade' => 'Grade',
	   'Record Updated' => 'Record Updated',
	   'Delete Failed' => 'Delete Failed',
	   'Error' => 'Error',

	   );

my $self = 'studpicview.pl';

use CGI;
use DBI;

my $picsPerPage = 10;  # default value

my $viewdir = $tndir;
my $viewheight = 75;
my $divheight = 120;
my $divwidth = 80;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

eval require "../../etc/image.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
my %arr= $q->Vars;
print $q->header( -charset, $charset );

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = $lex{'View Students by Grade'};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" type="text/css" href="$css">\n};
print qq{<style type="text/css">
body { background-color: #DC9;}
div.pic { float:left; height:$divheight px; width:$divwidth px; padding: 10px; 
 border: 1px solid; border-color:#AAA #AAA #444 #444; margin:3px; 
 background-color: #EEE;
}
</style>
$chartype\n</head><body>\n};

print qq{<div>[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$exppage">$lex{Export}</a> ]</div>\n};

print qq{<h1>$title</h1>\n};


my $sth = $dbh->prepare("select count(pic) from student where pic = 'Y'");
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
my $piccount = $sth->fetchrow;

if (not $piccount){ 
    print qq{<p>$lex{'No Pictures Found'}</p></body></html>\n};
    exit;
} 

my @grades;
my $sth = $dbh->prepare("select distinct grade from student");
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
while ( my $gr = $sth->fetchrow ) {
    push @grades, $gr;
}
@grades = sort {$a <=> $b} @grades;


my $sth = $dbh->prepare("select lastname, firstname, studnum, grade, homeroom
			from student where pic = 'Y' and grade = ? order by lastname, firstname");

my $firstflag = 1;
$currgrade = -1;

foreach my $grade ( @grades ) {

    my $first = 1;
    print qq{<div style="font-weight:bold;font-size:120%;margin:1em;">$lex{Grade} $grade</div>\n};

    $sth->execute($grade);
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
    
    while ( my ( $lastname, $firstname, $studnum, $grade, $homeroom ) = $sth->fetchrow){

	print qq{<div class="pic"><a href="$picdirurl/$studnum.jpg">};
	print qq{<img src="$tndirurl/$studnum.jpg" };
	print qq{height="$viewheight"></a>};
	print qq{<br><b>$firstname $lastname</b><br>($studnum) };
	print qq{$lex{Grade} $grade</div>\n\n};
	$first = 0;

    }
    print qq{<div style="clear:both"></div>\n};
    if ( $first ) { print qq{<div>No Students have pictures</div>\n}; }
    
    
} # end of grade loop

print qq{</body></html>\n};



#-----------
sub doDelete { # Delete Picture files
#-----------

    my $filename = shift;
    my $result = system ("rm -f $picdir/$filename");
    my $result = system ("rm -f $tndir/$filename");

    if ($result){ 
	print qq{$lex{Error}$lex{'Delete Failed'}: $filename $?<br>\n};

    } else {
	print qq{$filename removed successfully.<br>\n};
	
	# If associated, removed picture tag in student record
	my ($studnum,$ext) = split /\./,$filename;
	if ($studnum =~ m/\d/){
	    my $sth = $dbh->prepare("update student set pic = NULL 
				    where studnum = ?");
	    $sth->execute( $studnum );
	    if ( $DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	    print qq{<div>$lex{'Record Updated'}</div>\n};
	}
    }
}
