#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Main' => 'Main',
	   'Fees' => 'Fees',
	   'Lock Number' => 'Lock Number',
	   'Combination' => 'Combination',
	   'Comment' => 'Comment',
	   'Edit Lock' => 'Edit Lock',
           'Update Entry' => 'Update Entry', 
           'Lock Record Edited' => 'Lock Record Edited', 
	   'Error' => 'Error',
	   'Pool' => 'Pool',

	   );

my $self = 'lockedit.pl';

use CGI;
use DBI;
use Cwd;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get current dir so know what CSS to display;
if (getcwd() =~ /tcgi/){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}

# Show page Header
print "$doctype\n<html><head><title>". $lex{'Edit Lock'}. "</title>\n";
print "<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "$chartype\n</head><body>[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print " <a href=\"$feespage\">". $lex{Fees}. "</a> ]\n";

print "<center><h1>". $lex{'Edit Lock'}. "</h1>\n";

if ( $arr{writeflag} ){ # Write values and exit;
    delete $arr{writeflag};
    updateRecord();
}

$sth = $dbh->prepare("select * from lok_lock where id = ? "); 
$sth->execute( $arr{id} );
if ( $DBI::errstr ) {print $DBI::errstr; die $DBI::errstr;}
my ( $id,$lock_num, $combination, $pool, $comment ) = $sth->fetchrow;

# Setup the form and start of table.
print "<form action=\"$self\" method=\"post\">\n";
print "<input type=\"hidden\" name=\"writeflag\" value=\"1\">\n";
print "<input type=\"hidden\" name=\"id\" value=\"$arr{id}\">\n";
print "<table cellpadding=\"3\" border=\"0\" cellspacing=\"0\">\n";


print "<tr><td align=\"right\">". $lex{'Lock Number'}. "</td>\n";
print "<td align=\"left\">\n";
print "<input type=\"text\" name=\"lock_num\" value = \"$lock_num\" ";
print "size=\"12\" maxlength=\"12\">\n";
print "</td></tr>\n";

print "<tr><td align=\"right\">". $lex{Combination};
print "</td><td align=\"left\">\n";
print "<input type=\"text\" name=\"combination\" ";
print "value = \"$combination\"  size=\"12\" maxlength=\"12\">\n";
print "</td></tr>\n";

print "<tr><td align=\"right\">". $lex{Pool};
print "</td><td align=\"left\">\n";
print "<input type=\"text\" name=\"pool\" ";
print "value = \"$pool\" size=\"12\">\n";
print "</td></tr>\n";

print "<tr><td align=\"right\">". $lex{Comment};
print "</td><td align=\"left\">\n";
print "<input type=\"text\" name=\"comment\" ";
print "value = \"$comment\" size=\"50\">\n";
print "</td></tr>\n";


# Print Submit Row
print "<tr><td colspan=\"4\" align=\"center\">";
print "<input type=\"submit\" value=\"". $lex{'Update Entry'}. "\"></td></tr>\n";
print "</table>\n</form></center></body></html>\n";



#---------------
sub updateRecord {
#---------------

    my $id = $arr{id};
    delete $arr{id};

    #foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    foreach my $key ( sort keys %arr ) { 
	my $sth = $dbh->prepare("update lok_lock set $key = ? where id = ?");
	$sth->execute( $arr{$key}, $id );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    }

    print "<b>". $lex{'Lock Record Edited'}. "</b>\n";
    print "<p>[ <a href=\"$feespage\">". $lex{Fees}. "</a> ]</p>\n";
    print "</body></html>\n";

    exit;

} # End of updateRecord
