#!/usr/bin/perl
#  Copyright 2001-2011 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Main' => 'Main',
	   'Fees' => 'Fees',
	   'Locker Number' => 'Locker Number',
	   'Add Another' => 'Add Another',
	   'Cleaned' => 'Cleaned',
	   'Comment' => 'Comment',
	   'Starting Number' => 'Starting Number',
	   'Ending Number' => 'Ending Number',
	   'or' => 'or',
	   'Number to Add' => 'Number to Add',
	   'Bulk Comment' => 'Bulk Comment',
	   'Cleaned' => 'Cleaned',
	   'Location' => 'Location',
	   'Continue' => 'Continue',
	   'Save' => 'Save',
	   'Saved' => 'Saved',
	   'No' => 'No',
	   'Record(s) Stored' => 'Record(s) Stored',
	   'Error' => 'Error',
	   'Locker' => 'Locker',
	   'Add' => 'Add',
	   );

my $self = 'lockeradd.pl';


use CGI;
use DBI;
use Cwd;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get current dir so know what CSS to display;
if (getcwd() =~ /tcgi/){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}

# Show page Header
print "$doctype\n<html><head><title>$lex{Add} $lex{Locker}</title>\n";
print "<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "$chartype\n</head><body>[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print "<a href=\"$feespage\">". $lex{Fees}. "</a> ]\n";

print "<center><h1>$lex{Add} $lex{Locker}</h1>\n";

if ( not $arr{page} ) {
    showStartPage();
} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showLockers();
} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    addRecords();
}


#---------------
sub addRecords {
#---------------

    my $start = $arr{start};
    delete $arr{start};
    my $end = $arr{end};
    delete $arr{end};

    #foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    my $first = 1;
    for my $i ( $start .. $end ) {

	my $locker_num = $arr{"locker_num$i"};
	if ( not $locker_num ) { next; }
	my $location = $arr{"location$i"};
	my $cleaned = $arr{"cleaned$i"};
	my $comment = $arr{"comment$i"};

	#print "$i LN: $locker_num<br>\n";
	my $sth = $dbh->prepare("insert into lok_locker ( locker_num, location, cleaned, comment )
         values( ?, ?, ?, ? )");
	$sth->execute( $locker_num, $location, $cleaned, $comment );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	print "<div>". $lex{Saved}. " $i</div>\n";
	$first = 0;

    }

    if ( not $first ) { # records saved
	print "<p><b>". $lex{'Record(s) Stored'}. "</b></p>\n";
    } else {
	print "<p><b>". $lex{No}. q{ }. $lex{'Record(s) Stored'}. "</b></p>\n";
    }

    print "<p>[ <a href=\"$self\">$lex{'Add Another'} $lex{Locker}</a> | ";
    print "<a href=\"$feespage\">$lex{Fees}</a> ]</p></body></html>\n";

    exit;

} # End of updateRecord


#----------------
sub showStartPage {
#----------------

    print "<form action=\"$self\" method=\"post\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"1\">\n";
    print "<table cellpadding=\"3\" border=\"0\" cellspacing=\"0\">\n";

    print "<tr><td align=\"right\">". $lex{'Starting Number'};
    print "</td><td align=\"left\">\n";
    print "<input type=\"text\" name=\"startnum\" size=\"4\">\n";
    print "</td></tr>\n";

    print "<tr><td align=\"right\">". $lex{'Ending Number'};
    print "</td><td align=\"left\">\n";
    print "<input type=\"text\" name=\"endnum\" size=\"4\">\n";
    print "</td></tr>\n";

    print "<tr><td align=\"right\"><b>". $lex{or}. '</b> '. $lex{'Number to Add'};
    print "</td><td align=\"left\">\n";
    print "<input type=\"text\" name=\"addcount\" size=\"4\">\n";
    print "</td></tr>\n";

    print "<tr><td align=\"right\">". $lex{'Bulk Comment'};
    print "</td><td align=\"left\">\n";
    print "<input type=\"text\" name=\"comment\" size=\"25\">\n";
    print "</td></tr>\n";

    print "<tr><td align=\"right\">". $lex{Location};
    print "</td><td align=\"left\">\n";
    print "<input type=\"text\" name=\"location\" size=\"8\">\n";
    print "</td></tr>\n";
    
    print "<tr><td align=\"right\">". $lex{Cleaned};
    print "</td><td align=\"left\">\n";
    print "<input type=\"checkbox\" name=\"cleaned\" value=\"1\">\n";
    print "</td></tr>\n";

    # Print Submit Row
    print "<tr><td colspan=\"2\" align=\"center\">";
    print "<input type=\"submit\" value=\"". $lex{Continue}. "\"></td></tr>\n";

    print "</table></form></center></body></html>\n";

    exit;

} # end of showStartPage



#--------------
sub showLockers {
#--------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    my ( $checked, $comment, $location);
    if ( $arr{cleaned} ) { $checked = 'CHECKED'; }
    if ( $arr{comment} ) { $comment = $arr{comment}; }
    if ( $arr{location} ) { $location = $arr{location}; }

    my ($start, $end);
    if ( $arr{startnum} < 0 or not $arr{startnum} ) { 
	$start = 1;
    } else {
	$start = $arr{startnum};
    }

    if ( $arr{endnum} > 100000 or not $arr{endnum} ) { 
	if ( $arr{addcount} ) { $end = $arr{addcount}; } else { $end = 1000; }
    } else { 
	$end = $arr{endnum};
    }

    print "<form action=\"$self\" method=\"post\">\n";
    print "<input type=\"hidden\" name=\"page\" value=\"2\">\n";
    print "<input type=\"hidden\" name=\"start\" value=\"$start\">\n";
    print "<input type=\"hidden\" name=\"end\" value=\"$end\">\n";

    print "<input type=\"submit\" value=\"". $lex{Save}. "\">\n";

    print "<table cellpadding=\"3\" border=\"0\" cellspacing=\"0\">\n";

    print "<tr><th>". $lex{'Locker Number'}. "</th>\n<th>";
    print $lex{Location}. "</th>\n<th>". $lex{Cleaned}. "</th>\n<th>";
    print $lex{Comment}. "</th></tr>\n";

    for my $i ( $start .. $end ) {

	print "<tr><td align=\"left\"><b>$i.</b> ";
	print "<input type=\"text\" name=\"locker_num$i\" size=\"12\" maxlength=\"12\" ";
	if ( $arr{addcount} ) { print ">"; } else { print "value=\"$i\">"; }
	print "</td>\n";
	
	print "<td align=\"left\">";
	print "<input type=\"text\" name=\"location$i\" size=\"12\" value=\"$location\">";
	print "</td>\n";

	print "<td align=\"left\">";
	print "<input type=\"checkbox\" name=\"cleaned$i\" value=\"1\" $checked>";
	print "</td>\n";

	print "<td align=\"left\">";
	print "<input type=\"text\" name=\"comment$i\" size=\"50\" value=\"$comment\">";
	print "</td></tr>\n\n";

    }

    print "<tr><td colspan=\"4\" align=\"center\">\n";
    print "<input type=\"submit\" value=\"". $lex{Save}. "\">\n";
    print "</td></tr>";
    print "</form></table></body></html>\n";

    exit;

}
