#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Main' => 'Main',
	   'Fees' => 'Fees',
   	   'Locker Number' => 'Locker Number',
	   'Cleaned' => 'Cleaned',
	   'Comment' => 'Comment',
	   'Edit Locker' => 'Edit Locker',
           'Update Entry' => 'Update Entry', 
           'Locker Record Edited' => 'Locker Record Edited', 
	   'Error' => 'Error',
	   'Area' => 'Area',

	   );

my $self = 'lockeredit.pl';


use CGI;
use DBI;
use Cwd;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get current dir so know what CSS to display;
if (getcwd() =~ /tcgi/){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}

# Show page Header
print "$doctype\n<html><head><title>". $lex{'Edit Locker'}. "</title>\n";
print "<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "$chartype\n</head><body>[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print "<a href=\"$feespage\">". $lex{Fees}. "</a> ]\n";


print "<center><h1>". $lex{'Edit Locker'}. "</h1>\n";

if ( $arr{writeflag} ){ # Write values and exit;
    delete $arr{writeflag};
    updateRecord();
}

$sth = $dbh->prepare("select * from lok_locker where id = ?"); 
$sth->execute( $arr{id} );
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

my ( $id, $locker_num, $cleaned, $area, $comment ) = $sth->fetchrow;

# find out if the cleanded checkbox should be checked.
if ( $cleaned ){ $checked = 'checked'} else { $checked = '' };


# Setup the form and start of table.
print "<form action=\"$self\" method=\"post\">\n";
print "<input type=\"hidden\" name=\"writeflag\" value=\"1\">\n";
print "<input type=\"hidden\" name=\"id\" value=\"$id\">\n";
print "<table cellpadding=\"3\" border=\"0\" cellspacing=\"0\">\n";

print "<tr><td align=\"right\">". $lex{'Locker Number'}. "</td><td align=\"left\">\n";
print "<input type=\"text\" name=\"locker_num\" value=\"$locker_num\" ";
print "size=\"12\" maxlength=\"12\"></td></tr>\n\n";

print "<tr><td align=\"right\">". $lex{Area}. "</td><td align=\"left\">\n";
print "<input type=\"text\" name=\"area\" value = \"$area\" ";
print "size=\"12\" maxlength=\"12\"></td></tr>\n\n";

print "<tr><td align=\"right\">". $lex{Cleaned}. "</td><td align=\"left\">\n";
print "<input type=\"checkbox\" name=\"cleaned\" value=\"1\" size=\"1\" $checked>\n";
print "</td></tr>\n\n";

print "<tr><td align=\"right\">". $lex{Comment}. "</td><td align=\"left\">\n";
print "<input type=\"text\" name=\"comment\" value =\"$comment \" size=\"50\">\n";
print "</td></tr>\n\n";

# Print Submit Row
print "<tr><td colspan=\"4\" align=\"center\">";
print "<input type=\"submit\" value=\"". $lex{'Update Entry'}. "\"></td></tr>\n";

print "</table>\n</form></center></body></html>\n";



#---------------
sub updateRecord {
#---------------

    my $id = $arr{id};
    delete $arr{id}; 

    #foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    foreach my $key ( keys %arr ) {
	my $sth = $dbh->prepare("update lok_locker set $key = ? where id = ?");
	$sth->execute( $arr{$key}, $id);
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

    }
	
    print "<p><b>". $lex{'Locker Record Edited'}. "</b></p>\n";
    print "[ <a href=\"$feespage\">". $lex{Fees}. "</a> ]\n";
    print "</body></html>\n";

    exit;

} # End of updateRecord
