#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Record Deleted' => 'Record Deleted',
	   'Delete' => 'Delete',
	   'Grade' => 'Grade',
	   'Fees' => 'Fees',
	   'Main' => 'Main',
	   'No Records Found' => 'No Records Found',
	   'Top' => 'Top',
	   'Delete' => 'Delete',
           'Locker Number' => 'Locker Number',
           'Cleaned' => 'Cleaned',
           'Comment' => 'Comment',
           'Assigned' => 'Assigned', 
           'Status' => 'Status', 
           'View/Edit/Delete Lockers' => 'View/Edit/Delete Lockers',
	   'Error' => 'Error',
	   'Yes' => 'Yes',
	   'No' => 'No',
	   'Area' => 'Area',

	   );

my $self = 'lockerview.pl';

use DBI;
use CGI;
use Cwd;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

if ( $arr{group} eq $lex{Grade} ){ 
    $group = 'grade';
} else {
    $group = 'homeroom';
}


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get current dir so know what CSS to display;
if ( getcwd() =~ /tcgi/ ){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}

# Print Page Header
print "$doctype\n<html><head><title>". $lex{'View/Edit/Delete Lockers'}. "</title>\n";
print "<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "</head><body><a name=\"top\"></a>\n";
print "[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print " <a href=\"$feespage\">". $lex{Fees}. "</a> ]\n";

if ( $arr{id} ){ # passed an id to delete...
    deleteRecord();
}


my $sth = $dbh->prepare("select * from lok_locker order by locker_num");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
my $rows = $sth->rows;

print "<center><h1>". $lex{'View/Edit/Delete Lockers'}. "</h1>\n";

if ( $rows < 1 ) {
    print "<p>". $lex{'No Records Found'}. "</p>\n";
    print "</body></html>\n";
    die;
}

print "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n";
print "<tr><th>". $lex{'Locker Number'}. "</th><th>". $lex{Area}. "</th><th>\n";
print $lex{Cleaned}. "</th><th>". $lex{Comment} . "</th>\n" ;
print "<th>". $lex{Status}. "</th></tr>\n";


my $colcolor = 'gray'; # tr colors are blue or gray;

while ( my ( $id, $locker_num, $cleaned, $area, $comment ) = $sth->fetchrow ) {

    if ( $cleaned ){ $cleaned = $lex{Yes}; } else { $cleaned = $lex{No}; }
    if ( $colcolor eq 'blue' ) { $colcolor = 'gray'; } else { $colcolor = 'blue'; }
    
    print "<tr class=\"$colcolor\"><td> <a href=\"lockeredit.pl?id=$id\">$locker_num</a></td>\n";
    print "<td>$area</td><td>$cleaned</td><td>$comment</td>\n";

    if ( checkAssignStatus($id) ) { # if the locker is assigned we do not want a Delete link
	print "<td>" . $lex{Assigned} . "</td></tr>\n";
    } else {
	print "<td><a href=\"$self?id=$id\">". $lex{Delete}. "</a></tr>\n";
    }
}

print "</table>\n";
print "[ <a href=\"$feespage\">". $lex{Fees}. "</a> |\n";
print " <a href=\"#top\">". $lex{Top}. "</a> ]</p>\n";
print "</center></body></html>\n";




#--------------------
sub checkAssignStatus { # check if locker is assigned
#--------------------

    my $locker_num = shift;

    # check if the locker is assigned
    my $sth = $dbh->prepare("select count(*) from lok_rlink where locker_num = ?");
    $sth->execute( $locker_num );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    my $count = $sth->fetchrow;    
    if ( $count ){ # if any rows are returned the locker is assigned
	return 1;
    } else {
	return 0;
    }
}


#---------------
sub deleteRecord { # delete a single record
#---------------

    # delete single record 

    my $sth = $dbh->prepare("delete from lok_locker where id = ?");
    $sth->execute( $arr{id} );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

    print "<div style=\"border:1px solid gray;\"><h1>". $lex{'Record Deleted'}. "</h1></div>\n";
    
}
