#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Record Deleted' => 'Record Deleted',
	   'Delete' => 'Delete',
	   'Fees' => 'Fees',
	   'Main' => 'Main',
	   'No Records Found' => 'No Records Found',
	   'Top' => 'Top',
	   'Delete' => 'Delete',
           'Lock Number' => 'Lock Number',
           'Combination' => 'Combination',
           'Comment' => 'Comment',
           'Assigned' => 'Assigned', 
           'Status' => 'Status', 
           'View/Edit/Delete Locks' => 'View/Edit/Delete Locks',
	   'Error' => 'Error',
	   'Pool' => 'Pool',

	   );

my $self = 'lockview.pl';

use DBI;
use CGI;
use Cwd;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get current dir so know what CSS to display;
if (getcwd() =~ /tcgi/){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}

# Print Page Header
print "$doctype\n<html><head><title>". $lex{'View/Edit/Delete Locks'}. "</title>\n";
print "<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "</head><body><a name=\"top\"></a>\n";
print "[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print "<a href=\"$feespage\">". $lex{Fees}. "</a> ]\n";

print "<center><h1>". $lex{'View/Edit/Delete Locks'}. "</h1>\n";


if ( $arr{id} ){ # passed an id to delete...
    deleteRecord();
}

my $sth = $dbh->prepare("select * from lok_lock order by lock_num");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
my $rows = $sth->rows;

if ( $rows < 1 ) {
    print "<p>". $lex{'No Records Found'}. "</p>\n";
    print "</body></html>\n";
    die;
}

print "<table border=\"1\" cellpadding=\"4\" cellspacing=\"0\">\n";
print "<tr><th>". $lex{'Lock Number'}. "</th><th>". $lex{Combination}. "</th><th>";
print $lex{Pool}. "</th><th>". $lex{Comment} . "</th>\n" ;
print "<th>". $lex{Status}. "</th></tr>\n";


my $colcolor = 'gray'; # tr colors are blue or gray;

while ( my ( $id, $lock_num, $combination, $pool, $comment ) = $sth->fetchrow ) {

    if ($colcolor eq 'blue'){ 
	$colcolor = 'gray';
    } else { 
	$colcolor = 'blue';
    }
    
    print "<tr class=\"$colcolor\"><td><a href=\"lockedit.pl?id=$id\">$lock_num</td>\n";
    print "<td>$combination</td><td>$pool</td><td>$comment</td>\n";

    if ( checkAssignStatus($id) ){ # if the lock is assigned we do not want a Delete link
	print "<td>" . $lex{Assigned} . "  </td></tr>\n";
    } else {
	print "<td><a href=\"$self?id=$id\">". $lex{Delete}. "</a></tr>\n";
    }
}

print "</table>\n";

print "<p>[ <a href=\"$feespage\">". $lex{Fees}. "</a> |\n";
print "<a href=\"#top\">". $lex{Top}. "</a> ]</p>\n";
print "</center></body></html>\n";



#--------------------
sub checkAssignStatus { # check if locker is assinged
#--------------------

    my $id = shift;

    # check if the locker is assigned
    my $sth1 = $dbh->prepare("select lock_num from lok_link where lock_num = ?");

    $sth1->execute( $id );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    my $rows1 = $sth1->rows;    
    if ( $rows1 ){ # if any rows are returned the lock is assigned
	return 1;
    } else {
	return 0;
    }
}


#---------------
sub deleteRecord { # delete a single record
#---------------

    # delete single record 

    my $sth = $dbh->prepare("delete from lok_lock where id = ?");
    $sth->execute( $arr{id} );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

    print "<div style=\"border:1px solid gray;\"><h1>". $lex{'Record Deleted'};
    print "</h1></div>\n";
    
}
