#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# Metaedit.pl - edit meta table for formtype, default values.

my %lex = ('Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'Save' => 'Save',
	   'Metadata' => 'Metadata',
	   'Edit' => 'Edit',
	   'Field Id' => 'Field Id',
	   'Field Name' => 'Field Name',
	   'Defaults' => 'Defaults',
	   'Form Type' => 'Form Type',
	   'View Size' => 'View Size',
	   'Reqd' => 'Reqd',
	   'Record(s) Updated' => 'Record(s) updated',
	   'Select' => 'Select',
	   'Error' => 'Error',
	   'Table' => 'Table',
	   'Include Description' => 'Include Description',
	   'Description' => 'Description',

	   );

$self = 'metaedit.pl';

$notes = 'The <b>Defaults</b> for <b>Select Form Entry</b>:
Separate items with a space (First Second),<br>
Join multiword entries with underscore character (which will be
stripped)(First_One Second_One),<br>
Items with leading tilde (~Choose_One~) will be ignored during student
entry.<br>
<b>Textarea Boxes</b>: put rows and cols in the viewsize field
separated with an x (ie. 6x80)';


use DBI;
use CGI;

# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = "$lex{Edit} $lex{Metadata}";

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
<style type="text/css">tr.bg { background-color:#06D;color:#FFF; }</style>
</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{ <a href="$eoypage">$lex{Eoy}</a> ]\n};

if ( not $arr{tableid} ) { # load and display table choices.
    showStartPage();
}

if ( $arr{flag} ) { # write the updates
    updateTable();
}


# Select table rows to update
my $sth = $dbh->prepare("select id, fieldid, datatype, arrayidx, 
 fieldname, defaultvalue, formtype,viewsize, required, description 
 from meta where tableid = ? order by arrayidx");
$sth->execute( $arr{tableid} );
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}

# section header
print qq{<h1>$title</h1>\n};

print qq{<form action="$self" method="post">\n};
print qq{<input type="hidden" name="flag" value="1">\n};
print qq{<input type="hidden" name="tableid" value="$arr{tableid}">\n};

my $tbl = ucfirst($arr{tableid});
print qq{<h1>$tbl $lex{Table}</h1>\n};

print qq{<input type="submit" value="$lex{Save}">\n};
print qq{<table border="1" cellpadding="3" cellspacing="0">\n};
print qq{<tr><td colspan="7" style="background-color:#EEE;">$notes</td></tr>\n};

print qq{<tr><th>$lex{'Field Id'}</th><th>$lex{'Field Name'}</th><th>$lex{Defaults}</th>\n};
print qq{<th>$lex{'Form Type'}</th><th>$lex{'View Size'}</th><th>$lex{'Reqd'}</th></tr>\n};

while ( my ( $id, $fieldid, $datatype, $arrayidx, $fieldname, $default, $formtype,
	     $viewsize, $required, $description ) = $sth->fetchrow){

    print qq{<tr><td>$fieldid [$datatype/$arrayidx]</td>\n};
    print qq{<td><input type="text" name="$id:fieldname" value="$fieldname" size="30"></td>\n};


    if ( length( $default ) > 45 ) {
	print qq{<td><textarea rows="3" cols="45" name="$id:defaultvalue">};
	print qq{$default</textarea></td>\n};
    } else {
	print qq{<td><input type="text" name="$id:defaultvalue" value="$default" };
	print qq{size="60"></td>\n};
    }

    # Select Input Options
    print qq{<td><select name="$id:formtype"><option>$formtype</option>\n};
    print qq{<option>text</option><option>select</option><option>selecthash</option>};
    print qq{<option>textarea</option><option>checkbox</option>};
    print qq{<option>readonly</option></select></td>\n};

    # View Size
    print qq{<td><input type="text" name="$id:viewsize" value="$viewsize"};
    print qq{ size="5"></td>\n};

    # Required
    my $checked;
    if ( $required ) { $checked= q{checked="checked"}; }
    print qq{<td><input type="checkbox" name="$id:required" value="Y" $checked>};
    print qq{</td></tr>\n\n};

    # Include Description
    if ( $arr{'incldesc'} ) {
	print qq{<tr class="bg"><td colspan="6">$lex{Description} };
	print qq{<input type="text" name="$id:description" size="150" };
	print qq{value="$description">};
	print qq{</td></tr>\n};
    }

}

print qq{</table><input type="submit" value="$lex{Save}">\n};
print qq{</form></body></html>};


#----------------
sub showStartPage { # show tables, etc. to choose from
#----------------

    # Get the table choices
    my $sth = $dbh->prepare("select distinct tableid from meta order by tableid");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    print qq{<h1>$lex{Select} $lex{Table}</h1>\n};
    print qq{<form action="$self" method="post">\n};

    while ( my $tableid = $sth->fetchrow ){

	print qq{<div style="padding:0.4em;">\n};
	print qq{<input type="radio" name="tableid" value="$tableid"> $tableid</div>};

    }

    print qq{<div  style="padding:0.4em;"><input type="submit" value="};
    print qq{$lex{Edit} $lex{Table}"></div>\n};
    print qq{<div  style="padding:0.4em;"><input type="checkbox" name="incldesc" };
    print qq{value="1"> };
    print $lex{'Include Description'};
    print qq{</div>\n</form></body></html>\n};

    exit;

}


#--------------
sub updateTable { # write updates to meta table.
#--------------

    delete $arr{flag}; # no longer required.
    delete $arr{tableid}; # not required.

    foreach my $key ( keys %arr ) {

	my ( $id, $field ) = split(/:/,$key);
	my $value = $arr{$key};

	#print qq{K: $key  ID: $id  FIELD: $field  VAL: $arr{$key}<br>\n};

	# Update the field
	$sth = $dbh->prepare("update meta set $field = ? where id = ?");
	$sth->execute( $value, $id );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

	# Check for Required Field deselected (since nothing sent when done).
	if ( $field eq 'fieldname' ) {
	    my $testkey = "$id:required";
	    if ( not $arr{ $testkey } ) {
		$sth = $dbh->prepare("update meta set required = '' where id = ?");
		$sth->execute( $id );
		if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	    }
	}


    }


    print qq{<p>$lex{'Record(s) Updated'}</p>\n};
    print qq{[ <a href="$self">$lex{Edit} $lex{Metadata}</a> ]};
    print qq{</body></html>\n};

    exit;

} # End of Update Table
