#!/usr/bin/perl
#  Copyright 2001-2025 Leslie Richardson

#  This file is part of Open Admin for Schools.

# Find students without mssid values, get their provnum if present,
# and look up their mssid value in mss_student table. If found update
# the student record mssid value.


use DBI;
use CGI;
use Cwd;

my $self = 'mssFixMssid.pl';


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Print Page Header
my $title = qq{Update MSSid Field};
print qq{$doctype\n<html><head><title>$title</title>
 <link rel="stylesheet" href="$css" type="text/css">
 </head>\n};

print qq{<body>[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$exppage">Export</a> ]\n\n};

# prep for updating the student record mssid value
my $sth1= $dbh->prepare("update student set mssid = ? where provnum = ?");

# Get students with missing mssid
my $sth = $dbh->prepare("select lastname, firstname, grade, provnum from student where mssid = 0 or mssid is NULL");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

while ( my ($ln,$fn,$gr,$provnum) = $sth->fetchrow ) {

    # print qq{<div>$fn $ln PN:$provnum</div>\n};
    
    if ( not $provnum ) {
	print qq{<div>No Provnum for $fn $ln (Gr $gr)</div>\n};
	next;
    }
    
    my $mssid = findStudent( $provnum );

    print qq{<div>PN:$provnum MSSID:$mssid</div>\n};

    if ( $mssid ) {  # update if we have a value.
	$sth1->execute($mssid, $provnum);
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    }


}





#--------------
sub findStudent {
#--------------

    my $provnum = shift @_;
#    print qq{Provnum:$provnum<br>\n};

    
    # Get mss Student table and lookup mssid and then matching provnum in order to find student
    my $sth = $dbh->prepare("select mssid from mss_student where provnum = ?");
    $sth->execute( $provnum );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $mssid = $sth->fetchrow;

    if ( $mssid ) { # return value
	return $mssid;
	
    } else {
	
	print qq{<div>No mssid for provincial number: $provnum</div>\n};
	return;
    }

}


    
