#!/usr/bin/perl

# update the student_inac table with correct values for new nominal roll.

use DBI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



my $sth = $dbh->prepare("select * from student_inac");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

# Loop Through all records
while ( my $ref = $sth->fetchrow_hashref ) {
    my %rec = %$ref;
    my $id = $rec{id};

    # Transportation - Daily
    if ( $rec{'transportation_daily'} =~ m/\(1\)/ ) {
	my $sth = $dbh->prepare("update student_inac set transportation_daily = '01' where id = ?");
	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{'transportation_daily'} =~ m/\(2\)/ ) {
	my $sth = $dbh->prepare("update student_inac set transportation_daily = '03' where id = ?");
	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{'transportation_daily'} =~ m/\(3\)/ ) {
	my $sth = $dbh->prepare("update student_inac set transportation_daily = '02' where id = ?");
	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{'transportation_daily'} =~ m/\(4\)/ ) {
	my $sth = $dbh->prepare("update student_inac set transportation_daily = '09' where id = ?");
	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{'transportation_daily'} =~ m/\(5\)/ ) {
	my $sth = $dbh->prepare("update student_inac set transportation_daily = '04' where id = ?");
	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } 


    # Transportation - Other
    if ( $rec{'transportation_other'} =~ m/\(1\)/ ) {
	my $sth = $dbh->prepare("update student_inac set transportation_other = '07' where id = ?");
	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{'transportation_other'} =~ m/\(2\)/ ) {
	my $sth = $dbh->prepare("update student_inac set transportation_other = '08' where id = ?");
	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{'transportation_other'} =~ m/\(3\)/ ) {
	my $sth = $dbh->prepare("update student_inac set transportation_other = '05' where id = ?");
	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{'transportation_other'} =~ m/\(4\)/ ) {
	my $sth = $dbh->prepare("update student_inac set transportation_other = '06' where id = ?");
	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{'transportation_other'} =~ m/\(5\)/ ) {
	my $sth = $dbh->prepare("update student_inac set transportation_other = '10' where id = ?");
	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } 


    # Accommodation
    if ( $rec{'accommodation'} =~ m/\(1\)/ ) {
	my $sth = $dbh->prepare("update student_inac set accommodation = '1680' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{'accommodation'} =~ m/\(2\)/ ) {
	my $sth = $dbh->prepare("update student_inac set accommodation = '1678.01' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{'accommodation'} =~ m/\(3\)/ ) {
	my $sth = $dbh->prepare("update student_inac set accommodation = '1673.01' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{'accommodation'} =~ m/\(4\)/ ) {
	my $sth = $dbh->prepare("update student_inac set accommodation = '1673.02' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{'accommodation'} =~ m/\(5\)/ ) {
	my $sth = $dbh->prepare("update student_inac set accommodation = '3425' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{'accommodation'} =~ m/\(6\)/ ) {
	my $sth = $dbh->prepare("update student_inac set accommodation = '1678.02' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    } 



    # HCSE 
    if ( $rec{'highcost'} =~ m/No/ ) {
	# Change to false...
	my $sth = $dbh->prepare("update student_inac set highcost = 'false' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	# print "ID:$id HCSE: $rec{highcost} No\n";

    } elsif ( $rec{'highcost'} =~ m/Yes/ ) {
	# Change to true...
	my $sth = $dbh->prepare("update student_inac set highcost = 'true' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	# print "ID:$id HCSE: $rec{highcost} Yes\n";
    }


    # Language Extent
    if ( $rec{language_extent} =~ m/\(4\)/ ) {
	# Subject Only...
	my $sth = $dbh->prepare("update student_inac set language_extent = '0800.01' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	# print "ID:$id Lang Extent: $rec{language_extent} 0800.01\n";

    } elsif ( $rec{language_extent} =~ m/\(1\)/ ) {
	# No Instruction in Indian Lang ...
	my $sth = $dbh->prepare("update student_inac set language_extent = '0100' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	# print "ID:$id Lang Extent: $rec{language_extent} 0100\n";

    } elsif ( $rec{language_extent} =~ m/\(5\)/ ) {
	# Subject Plus...
	my $sth = $dbh->prepare("update student_inac set language_extent = '0800' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } 

    # Language of Instruction
    if ( $rec{language_instruction} =~ m/\(1\)/ ) {
	# Reset to Native (NAI)
	my $sth = $dbh->prepare("update student_inac set language_instruction = 'NAI' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{language_instruction} =~ m/\(2\)/ ) {
	# Reset to Native (NAI)
	my $sth = $dbh->prepare("update student_inac set language_instruction = 'EN' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{language_instruction} =~ m/\(4\)/ ) {  # Native and English
	# Reset to English
	my $sth = $dbh->prepare("update student_inac set language_instruction = 'EN' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    }


    # Language of Home
    if ( $rec{language_home} =~ m/\(1\)/ ) {
	# Reset to Native (NAI)
	my $sth = $dbh->prepare("update student_inac set language_home = 'NAI' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{language_home} =~ m/\(2\)/ ) {
	# Reset to Native (NAI)
	my $sth = $dbh->prepare("update student_inac set language_home = 'EN' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{language_home} =~ m/\(4\)/ ) {  # Native and English
	# Reset to English
	my $sth = $dbh->prepare("update student_inac set language_home = 'NAI' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    }

    

    # Status Code
    if ( $rec{status_code} =~ m/\(1\)/ ) {
	# Reset to 1 (Registered)
	my $sth = $dbh->prepare("update student_inac set status_code = '1' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{status_code} =~ m/\(7\)/ ) {
	# Reset to 2 (Eligible)
	my $sth = $dbh->prepare("update student_inac set status_code = '2' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{status_code} =~ m/\(2\)/ ) {
	# Reset to 3 ( Not Eligible )
	my $sth = $dbh->prepare("update student_inac set status_code = '3' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    }  


    # FTE
    if ( $rec{fte} =~ m/\(1\)/ ) {
	# Reset to 0843 (Full Time)
	my $sth = $dbh->prepare("update student_inac set fte = '0843' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    }



    # Residence
    if ( $rec{residence} =~ m/\(1\)/ ) {
	# Reset to 1 (On Reserve)
	my $sth = $dbh->prepare("update student_inac set residence = '1' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{residence} =~ m/\(2\)/ ) {
	# Reset to 2 (Crown Land)
	my $sth = $dbh->prepare("update student_inac set residence = '2' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    } elsif ( $rec{residence} =~ m/\(4\)/ ) {
	# Reset to 3 (Off Reserve)
	my $sth = $dbh->prepare("update student_inac set residence = '3' where id = ?");
#	$sth->execute( $id );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    }


}


print "\nDone!\n";

