#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Homeroom Assignment' => 'Homeroom Assignment',
	   'Eoy' => 'Eoy',
	   'Main' => 'Main',
	   'Update Homerooms' => 'Update Homerooms',
	   'Grade' => 'Grade',
	   'Student' => 'Student',
	   'Homeroom' => 'Homeroom',
	   'Your homeroom update to temporary student table is now stored' => 
	     'Your homeroom update to temporary student table is now stored',
	   'There was an error storing your data' => 'There was an error storing your data',
	   'Record the following error' => 'Record the following error',
	   'Contact' => 'Contact',
	   'Error' => 'Error',
	   

	   );

my $self = 'asclass.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Read prereg_staff into a list.
$sth1 = $dbh->prepare("select homeroom, firstname, lastname, grade, userid 
  from prereg_staff where homeroom != ''");
$sth1->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
$rows = $sth1->rows;

my @teacher;
for (1..$rows) { 
    my ($homeroom, $firstname, $lastname, $grade, $userid) = $sth1->fetchrow;
    my $teacher = "$homeroom:$firstname $lastname:$grade:$userid";

    # Create "Reverse Teacher" hash... have class, find name. 
    $revteacher{$homeroom} = "$firstname $lastname";

    push @teacher, $teacher ;
}
@teacher = sort @teacher;


$sth = $dbh->prepare("select * from preset order by grade,lastname,firstname");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
$rows = $sth->rows;

my $title = $lex{'Homeroom Assignment'};

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$eoypage">$lex{Eoy}</a> ]\n};


if ( $arr{writeflag} ) {
    delete $arr{writeflag};
    writeRecords();
}


print qq{<h1>$title</h1>\n};

print qq{<form action="$self" method="post">\n};
print qq{<input type="submit" value="$lex{'Update Homerooms'}">\n};

my $curgrade = -1;
my $first = 1;

while ( my @arr = $sth->fetchrow ) {

    $oldgrade = $curgrade;
    $curgrade = $arr[5];  

    if ($oldgrade ne $curgrade) { # we have a new grade, start new table
	if (not $first ){ print qq{</table><p>&nbsp;</p> \n};} else { $first = 0; }

	print qq{<table border="1" cellpadding="3" cellspacing="0">\n};
	print qq{<caption><b>$lex{Grade}: $curgrade</b></caption>\n};
	print qq{<tr><th>$lex{Student}</th><th>$lex{Homeroom}</th></tr>\n};
    }
    
    # Now print the current record
    print qq{<tr><td>$arr[2] $arr[1]</td><td>\n};
    print qq{<select name="$arr[0]"><option>$arr[6]:$revteacher{$arr[6]}</option>\n};
    foreach my $teacher ( @teacher ) {
	my ($homeroom, $name, $grade, $rec) = split(/:/,$teacher);
	if ($grade eq $curgrade or not $curgrade) { print qq{<option>$homeroom: $name</option>\n};}
    }
    print qq{</select></td></tr>\n};

} # End of loop counter

print qq{<tr><td colspan="2" align="center">\n};
print qq{<input type="submit" value="$lex{'Update Homerooms'}">};
print qq{</table></form></body></html>\n};


#---------------
sub writeRecords {
#---------------

    foreach my $key ( keys %arr ) { 
	my ($rmnum, $teacher) = split /:/, $arr{$key};
	$rmnum =~ s/://; # just in case.
	#print qq{Room: $rmnum  Snum: $key \n<br>" ;
 
	$sth = $dbh->prepare("update preset set homeroom = ? where id = ? ");
	$sth->execute( $rmnum, $key );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	
    }


    if (not $DBI::errstr ) {
	print qq{<h3>$lex{'Your homeroom update to temporary student table is now stored'}</h3>\n}; 

    } else { 
	print qq{$lex{Error}: $DBI::errstr</h3>\n}; 
    } 

    print qq{[ <a href="$eoypage">$lex{Eoy}</a>]</p></body></html>\n};

    exit;

}
