#!/usr/bin/perl
#  Copyright 2001-2010 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Staff Not Found!' => 'Staff Not Found!',
	   'Eoy' => 'Eoy',
	   'Main' => 'Main',
	   'Staff' => 'Staff',
	   'Prereg' => 'Prereg',
	   'Contact' => 'Contact',
	   'Please record the following error' => 'Please record the following error',
	   'Copy Staff' => 'Copy Staff',
	   'Error' => 'Error',

	   );


use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Select all staff in staff table.
$sth = $dbh->prepare("select * from staff"); 
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
$rows = $sth->rows;

print "$doctype\n<html><head><title>". $lex{'Copy Staff'}. "</title>
 <link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
 $chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> | \n";
print "<a href=\"$eoypage\">". $lex{Eoy}. "</a>]\n";


if ( $rows > 0 ){  # We have some real staff so let's empty out prestaff.

    # Delete all records in prestaff table, prereg_staff_multi;
    my $res = $dbh->do("delete from prereg_staff") || die "Delete Prereg_staff Error: $DBI::errstr\n";
    my $res = $dbh->do("delete from prereg_staff_multi") || die "Delete Prereg_staff Error: $DBI::errstr\n";

} else {  # Error, no staff.
    print "<h1>". $lex{'Staff Not Found!'}. "</h1></body></html>\n";
    exit;
}

$sth1 = $dbh->prepare("insert into prereg_staff select * from staff");
$sth1->execute;

$sth1 = $dbh->prepare("insert into prereg_staff_multi select * from staff_multi");
$sth1->execute;


if ( not $DBI::errstr ) {
    print '<h3>'. $lex{Staff}. ' -> '. $lex{Prereg}. q{ }. $lex{Staff}. "</h3></p>";

} else {
    print '<h3>'. $lex{Error}. ': ';
    print $lex{'Contact'}. " $adminname ". " <a href=\"mailto:$adminemail\">$adminemail</a>\n";
    print $lex{'Please record the following error'};
    print "<br>$DBI::errstr</h3>\n";
}
print "<p>[ <a href=\"$eoypage\">". $lex{Eoy}. "</a> ]\n";
print "</p></body></html>";
