#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Update Room' => 'Update Room',
	   'Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'Your student grades and home rooms are now updated' => 
	     'Your student grades and home rooms are now updated',
	   'There was an error storing your data' => 'There was an error storing your data',
	   'Contact' => 'Contact',
	   'Record the following error' => 'Record the following error',
	   'Error' => 'Error',

	   );

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# HTML Header
print "$doctype\n<html><head><title>". $lex{'Update Room'}. "</title>
<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print "<a href=\"$eoypage\">". $lex{Eoy}. "</a> ]\n";

my $sth = $dbh->prepare("select * from preset"); 
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

while (my @arr = $sth->fetchrow ) {

    $grade = $dbh->quote( $arr[5] );
    $homeroom = $dbh->quote( $arr[6] );
    $studnum = $dbh->quote( $arr[4] );
    print "$arr[2] $arr[1]<br>\n";

    $sth1 = $dbh->prepare("update student set grade = ?, homeroom= ? where studnum = ?");
    $sth1->execute( $grade, $homeroom, $studnum);
    if ($DBI::errstr) { print "Update error: $DBI::errstr\n"; die $DBI::errstr; }
 
} # end of Loop 

if (not $DBI::errstr ) {
    print "<h3>". $lex{'Your student grades and home rooms are now updated'}. ".</h3>\n";

} else {
    print "<h3>". $lex{'There was an error storing your data'}. ".<br>\n";
    print $lex{Contact}. " $adminname <a href=\"mailto:$adminemail\">$adminemail</a>\n";
    print $lex{'Record the following error'}. ": $DBI::errstr</h3></p>";

}

print "<p>[<a href=\"$homepage\">". $lex{Main}. "</a> | \n";
print "<a href=\"$eoypage\">". $lex{Eoy}. "</a> ]</p></body></html>\n";
