#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Temporary HRm/Grade Student Report' => 'Temporary HRm/Grade Student Report',
	   'Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'View Students' => 'View Students',
	   'Name' => 'Name',
	   'Number' => 'Number',
	   'Grade' => 'Grade',
	   'HRm' => 'HRm',
	   'Error' => 'Error',

	   );

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, 
 $iddst) = localtime(time);
$year = $year + 1900;
$mon++; $wday++;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $select;
if ( $arr{grade} ) {
    $arr{grade} = $dbh->quote( $arr{grade} );
    $select = "where grade = $arr{grade}";
}

my $sortorder = "lastname, firstname";
if ($arr{sortorder} eq "birthdate") {
    $sortorder = "birthdate";
} 

my $sth = $dbh->prepare("select lastname, firstname, initial, studnum, grade, homeroom
 from preset $select order by $sortorder");
$sth->execute;
$rows = $sth->rows;

print "$doctype\n<html><head><title>". $lex{'View Students'}. "</title>
<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print "<a href=\"$eoypage\">". $lex{Eoy}. "</a> ]\n";

print "<center><h1>". $lex{'Temporary HRm/Grade Student Report'};
print "</h1><h3>$currdate</h3>\n";
print "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n";
print "<tr><th>". $lex{Name}. "</th><th>". $lex{Number};
print "</th><th>". $lex{Grade}. "</th><th>". $lex{HRm}. "</th></tr>\n";

while ( my ( $lastname, $firstname, $initial, $studnum, $grade, $homeroom ) 
	= $sth->fetchrow ) {
    print "<tr><td><b>$lastname, $firstname $initial</b></td>\n";
    print "<td>$studnum</td><td>$grade</td><td>$homeroom</td></tr>\n";

}

print "</table></center></body></html>\n";


