#! /usr/bin/perl
#  Copyright 2001-2025 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Main' => 'Main',
	   'Walkthrough' => 'Walkthrough',
	   'Viewer' => 'Viewer',
	   'Description' => 'Description',
	   'Type' => 'Type',
	   'Select' => 'Select',
	   'Fields' => 'Fields',
	   'Error' => 'Error',
	   'Continue' => 'Continue',
	   'Column' => 'Column',
	   'Number' => 'Number',
	   'Width' => 'Width',
	   'Order' => 'Order',
	   'Tabular' => 'Tabular',
	   'Multicolumn' => 'Multicolumn',
	   'Reorder' => 'Reorder',
	   'Student Roster' => 'Student Roster',
	   'Report' => 'Report',
	   'Created' => 'Created',
	   'Delete' => 'Delete',
	   'Select' => 'Select',
	   'Deleted' => 'Deleted',
	   'Save' => 'Save',
	   'Drag' => 'Drag',
	   'Change' => 'Change',
	   'Order' => 'Order',
	   'View' => 'View',
	   'New' => 'New',
	   'Missing' => 'Missing',
	   'Title' => 'Title',
	   'Category' => 'Category',
	   'Sequence' => 'Sequence',
	   'Template' => 'Template',
	   
	   );

my $self = 'pwalkViewerLocal.pl';


use DBI;
use CGI;
use Data::UUID;


# Current Date
my @tim = localtime(time);
my $year = @tim[5] + 1900;
my $month = @tim[4] + 1;
my $day = @tim[3];
if (length($month) == 1) { $month = '0'.$month; }
if (length($day) == 1) { $day = '0'.$day; }
my $currdate = "$year-$month-$day";


# Read database access
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


# Setup Database access
my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $q = new CGI;
my %arr = $q->Vars;
print $q->header( -charset, $charset );


# Page Header
my $title = "$lex{Walkthrough} Template $lex{Viewer}";

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">\n};

if ( $arr{page} == 1 ) { # load jQuery libs
    print qq{<script type="text/javascript" src="$g_jquery_url">};
    print qq{</script>\n};

    print qq{<script type="text/javascript" src="$g_jquery_ui_url">};
    print qq{</script>\n};
}


print qq{$chartype\n</head><body style="padding:1em 3em;">\n};
print qq{<div>[ <a href="$homepage">$lex{Main}</a> ]</div>\n};

print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showTemplate();
}



#-----------------
sub showTemplate {
#-----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Get Master Record
    my $sth = $dbh->prepare("select * from pwalk_mst where id = ?");
    $sth->execute( $arr{id} );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $mref = $sth->fetchrow_hashref;
    my %mst = %$mref;
    my $mstid = $mst{id};


    # Loop through all template records
    my $sth = $dbh->prepare("select * from pwalk_tpl where mstid = ?");
    $sth->execute( $mstid );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    print qq{<h3>$mst{title} - $mst{category}</h3>\n};
    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<tr><th>$lex{Description}</th><th>$lex{Category}</th><th>$lex{Sequence}</th></tr>\n};

    while ( my $ref = $sth->fetchrow_hashref ) {
	%r = %$ref;

	print qq{<tr><td class="la">$r{description}</td>};
	print qq{<td class="la">$r{category}</td><td class="la">$r{sequence}</td></tr>\n};

    }

    print qq{</table>\n};

    print qq{<p><form><input type="hidden" name="none">\n};
    print qq{<input type="button" value="Close Tab" onClick="parent.close()"></form></p>\n};
    
    print qq{</body></html>\n};

    exit;

} # end of showTemplate



#----------------
sub showStartPage {
#----------------

=head    
    # Start Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};


    # Continue Button
    print qq{<p><input type="submit" value="$lex{Continue}"></p>\n};
=cut

    # Get the Template Masters
    my $sth = $dbh->prepare("select * from pwalk_mst order by sequence, title");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<caption style="font-weight:bold;text-align:right;">View Details in new tab <caption>\n};
    print qq{<tr><th>Title</th><th>$lex{Category}</th><th>$lex{Description}</th><th>Seq</th>};
    print qq{<th>View</th></tr>\n};

    while ( my $ref = $sth->fetchrow_hashref ) {
	%r = %$ref;
	print qq{<tr><td class="la">$r{title}</td>\n};
	print qq{<td class="la">$r{category}</td>\n};
	print qq{<td class="la" style="width:40ch;">$r{description}</td>};
	print qq{<td class="la">$r{sequence}</td>\n};

	print qq{<td>};
	print qq{<form action="$self" method="post" target="_blank">\n};
	print qq{<input type="hidden" name="page" value="1">\n};
	print qq{<input type="hidden" name="id" value="$r{id}">\n};
	print qq{<input type="submit" value="Details">\n};
	print qq{</form>\n};
	print qq{</td></tr>\n};
	
    }    

    print qq{</table>\n};
    print qq{</body></html>\n};

    exit;

}
