#!/usr/bin/perl
#  Copyright 2001-2019 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# Find Blank or Null entries for marks for a particular term.

my %lex = ('Check' => 'Check',
	   'Marks' => 'Marks',
	   'Main' => 'Main',
	   'Report Card' => 'Report Card',
	   'Student' => 'Student',
	   'Course' => 'Course',
	   'Grade' => 'Grade',
	   'Not Found' => 'Not Found',
	   'Error' => 'Error',
	   'Complete' => 'Complete',
	   'Term(s)' => 'Term(s)',
	   'Grade(s)' => 'Grade(s)',
	   'Continue' => 'Continue',
	   'Term' => 'Term',
	   'Separate with Spaces' => 'Separate with Spaces',
	   'Mark' => 'Mark',
	   'Field' => 'Field',
	   );
use DBI;
use CGI;

my $self = 'checkmark.pl';


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Load the SupressSubject, AdditionalComments, MarkField data
$sth = $dbh->prepare("select datavalue from conf_system
 where dataname = ?");
foreach my $val ( qw(r_SupressSubject r_MarkField r_AdditionalComments)) {
    $sth->execute( $val );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    my $dv = $sth->fetchrow;
    eval $dv;
}



# Print Page Header
my $title = qq{$lex{Check} $lex{Marks}};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{ <link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>};

print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$reppage">$lex{'Report Card'}</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    checkMarks();
}



#-------------
sub checkMarks {
#-------------

#    foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $first = 1;

    # Loop Through all Grades ... checking.
    # foreach my $grade ( sort {$a <=> $b} keys %grade2currterm ) {

    my @grades = split(/\s+/, $arr{grades});
    
    foreach my $grade ( sort {$a <=> $b} @grades ) {

	# my $term = $grade2currterm{$grade}; # term for this grade.

	my $term = $arr{term};

	# Get Teacher Name
	my $sth1 = $dbh->prepare("select lastname, firstname from staff where userid = ?");

	# Check for Mark Entry.
	my $sth2 = $dbh->prepare("select e.studnum, s.lastname, s.firstname from eval e, student s
         where ( $r_MarkField  = '' or $r_MarkField is null) and s.studnum = e.studnum and 
         e.term = ? and e.subjcode = ? order by s.lastname, s.firstname");

	
	# Get Subjects for this grade.
	my $sth = $dbh->prepare("select subjsec, description, teacher
         from subject where grade = ? order by description");
         $sth->execute( $grade );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}

	while ( my ( $subjsec, $description, $teacher ) = $sth->fetchrow ) {

	    # Skip if supress or AdditionalComment subjects
	    my ($subjcode, $dud) = split(/-/, $subjsec);
	    if ( $r_SupressSubject{ $subjsec } or $r_SupressSubject{ $subjcode } or
		 $r_AdditionalComments{ $subjsec } or $r_AdditionalComments{ $subjcode } ) { 
		next; 
	    }

	    # Get Teacher Name
	    $sth1->execute( $teacher );
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	    my ( $lastname, $firstname ) = $sth1->fetchrow;
	    my $teachername = "<b>$lastname</b>, $firstname";

	    # Loop looking for any students with missing marks.
	    $sth2->execute( $term, $subjsec );
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	    
	    while ( my $ref = $sth2->fetchrow_hashref ) {
		my %r = %$ref;

		if ( $first ) { # set up table heading.
		    print qq{<table  cellpadding="3" cellspacing="0" border="1">\n};
		    print qq{<tr><th>$lex{Course}</th><th>$lex{Student}</th></tr>\n}; 
		    $first = 0;
		}

		print qq{<tr><td><b>$description</b> ($subjsec) $teachername  $lex{Grade} $grade</td>\n};
		print qq{<td><b>$r{lastname}</b>, $r{firstname} ($r{studnum})</td></tr>\n};
	    
	    } # checking loop
	} # subject loop
	
    } # grade loop

    if ( not $first ) {
	print qq{</table>\n};
    } else { # no missing marks
	print qq{<h3>No Missing Marks</h3>\n};
    }

    print qq{</body></html>\n};

    exit;

} # end of checkMarks


#-------------
sub quickCheck {
#-------------

    my $sth = $dbh->prepare("select  studnum, subjcode from eval
      where ( a1 = '' or a1 is null ) and term = ? 
      order by subjcode, studnum");
    $sth->execute( $arr{term} );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}

    my $sth1 = $dbh->prepare("select lastname,firstname from student 
     where studnum = ?");

    $sth2 = $dbh->prepare("select description,grade from subject 
      where subjsec = ?");

    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};

    while ( my ($studnum,$subjsec) = $sth->fetchrow ) {

	    # Skip if supress or AdditionalComment subjects
	    my ($subjcode, $dud) = split(/-/, $subjsec);
	    if ( $r_SupressSubject{ $subjsec } or $r_SupressSubject{ $subjcode } or
		 $r_AdditionalComments{ $subjsec } or $r_AdditionalComments{ $subjcode } ) { 
		next; 
	    }

	    # Get the student's name
	    $sth1->execute($studnum);
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	    my ($lastname,$firstname) = $sth1->fetchrow;
	    if ( not $lastname ) { $lastname = qq{<span style="color:red;">$lex{'Not Found'}</span>}; }

	    # Get the subject description
	    $sth2->execute($subjsec);
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	    my ($description,$grade) = $sth2->fetchrow;
    
	    print qq{<tr><td><b>$description</b> ($subjsec) $lex{Grade} $grade</td>\n};
	    print qq{<td>$firstname $lastname ($studnum)</td></tr>\n};
    }

    print qq{</table></body></html>\n};

} # end of QuickCheck



#----------------
sub showStartPage {
#----------------

    # Get Terms of enrolled subjects.
    my @terms;
    $sth = $dbh->prepare("select distinct term from eval order by term");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die "$DBI::errstr\n"; }
    while ( my $term = $sth->fetchrow ) {
	push @terms, $term;
    }

    # Start the Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellspacing="0" cellpadding="3" border="0">\n};

    # Get Grade(s)
    print qq{<tr><td class="bra">$lex{'Grade(s)'}</td><td class="la">};
    print qq{<input type="text" name="grades" size="12"> $lex{'Separate with Spaces'}</td></tr>\n};


    # Get Term
    print qq{<tr><td class="bra">$lex{'Term'}</td><td class="la">};
    print qq{<select name="term"><option></option>\n};
    foreach my $trm ( @terms ) {
	print qq{<option>$trm</option>};
    }
    print qq{\n</select></td></tr>\n};


    print qq{<tr><td class="bra">$lex{Mark} $lex{Field}</td><td class="la">};
    print qq{$r_MarkField</td></tr>\n};


    print qq{<tr><td></td><td class="la">\n};
    print qq{<input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table></form>\n};

    print qq{</body></html>\n};

    exit;

}
