#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

my %lex = ('Main' => 'Main',
	   'Report Card' => 'Report Card',
	   'Move Course Evaluations' => 'Move Course Evaluations',
	   'Last,First/Last/Initials/Studnum' => 
	     'Last,First/Last/Initials/Studnum',
	   'Student' => 'Student',
	   'No Student(s) Found' => 'No Student(s) Found',
	   'Checked' => 'Checked',
	   'Continue' => 'Continue',
	   'Current' => 'Current',
	   'Move To' => 'Move To',

	   );

my $self = 'evalmove.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
my $title = $lex{'Move Course Evaluations'};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$reppage">$lex{'Report Card'}</a> ]\n};

print qq{<h1>$title - <span style="font-size:80%;">To Another Section</span></h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    selectCourse();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    moveEval();
}



#----------------
sub showStartPage {
#----------------

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<div style="width:60ch;margin:0.5em;">This script will
    allow you to move student course enrollments from one course to
    another <b>identical</b> course (but a different section) when
    <b>splitting classes</b> or moving them to a different
    homeroom.</div>\n};

    
    print qq{<div style="font-weight:bold;margin:0.5em;">Please select $lex{Student}</div> };
    print qq{<div><input type="input" name="student" style="width:20ch;">\n};
    print qq{<input type="submit" value="$lex{Continue}"></div>\n};
    print qq{<div>($lex{'Last,First/Last/Initials/Studnum'})</div>\n};

    print qq{</form></body></html>\n};

    exit;

}



#-----------------
sub selectCourse { # select student courses to move.
#-----------------

    #foreach my $key ( sort keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Outline: Find the student(s), find their courses, find matching ones.
    #  Pass the changes onto moveEval;

    my $student = $arr{student};
    my $sth;

    if ( $student =~ /^\d+/) {  # we have a student number
	$sth = $dbh->prepare("select studnum from studentall where studnum = ?");
	$sth->execute( $student );
	
    } else { # we have words hopefully with a comma
	($lastname,$firstname)  = split /\,/, $student;
	$firstname =~ s/^\s*//;
	$lastname =~ s/^\s*//;
	if ( $lastname and $firstname ){ # both entered.
	    $sth = $dbh->prepare("select studnum from studentall 
               where lastname = ? and firstname = ?");
	    $sth->execute( $lastname, $firstname ) ;
	    
	} elsif ($lastname and not $firstname){ # only lastname (no comma)
	    if ( length($lastname) == 2 ){ # search by initials: fi, li.
		my $fi = substr($lastname,0,1). '%';
		my $li = substr($lastname,1,1). '%';
		$sth = $dbh->prepare("select studnum from studentall 
                  where lastname $sql{like} ? and firstname $sql{like} ?");
		$sth->execute( $li, $fi ) ;

	    } else {
		$sth = $dbh->prepare("select studnum
                  from studentall where lastname = ?");
		$sth->execute( $lastname ) ;
	    }
	} 
	
    } # end of character search

    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $rows = $sth->rows;

    if ( $rows < 1 ) { # student not found
	print qq{<h3>$lex{'No Student(s) Found'}</h3>\n};
	showStartPage();
    }

    my $sth1 = $dbh->prepare("select distinct subjcode from eval where studnum = ?");
    my $sth2 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    my $sth3 = $dbh->prepare("select description, teacher from subject where subjsec = ?");
    my $sth4 = $dbh->prepare("select subjsec from subject where subjcode = ?");

    # Start Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};

    while ( my $studnum = $sth->fetchrow ) { # Display his/her subject and matching ones.

	# Get Name
	$sth2->execute( $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my ( $lastname, $firstname ) = $sth2->fetchrow;
	print qq{<h2>$firstname $lastname ($studnum)</h2>\n};
	print qq{<table border="1" cellpadding="3" cellspacing="0">\n};
	print qq{<tr><th>$lex{Current}</th><th>$lex{'Move To'}</th></tr>\n};

	# Get Courses
	$sth1->execute( $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	while ( my $subjsec = $sth1->fetchrow ) {
	    
	    # Get this Course description
	    $sth3->execute( $subjsec );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    my ( $description, $teacher ) = $sth3->fetchrow;
	    $teacher =~ s/\(\w+\)//g;  # strip userid
	    print qq{<tr><td>$description ($teacher) $subjsec</td><td>\n};

	    # Get Matching Courses, if any
	    my ( $subjcode, $section ) = split /-/, $subjsec;
	    $sth4->execute( $subjcode );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    print qq{<select name="$subjsec:$studnum"><option></option>\n};
	    while ( my $match_subjsec = $sth4->fetchrow ) {
		if ( $match_subjsec eq $subjsec ) { next; } # skip
		$sth3->execute( $match_subjsec );
		if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
		my ( $description, $teacher ) = $sth3->fetchrow;
		$teacher =~ s/\(\w+\)//g;  # strip userid
		print qq{<option>$description - $teacher ($match_subjsec)</option>\n};
	    }
	    print qq{</select></td></tr>\n};

	}

	print qq{</table>\n};
	print qq{<input type="submit" value="$lex{Continue}"><p></p>\n};

    }

    print qq{</form></body></html>\n};

    exit;

} # end of selectCourse



#-----------
sub moveEval {
#-----------

    #foreach my $key ( sort keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $sth = $dbh->prepare("select id from eval where subjcode = ? and studnum = ?");
    my $sth1 = $dbh->prepare("update eval set subjcode = ? where id = ?");
    my $sth2 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");

    foreach my $key ( sort keys %arr ) { 

	if ( $arr{$key} ) {
	    #print qq{K:$key V:$arr{$key}<br>\n}; }
	    my ( $subjsec, $studnum ) = split /:/, $key;
	    my ( $dud, $newsubjsec ) = split /\(/, $arr{$key};
	    chop $newsubjsec;
	    # print qq{Stud: $studnum  Subjsec: $subjsec New: $newsubjsec<br>\n};

	    $sth->execute( $subjsec, $studnum );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	    while ( my $id = $sth->fetchrow ) {
		$sth1->execute( $newsubjsec, $id ); # update record.
		if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    }

	    # Write confirmation
	    $sth2->execute( $studnum );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    my ( $lastname, $firstname ) = $sth2->fetchrow;
	    print qq{<div style="text-align:left;font-size:150%;">\n};
	    print qq{$firstname $lastname&nbsp;&nbsp;$subjsec -&gt; $newsubjsec</div>\n};

	}
    }

    print qq{</body></html>\n};
    exit;

 } # end of moveEval
