#!/usr/bin/perl
#  Copyright 2001-2016 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Report' => 'Report',
	   'Teacher' => 'Teacher',
	   'Main' => 'Main',
	   'Report Card' => 'Report Card',
	   'Name' => 'Name',
	   'Subj-Sec' => 'Subj-Sec',
	   'Terms' => 'Terms',
	   'Not Found' => 'Not Found',
	   'Error' => 'Error',
	   'Subjects' => 'Subjects',
	   'Enrol' => 'Enrol',
	   'Course' => 'Course',
	   'Course Master' => 'Course Master',
	   'Term' => 'Term',
	   'Total' => 'Total',
	   	   
	   );

use DBI;
use CGI;
use Number::Format qw(:all);

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, 
    $iddst) = localtime(time);
$year = $year + 1900;
$mon++; $wday++;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";


my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = "$lex{'Course Master'} $lex{Report} 3 - Teacher Report";

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body style="padding:2em 4em;">\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$reppage">$lex{'Report Card'}</a> ]\n};

print qq{<h1>$title</h1>\n};



# Prep: Read Subject Information
my $sth1 = $dbh->prepare("select description, subjsec, startrptperiod, endrptperiod 
 from subject where teacher = ? order by startrptperiod, endrptperiod, description");

# Prep: Count enrollment records
my $sth2 = $dbh->prepare("select count(*) from eval where subjcode = ? and term >= ? and term <= ?");


my $sth = $dbh->prepare("select distinct s.teacher, st.lastname, st.firstname 
  from subject s, staff st where st.userid = s.teacher and 
  s.teacher is not NULL and s.teacher != ''
  order by st.lastname, st.firstname, s.teacher");
$sth->execute;
if ($DBI::errstr){print $DBI::errstr; die $DBI::errstr; }


# Loop through all teachers.
my $tchcount = 1;
while ( my ( $userid, $lastname, $firstname ) = $sth->fetchrow ) {

    print qq{<div style="float:left;padding:0.5em;">\n};
    print qq{<div style="font-size:130%;font-weight:bold;padding:0.4em;">$lastname, $firstname ($userid)</div>\n};


    # Get the terms taught, and course info
    my ($sterm, $eterm, %course, %sort);
    $sth1->execute( $userid );
    if ($DBI::errstr){print $DBI::errstr; die $DBI::errstr; }
    while ( my ( $description, $subjsec, $startterm, $endterm )	= $sth1->fetchrow ) {
	if ( not $sterm ) { $sterm = $startterm; };
	if ( $startterm < $sterm ) { $sterm = $startterm; }
	if ( $endterm > $eterm ) { $eterm = $endterm; }
	$course{$subjsec}{'startterm'} = $startterm;
	$course{$subjsec}{'endterm'} = $endterm;
	$course{$subjsec}{'description'} = $description;

	$sort{"$description$subjsec"} = $subjsec;
	
	my $evalperstudent = $endterm - $startterm  + 1;

	$sth2->execute( $subjsec, $startterm, $endterm );
	if ($DBI::errstr){print $DBI::errstr; die $DBI::errstr; }
	my $count = $sth2->fetchrow;

	my $enrollment = 0;
	if ( $evalperstudent ) {
	    $enrollment = round($count / $evalperstudent );
	}

	$course{$subjsec}{'enrollment'} = $enrollment;
	
    }


    # Loop through all courses;
    my $first = 1;
    foreach my $term ( $sterm..$eterm ) {

	
	if ( $first ) { # print table heading.
	    print qq{<table border="1" cellpadding ="3" cellspacing="0">\n};
	    print qq{<tr><th>$lex{Name}</th><th>$lex{'Subj-Sec'}</th><th>$lex{Enrol}</th></tr>\n};
	    # print qq{<th>$lex{Terms}</th></tr>\n};
	    $first = 0;
	}

	# Term 
	print qq{<tr style="background-color:#DDD;">};
	print qq{<td colspan="4" class="bla">$lex{Term} $term</td></tr>\n};

	
	# Course Loop
	my $coursecount;
	foreach my $key ( sort keys %sort ) {
	    my $subjsec = $sort{$key};

	    if ( $term >= $course{$subjsec}{'startterm'} and
		 $term <= $course{$subjsec}{'endterm'} ) { # they're teaching this term.
	    
		print qq{<tr><td>$course{$subjsec}{description}</td><td>$subjsec</td>};
		print qq{<td>$course{$subjsec}{enrollment}</td></tr>\n};
		$coursecount++;
	    }
	}

	print qq{<tr><td></td><td colspan="2" class="bla">$lex{Total} $coursecount</td></tr>\n};
	
    } # end of term loop


    if ( $first ) {
	print qq{<h3>$lex{Subjects} $lex{'Not Found'}</h3>\n};
    } else {
	print qq{</table><p></p>\n};
    }


    print qq{</div>\n};
    if ( $tchcount % 3 == 0 ) { print qq{<br clear="left">\n}; }
    $tchcount++;


}
 # end of teacher loop


print qq{</body></html>\n};
exit;




{

    
    $sth1->execute( $userid );
    if ($DBI::errstr){print $DBI::errstr; die $DBI::errstr; }
    while ( my ( $description, $subjsec, $startterm, $endterm )	= $sth1->fetchrow ) {

	my $evalperstudent = $endterm - $startterm  + 1;

	$sth2->execute( $subjsec, $startterm, $endterm );
	if ($DBI::errstr){print $DBI::errstr; die $DBI::errstr; }
	my $count = $sth2->fetchrow;

	my $enrollment = 0;
	if ( $evalperstudent ) {
	    $enrollment = round($count / $evalperstudent );
	}

	if ( $first ) { # print table heading.
	    print qq{<table border="1" cellpadding ="3" cellspacing="0">\n};
	    print qq{<tr><th>$lex{Name}</th><th>$lex{'Subj-Sec'}</th><th>$lex{Enrol}</th>\n};
	    print qq{<th>$lex{Terms}</th></tr>\n};
	    $first = 0;
	}
    
	print qq{<tr><td class="bla">$description</td>};
	print qq{<td class="la">$subjsec</td><td class="cn">$enrollment</td>\n};
	print qq{<td class="cn">$startterm - $endterm</td></tr>\n};

    }

    if ( $first ) {
	print qq{<h3>$lex{Subjects} $lex{'Not Found'}</h3>\n};
    } else {
	print qq{</table><p></p>\n};
    }


    print qq{</div>\n};
    if ( $tchcount % 3 == 0 ) { print qq{<br clear="left">\n}; }
    $tchcount++;


}

print qq{</body></html>\n};
