#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Main' => 'Main',
	   'Report Card' => 'Report Card',
	   'student records depend on this subject' => 'student records depend on this subject',
	   'Please remove these first using' => 'Please remove these first using',
	   'Course Enrollment' => 'Course Enrollment',
	   'Course' => 'Course',
	   'Subject-Section' => 'Subject-Section',
	   'Records Depending' => 'Records Depending',
	   'Are you sure' => 'Are you sure',
	   'Edit/Delete' => 'Edit/Delete',
	   'Contact' => 'Contact',
	   'deleted' => 'deleted',
	   'Error' => 'Error',
	   'Delete' => 'Delete',
	   'Record' => 'Record',

	   );

my $self = 'subjdel.pl';

use CGI;
use DBI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = new CGI;
print $q->header( -charset => $charset ); 
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = qq{$lex{Delete} $lex{Course}};
print qq{$doctype\n<html><head><title>$title</title>
 <link rel="stylesheet" href="$css" type="text/css">
 $chartype\n};
print qq{</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$reppage">$lex{'Report Card'}</a> ]\n};

if ($arr{flag}) {
    deleteRecord();
}

my $sth = $dbh->prepare("select subjsec, description from subject where id = ?"); 
$sth->execute( $arr{id} );
my ( $subjsec, $description ) = $sth->fetchrow;

$sth = $dbh->prepare("select count(*) from eval where subjcode = ?"); 
$sth->execute( $subjsec );
$subjcount = $sth->fetchrow;


if ( $subjcount > 0 ){ # Some records depend on this...
    print qq{<h1>$subjcount };
    print qq{$lex{'student records depend on this subject'}.<br>\n};
    print qq{$lex{'Please remove these first using'} };
    print qq{ &quot;$lex{'Edit/Delete'} $lex{'Course Enrollment'}&quot;</h1>\n};
    print qq{<h1>[ <a href="$reppage">$lex{'Report Card'}</a> ]\n};
    print qq{</h1></body></html>\n};
    exit;
}


print qq{<h1>$title</h1>\n};
print qq{<table cellpadding="3" cellspacing="0" border="1">\n};

print qq{<tr><td class="ra">$lex{Course}};
print qq{</td><td class="bla">$description</td></tr>\n};

print qq{<tr><td class="ra">$lex{'Subject-Section'}};
print qq{</td><td class="bla">$subjsec</td></tr>\n};

print qq{<tr><td class="ra">$lex{'Records Depending'}};
print qq{</td><td class="bla">$subjcount</td></tr>\n};

print qq{</table>\n};

print qq{<div style="font-weight:bold;font-size:110%;margin:1em 0;">};
print qq{$lex{Delete} $lex{Record}. $lex{'Are you sure'}?</div>
<form action="$self" method="post">
<input type="hidden" name="flag" value="1">
<input type="hidden" name="itemid" value="$arr{id}">
<input type="hidden" name="name" value="$description">
<input type="submit" value="$lex{Delete} $lex{Record}!">
</form></body></html>\n};


#---------------
sub deleteRecord {
#---------------

    #foreach my $key (keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $sth = $dbh->prepare("delete from subject where id = ?");
    $sth->execute( $arr{itemid} );

    if ($DBI::errstr) {
	print qq{<h1>$lex{Delete} $lex{Record} $lex{Error}<br>\n};
	print qq{$lex{Contact}: $adminname ( $adminemail )\n};
    } else {
	print qq{<h1>$lex{Course} $arr{name} $lex{deleted}.</h1>\n};
    }

    print qq{<p>[ <a href="$reppage">$lex{'Report Card'}</a> | \n};
    print qq{<a href="subjdeled.pl">$lex{'Edit/Delete'} $lex{Course}</a> ]</p>\n}; 

    print qq{</body></html>\n};

    exit;

}
