#!/usr/bin/perl
#  Copyright 2001-2018 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Report Card' => 'Report Card',
	   'Multi-Track Mode' => 'Multi-Track Mode',
	   'Cannot open the term file' => 'Cannot open the term file',
	   'Term settings for schools that have different grade levels' =>
	     'Term settings for schools that have different grade levels',
	   'with different term numbers and dates' =>
	     'with different term numbers and dates',
	   'Term' => 'Term',
	   'Error' => 'Error',
	   'Terms' => 'Terms',
	   'Status' => 'Status',
	   'Track' => 'Track',
	   'Assessment Entry' => 'Mark Entry',
	   'Enabled' => 'Enabled',
	   'Disabled' => 'Disabled',
	   'Grades' => 'Grades',

	   );


use CGI;
use DBI;

my $self = 'termview.pl';

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;


# Setup Database access
my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Load Configuration Data.
my $sth = $dbh->prepare("select * from conf_system where dataname = 'r_MarkEntryTerm'");
# also previously loaded schoolyear section of admin file.

$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

while ( my $ref = $sth->fetchrow_hashref ) {
    # put value into namespace
    eval $ref->{datavalue};
    if ( $@ ) {
	print $lex{Error}. " $@<br>\n";
	die $lex{Error}. " $@\n";
    }
}


# Get the tracks in system
my @track;
foreach my $trk ( sort {$a <=> $b} keys %g_MTrackTerm ) { 
    push @track, $trk;
}


# Print start of page
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>\n};

if ( not @track ) {
    print qq{<h3>$lex{Error}: No Tracks Defined!</h3>\n};
    print qq{</body></html>\n};
    exit;
}


print qq{<table style="margin:0;border:1px solid gray;" cellpadding="3" cellspacing="0" border="0">\n};
print qq{<tr><th>$lex{Track}</th><th>$lex{Grades}</th><th>$lex{Term}</th><th>$lex{Status}</th></tr>\n};


my $status;
foreach my $trk ( @track ){

    # populate the grades.
    my @grades;
    foreach my $gr ( keys %g_MTrackTermType ) {
	if ( $g_MTrackTermType{$gr} eq $trk ) { # this grade is a member of current track
	    push @grades, $gr;
	}
    }
    my $grades = join(',',sort {$a <=> $b} @grades);		 

    if ( $r_MarkEntryTerm{$trk} ) { $status = $lex{Enabled}; } else { $status = $lex{Disabled}; }
    # removed the $trk value in brackeds in cell 1
    print qq{<tr><td class="bla">$g_TrackDisplay{$trk}</td><td>$grades</td>\n};
    print qq{<td class="cn">$r_MarkEntryTerm{$trk}</td><td class="la">$status</td></tr>\n};
}

print qq{</table></body></html>\n};
