#!/usr/bin/perl
#  Copyright 2001-2023 Leslie Richardson

#  This file is part of Open Admin for Schools.

# a report for contact log views on the administration site

my %lex = ('Main' => 'Main',
	   'Student' => 'Student',
	   'Student(s)' => 'Student(s)',
	   'Edit' => 'Edit',
	   'Add' => 'Add',
	   'Delete' => 'Delete',
	   'Category' => 'Category',
	   'New' => 'New',
	   'Description' => 'Description',
	   'Record(s) Stored' => 'Record(s) Stored',
	   'Contact Log' => 'Contact Log',
	   'Error' => 'Error',
	   'or' => 'or',
	   'Please Log In' => 'Please Log In',
	   'Save' => 'Save',
	   'Date' => 'Date',
	   'No Student(s) Found' => 'No Student(s) Found',
	   'Student Group' => 'Student Group',
	   'Grade' => 'Grade',
	   'Homeroom' => 'Homeroom',
	   'Or' => 'Or',
	   'Last,First/Last/Initials/Studnum' => 'Last,First/Last/Initials/Studnum',
	   'Next Page' => 'Next Page',
	   'Check' => 'Check',
	   'Continue' => 'Continue',
	   'Select' => 'Select',
	   'Mode' => 'Mode',
	   'Not Found' => 'Not Found',
	   'New' => 'New',
	   'No Record(s) Found' => 'No Record(s) Found',
	   'More' => 'More',
	   'Record(s)' => 'Record(s)',
	   'Deleted' => 'Deleted',

	   );

my $self = 'rptContactLog.pl';

use DBI;
use CGI;


eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
my %arr = $q->Vars;
print $q->header;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get Current Date
my @tim = localtime(time);
my $year = $tim[5] + 1900;
my $month = $tim[4] + 1;
my $day = $tim[3];
my $currdate = "$year-$month-$day";


# Print Page Header
my $title = "View $lex{'Contact Log'}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};


print qq{$chartype\n</head><body>\n};

print qq{<div>[ <a href="$homepage">$lex{Main}</a> ]</div>\n};
print qq{<h1>$lex{'Contact Log'}</h1>\n};

showContacts();


#-----------------
sub showContacts {
#-----------------

    my $sth1 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    my $sth2 = $dbh->prepare("select count(*) from studentwd where studnum = ?");
    my $sth3 = $dbh->prepare("select lastname, firstname from staff where userid = ?");
    
    my $sth = $dbh->prepare("select * from contactlog order by author, studnum, cdate desc");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $first = 1;
    
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;
	
	# Get Student Name
	$sth1->execute( $r{studnum});
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my ($ln,$fn) = $sth1->fetchrow;
	my $studname = qq{<b>$ln</b>, $fn};

	# Get Staff Name
	$sth3->execute( $r{author});
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my ($sln,$sfn) = $sth3->fetchrow;
	my $staffname = qq{<b>$sln</b>, $sfn};

	if ( $first ) { # print header
	    print qq{<table cellspacing="0" cellpadding="3" border="1">\n};
	    print qq{<tr><th>Staff</th><th>Student</th><th>Date</th>};
	    print qq{<th>Category</th><th>Description</th></tr>\n};
	    $first = 0;
	}

	print qq{<tr><td>$staffname<td>$studname</td>};
	print qq{<td>$r{cdate}</td><td>$r{category}</td>};
	print qq{<td>$r{description}</td></tr>\n};
    
    }


    if ( not $first ) {
	print qq{</table>\n};
    } else {
	print qq{<h3>No Records Found</h3>\n};
    }
    
    print qq{</body></html>\n};
    
    exit;

}
