#!/usr/bin/perl
#  Copyright 2001-2025 Leslie Richardson

#  This file is part of Open Admin for Schools.



my %lex = ('User Id' => 'User Id',
	   'Password' => 'Password',
	   'Duration' => 'Duration',
	   'Login' => 'Login',
	   'Log In' => 'Log In',
	   'Log Out' => 'Log Out',
	   'min' => 'min',
	   'No Userid Found' => 'No Userid Found',
	   'Incorrect Password' => 'Incorrect Password',
	   'Logged In' => 'Logged In',
	   'Error' => 'Error',
	   'Continue' => 'Continue',
	   'User' => 'User',
	   'Teacher Administration' => 'Teacher Administration',
	   'Announcements' => 'Announcements',
	   'Hover=Full View' => 'Hover on Title to see Full Text',
	   'View All' => 'View All',
	   'Logged Out' => 'Logged Out',
	   'Main' => 'Main',
	   'No Announcements' => 'No Announcements',

	   );

my $self = 'rptWorkMonthly.pl';

use DBI;
use CGI;
use Number::Format qw(:all);
use Time::JulianDay;

my %nonschools;
$nonschools{sese} = 1;



my $q = CGI->new;
my %arr = $q->Vars;
print $q->header;

eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

# get the hash that maps schools to FN's
eval require "/opt/openadmin/global/schoolmap.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

# get global user/password.
eval require "$globdir/global.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $title = qq{First Nation Contract Report - Monthly};


# Global user access to consultant DB.  (Note: dbhc handle)
my $newdbase = 'consultant';
my $dsnc = "DBI:$dbtype:dbname=$newdbase";
my $dbhc = DBI->connect($dsnc,$guser,$gpassword);

# Set Date
my @tim = localtime(time);
my $cyear = @tim[5] + 1900;
my $cmonth = @tim[4] + 1;
my $cday = @tim[3];
my $currdate = "$cyear-$cmonth-$cday";
my $curryrmo = "$cyear-$cmonth";

my $startyear = $cyear; # year at the start of the school year

if ( $cmonth < 8 ) { # Jan - July
    $startyear--; # decrement the yar
}


print qq{<!DOCTYPE html>\n};
print qq{<html><head><title>$title</title>\n};
print qq{<meta charset="utf-8">\n};
print qq{<link rel="stylesheet" type="text/css" href="$css">\n};
print qq{</head><body>\n};

print qq{<a href="top"></a>\n}; # anchor for the top of page
print qq{<h1>$title</h1>\n};

#foreach my $key ( sort keys %arr ) { print "K:$key VAL:$arr{$key}<br>\n"};

my $fn = $schoolmap{$dbase}; # dbase maps to a FN;
my $school = $dbase;
# school value here is from the school configuration. It may be another school in this FN for
# pages 2 and

# print "<div>School:$dbase FN:$fn</div>\n";

if ( not $arr{page} ) {
    showReport($fn);
    
} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    workUserMonthly( $arr{school}, $arr{yrmo}, $arr{schoolname} );
    
} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    workCategoryMonthly( $arr{school}, $arr{yrmo}, $arr{schoolname} );
} 




#-------------
sub showReport {
#-------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # Passed the First Nation as text.

    # $schoolmap is hash: school => First Nation.
    my $firstnation = $_[0];  # required since the contract is by First Nation, not school

    # Get All schools in this First Nation (ie. may be more that just value in $school)
    my @schools;
    foreach my $sch ( sort keys %schoolmap ) {
	if ( $schoolmap{$sch} eq $firstnation ) {
	    push @schools, $sch;
	}
    }
    # we now have all schools in this First Nation
    
    
    # Get Names of users from Apache consultant password file to display name
    use Apache::Htpasswd; # to read the consultant password file.
    my $basepath = '/etc/apache2/auth_users';
    my $file = 'consultant';
    my $ph = new Apache::Htpasswd("$basepath/$file");

    my %names;
    my @users = $ph->fetchUsers();
    foreach my $userid ( sort @users ) {
	my $name = $ph->fetchInfo($userid);
#	my @temp = split(/\s+/, $name);
#	my $fn = pop @temp;
#	my $ln = join(' ',@temp);
	$names{$userid} = $name;
    }

    
    # Load the contract record from consultant DB, populate @category
    my $sth = $dbhc->prepare("select * from contract where firstnation = ?");
    $sth->execute( $firstnation );
    if ($DBI::errstr){ print $DBI::errstr; die "$DBI::errstr\n"; };
    my $ref = $sth->fetchrow_hashref;
    my %contract = %r = %$ref;
    
    my @category;
    foreach my $cat ( sort keys %contract ) {
	if ( $cat eq 'firstnation' or $cat eq 'id' ) { next; }
	push @category, $cat;
    }


    # Setup Year-Month value to loop over for each month starting in August
    my @yrmo;
    my $y = $startyear; # set above.
    
    foreach my $idx (8 .. 12 ) {
	my $val = qq{$y-$idx};
	if ( $val eq $curryrmo ) { # match for end of array
	    push @yrmo, $val;
	    last;
	}
	push @yrmo, $val;
    }

    $y++; # next year
    foreach my $idx (1 .. 7) {
	my $val = qq{$y-$idx};
	if ( $val eq $curryrmo ) { # match for end of array
	    push @yrmo, $val;
	    last;
	}
	push @yrmo, $val;
    }
    # we now have array of years-month for the school year.
    
#    print qq{YRMO:@yrmo<br>\n};
    

    # we can now get work records for all schools in this FN, in all categories.
    my (%workfn, %work); # work for all schools in FN.
    my ($total, $totalused,$totalleft, $totalmonth);
    
    foreach my $yrmo ( @yrmo ) {
	my ($yr,$mo) = split('-', $yrmo);
    
	foreach my $school ( @schools ) {
    
	    my $sth = $dbhc->prepare("select * from worklog where school = ?
	       and year(date) = ? and month(date) = ?");
	    $sth->execute( $school, $yr,$mo );
	    if ($DBI::errstr){ print $DBI::errstr; die "$DBI::errstr\n"; };
	    while ( my $ref = $sth->fetchrow_hashref ) {
		my %r = %$ref;
		$workfn{$yrmo}{ $r{category} } += $r{hours};
		$work{$yrmo}{ $school }{ $r{category}} += $r{hours};
	    }
	}
    }

    
    
    # Summary Table first

    print qq{<h2 style="margin:1em;">First Nation - $firstnation</h2>\n};

    
    # Table Layout
    print qq{<table cellpadding="3" border="1" cellspacing="0" style="margin-bottom:2em;">\n};
    print qq{<caption style="font-weight:bold;font-size:120%;">Summary Table - All $firstnation Schools</caption>\n};
    
    print qq{<tr><th>Category</th><th>Contract<br>Days</th>};
    foreach my $yrmo (@yrmo) {
	my ($y,$m) = split('-',$yrmo);
	my $val = qq{$s_month[$m] $y};
	print qq{<th>Days Used<br>$val</th>};
    }
    print qq{<th>Days<br>Used</th><th>Days<br>Remaining</th></tr>\n}; # <th>Details</th></tr>\n};

	
    my ($contracttotal, $usedtotal, %totalmonth );

    
    foreach my $category ( @category ) {
	my $totalcat; # sum of this row
	
	print qq{<tr><td class="bla">$category</td><td class="cn">$r{$category}</td>};

	foreach my $yrmo ( @yrmo ) {
	
	    my $hoursused = $workfn{$yrmo}{$category};  # first nation values (all schools)
	    my $daysused = round($hoursused / 8, 1);
	    
	    $totalcat += $hoursused; # all months this row - col at end of row
	    $totalmonth{$yrmo} += $hoursused; # total for this month, all categories
	    $usedtotal += $hoursused;
	    
	    print qq{<td class="cn">$daysused</td>};
	
	}

	my $totalcatdays = round($totalcat / 8, 1); # convert to days
	print qq{<td class="cn">$totalcatdays</td>};
	
	my $daysleft = round( $r{$category} - $totalcatdays, 1);
	print qq{<td class="cn">$daysleft</td></tr>\n};

	$contracttotal += $r{$category};
	
    }


    # Totals Row
    print qq{<tr style="background-color:#DDD;"><td class="bra">Totals</td>};
    print qq{<td class="cn">$contracttotal</td>};

    foreach my $yrmo ( @yrmo ) {
	my $totalmonthday = round( $totalmonth{$yrmo} / 8, 1); # convert to days
	print qq{<td class="cn">$totalmonthday</td>};
    }

    my $usedtotalday = round($usedtotal / 8, 1); # convert to days
    print qq{<td class="cn">$usedtotalday</td>};

    my $lefttotal = round($contracttotal - $usedtotalday, 1);
    
    print qq{<td class="cn">$lefttotal</td></tr>\n};
    
    print qq{</table>\n};


    my %schoolnames; # hash with school names passed to the monthly reports

    
    
    # Loop Over all schools. There are NO Days remaining, since can't calc.
    foreach my $school ( @schools ) {

	if ( not $nonschools{$school} ) {
	
	    # Global user access to the school
	    my $dsn = "DBI:$dbtype:dbname=$school";
	    my $dbh = DBI->connect($dsn,$guser,$gpassword);

	    if ( $dbh ) { # we have a real school
		# Load schoolyear, etc. for this school
		my $sth = $dbh->prepare("select id, datavalue from conf_system where dataname = ?");
		foreach my $field ( qw(schoolstart schoolend schoolyear schoolname) ) {
		    $sth->execute( $field );
		    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
		    while ( my ($id, $datavalue) = $sth->fetchrow ) {
			eval $datavalue;
			if ( $@ ) {
			    print qq{$lex{Error}: $@<br>\n};
			    die "$lex{Error}: $@\n";
			}
		    }
		}
	    }
	    
	    $schoolnames{$school} = $schoolname;
	    
	} else { # not a school
	    $schoolname = $school;
	    $schoolnames{$school} = $school;
	}

	# Table Layout
	print qq{<table cellpadding="3" border="1" cellspacing="0" style="float:left;margin:0.5em;">\n};
	print qq{<caption style="font-weight:bold;font-size:120%;">$schoolname</caption>\n};
	
	print qq{<tr><th>Category</th>}; # removed this columns <th>Contract<br>Days</th>};
	foreach my $yrmo (@yrmo) {
	    my ($y,$m) = split('-',$yrmo);
	    my $val = qq{$s_month[$m] $y};
	    print qq{<th>Days Used<br>$val</th>};
	}
	print qq{<th>Days<br>Used</th></tr>\n};

	
	my ($contracttotal, $usedtotal, %totalmonth );

    
	foreach my $category ( @category ) {
	    my $totalcat; # sum of this row
	
	    print qq{<tr><td class="bla">$category</td>}; #<td class="cn">$r{$category}</td>};

	    foreach my $yrmo ( @yrmo ) {
	
		my $hoursused = $work{$yrmo}{$school}{$category};
		my $daysused = round($hoursused / 8, 1);
	    
		$totalcat += $hoursused; # all months this row - col at end of row
		$totalmonth{$yrmo} += $hoursused; # total for this month, all categories
		$usedtotal += $hoursused;
	    
		print qq{<td class="cn">$daysused</td>};
	
	    }

	    my $totalcatdays = round($totalcat / 8, 1); # convert to days
	    print qq{<td class="cn">$totalcatdays</td></tr>\n};
	
	    $contracttotal += $r{$category};
	
	} # end of category loop


	# Totals Row
	print qq{<tr style="background-color:#DDD;"><td class="bra">Totals</td>};
#	print qq{<td class="cn">$contracttotal</td>};

	foreach my $yrmo ( @yrmo ) {
	    my $totalmonthday = round( $totalmonth{$yrmo} / 8, 1); # convert to days
	    print qq{<td class="cn">$totalmonthday</td>};
	}

	my $usedtotalday = round($usedtotal / 8, 1); # convert to days
	print qq{<td class="cn">$usedtotalday</td></tr>\n};

    
	# Work User Month Row
	print qq{<tr><td class="bra">Opens New Tab</td>};
	
	foreach my $yrmo ( @yrmo ) {

	    print qq{<td class="cn">};
	    print qq{<form action="$self" method="post" };
	    print qq{target="_blank" style="display:inline;">\n};
	    print qq{<input type="hidden" name="page" value="1">\n};
	    print qq{<input type="hidden" name="yrmo" value="$yrmo">\n};
	    print qq{<input type="hidden" name="school" value="$school">\n};
	    print qq{<input type="hidden" name="schoolname" value="$schoolname">\n};
	    
	    print qq{<input type="submit" value="User"></form>};
	    print qq{</td>\n};

	}

	print qq{<td colspan="2"></tr>\n};

	
	# Work Category Month Row
	print qq{<tr><td class="ra"></td>};
	
	foreach my $yrmo ( @yrmo ) {

	    print qq{<td class="cn">};
	    print qq{<form action="$self" method="post" };
	    print qq{target="_blank" style="display:inline;">\n};
	    print qq{<input type="hidden" name="page" value="2">\n};
	    print qq{<input type="hidden" name="yrmo" value="$yrmo">\n};
	    print qq{<input type="hidden" name="school" value="$school">\n};
	    print qq{<input type="hidden" name="schoolname" value="$schoolname">\n};
	    print qq{<input type="submit" value="Category"></form>};
	    print qq{</td>\n};

	}

	print qq{<td></tr>\n};
	
    
	print qq{</table>\n};


    } # end of schools loop
    

    exit;

} # end of showReport();



#------------------
sub workUserMonthly { # passed a year-month, school  show all work done by users.
#------------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # Passed year-month and school

    my ($school, $yrmo, $schoolname) = @_;
    my ($yr,$mo) = split('-', $yrmo);

    # Get Names of users from Apache consultant password file to display name
    use Apache::Htpasswd; # to read the consultant password file.
    my $basepath = '/etc/apache2/auth_users';
    my $file = 'consultant';
    my $ph = new Apache::Htpasswd("$basepath/$file");

    my %names;
    my @users = $ph->fetchUsers();
    foreach my $userid ( sort @users ) {
	my $name = $ph->fetchInfo($userid);
	my @temp = split(/\s+/, $name);
	my $fn = shift @temp;
	my $ln = join(' ',@temp);
	$names{$userid} = qq{<b>$ln</b>, $fn};

    }

    # Get Users for this month, and setup sorted list.
    my (%sort, @sort);

    my $sth = $dbhc->prepare("select distinct userid from worklog where school = ?
       and year(date) = ? and month(date) = ?");
    $sth->execute( $school, $yr,$mo );
    if ($DBI::errstr){ print $DBI::errstr; die "$DBI::errstr\n"; };
    while ( my $userid = $sth->fetchrow ) {
	$sort{"$names{$userid}$userid"} = $userid;
    }

    print qq{<form style="margin:1em;"><input type="hidden" name="none">\n};
    print qq{<input type="button" value="Close Tab" onClick="parent.close()"></form>\n};

    
    # Table Layout
    print qq{<table cellpadding="3" border="1" cellspacing="0" style="margin: 0.5em 2em;">\n};
    print qq{<caption style="font-weight:bold;font-size:120%;">Monthly Report - $schoolname - };
    print qq{$month[$mo] $yr</caption>\n};
    
    print qq{<tr><th>Date</th><th>Category</th><th>Hours</th><th>Description</th></tr>};

    my $sth = $dbhc->prepare("select * from worklog where school = ?
       and year(date) = ? and month(date) = ? and userid = ? order by date");

    foreach my $key ( sort keys %sort ) {
	my $userid = $sort{$key};
	print qq{<tr><td colspan="4" style="background-color:#EEE;">$names{$userid} ($userid)</td></tr>\n};
  
	$sth->execute( $school, $yr,$mo, $userid );
	if ($DBI::errstr){ print $DBI::errstr; die "$DBI::errstr\n"; };
	while ( my $ref = $sth->fetchrow_hashref ) {
	    my %r = %$ref;
	    print qq{<tr><td>$r{date}</td><td>$r{category}</td><td>$r{hours}</td>};
	    print qq{<td style="width:60ch;">$r{description}</td></tr>\n};
	}
#	print qq{<tr><td colspan="4"><hr></td></tr>\n};
    }

    print qq{</table>\n};

    print qq{<form style="margin:1em;"><input type="hidden" name="none">\n};
    print qq{<input type="button" value="Close Tab" onClick="parent.close()"></form>\n};
       
    print qq{</body></html>\n};
    
    exit;
}


#----------------------
sub workCategoryMonthly { # passed a year-month, school  show all work done by users.
#----------------------

    #foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # Passed year-month and school and schoolname

    my ($school, $yrmo, $schoolname) = @_;
    my ($yr,$mo) = split('-', $yrmo);

    # Get Names of users from Apache consultant password file to display name
    use Apache::Htpasswd; # to read the consultant password file.
    my $basepath = '/etc/apache2/auth_users';
    my $file = 'consultant';
    my $ph = new Apache::Htpasswd("$basepath/$file");

    my %names;
    my @users = $ph->fetchUsers();
    foreach my $userid ( sort @users ) {
	my $name = $ph->fetchInfo($userid);
	my @temp = split(/\s+/, $name);
	my $fn = shift @temp;
	my $ln = join(' ',@temp);
	$names{$userid} = qq{<b>$ln</b>, $fn};

    }

    
    # Get Categories for this month, and setup sorted list.
    my @category;
    my $sth = $dbhc->prepare("select distinct category from worklog where school = ?
       and year(date) = ? and month(date) = ? order by category");
    $sth->execute( $school, $yr,$mo );
    if ($DBI::errstr){ print $DBI::errstr; die "$DBI::errstr\n"; };
    while ( my $cat = $sth->fetchrow ) {
	push @category, $cat
    }

    print qq{<form style="margin:1em;"><input type="hidden" name="none">\n};
    print qq{<input type="button" value="Close Tab" onClick="parent.close()"></form>\n};

    
    # Table Layout
    print qq{<table cellpadding="3" border="1" cellspacing="0" style="margin: 0.5em 2em;">\n};
    print qq{<caption style="font-weight:bold;font-size:120%;">Monthly Report - $schoolname - $month[$mo] $yr};
    print qq{</caption>\n};
    
    print qq{<tr><th>Date</th><th>User</th><th>Hours</th><th>Description</th></tr>};

    my $sth = $dbhc->prepare("select * from worklog where school = ?
       and year(date) = ? and month(date) = ? and category = ? order by date");

    foreach my $category ( @category ) {
	print qq{<tr><td colspan="4" style="background-color:#EEE;font-weight:bold;">$category</td></tr>\n};
  
	$sth->execute( $school, $yr,$mo, $category );
	if ($DBI::errstr){ print $DBI::errstr; die "$DBI::errstr\n"; };
	while ( my $ref = $sth->fetchrow_hashref ) {
	    my %r = %$ref;
	    print qq{<tr><td>$r{date}</td><td>$names{$r{userid}}</td><td>$r{hours}</td>};
	    print qq{<td style="width:60ch;">$r{description}</td></tr>\n};
	}

    }

    print qq{</table>\n};

    print qq{<form style="margin:1em;"><input type="hidden" name="none">\n};
    print qq{<input type="button" value="Close Tab" onClick="parent.close()"></form>\n};
       
    print qq{</body></html>\n};
    
    exit;
}
