#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.


my %lex = ('Enrollment by Age' => 'Enrollment by Age',
	   'Main' => 'Main',
	   'Printing Date' => 'Printing Date',
	   'Age Group' => 'Age Group',
	   'Boys' => 'Boys',
	   'Girls' => 'Girls',
	   'Male' => 'Male',
	   'Female' => 'Female',
	   'Total' => 'Total',
	   'Aging Date' => 'Aging Date',
	   'Error' => 'Error',
	   'Continue' => 'Continue',
	   'Blank=Today' => 'Blank=Today',

	   );


use DBI;
use CGI;

my $self = 'rptenrolage.pl';

eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my ($sec, $min, $hour, $mday, $mon, $year, $wday, 
 $yday, $iddst) = localtime(time);
$year = $year + 1900;
$mon++;
$wday++;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";

my $q = new CGI;
print $q->header( -charset, $charset );
%arr = $q->Vars;


print qq{$doctype\n<html><head><title>$lex{'Enrollment by Age'}</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>[ <a href="$homepage">$lex{Main}</a> ]\n};

print qq{<h1>$lex{'Enrollment by Age'}</h1>\n};

if ( not $arr{page} ) {
    showStartPage();
} 


my ($date,$yr,$mo,$da);
if ( not $arr{agingdate} ) {
    $yr = $year;
    $mo = $mon;
    $da = $mday;
} else {
    $date = $arr{agingdate};
    ( $yr, $mo, $da ) = split /-/, $date;
}


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



print qq{<h3>$lex{'Printing Date'}: $currdate</h3>\n};
print qq{<caption><b>$lex{'Aging Date'}: $yr-$mo-$da</b></caption>\n};


my %ages;
$sth = $dbh->prepare("select sex, birthdate from student order by birthdate");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::erstr; die $DBI::errstr; }

while ( my ($sex,$birthdate) = $sth->fetchrow ) {
    my $age;
    if (not $birthdate or $birthdate eq '0000-00-00'){ next; }
    ($curryear, $currmonth,$currday) = split /-/,$birthdate;
    $age = $yr - $curryear;  #first subtract years  
    if ($currmonth > $mo) { $age-- }
    if ($currmonth == $mo and $currday > $da) { $age-- } 
    
    $student = "$age$sex:$age:$sex";
    push @rec, $student;  #push data into array
}

print qq{</table><table border="1" cellpadding="4" cellspacing="0">\n};

print qq{<tr><th>$lex{'Age Group'}</th><th>$lex{Male}</th>};
print qq{<th>$lex{Female}</th><th>$lex{Total}</th></tr>\n};

my $curage = 0;
my $cursex = "";
my $boycount = 0;
my $girlcount = 0;

@sortedrec = sort {$a <=> $b } @rec;
foreach my $arrayref ( @sortedrec ) {
    ($blank,$age,$sex) = split /:/, $arrayref;
    if ( $age != $curage and $curage != 0 ) { # we have a new agegroup
	$total = $boycount + $girlcount;
	print qq{<tr><td>$curage</td><td>$boycount</td>};
	print qq{<td>$girlcount</td><td>$total</td><tr>\n}; 
	$boycount = 0;
	$girlcount = 0;
    }
   
    $curage = $age;
    if ($sex eq "M") {
	$boycount ++;
    } else {
	$girlcount ++;
    }  
}

$total = $boycount + $girlcount;

print qq{<tr><td>$curage</td><td>$boycount</td>};
print qq{<td>$girlcount</td><td>$total</td><tr>\n};
print qq{</table></body></html>\n};




#----------------
sub showStartPage {
#----------------

    print qq{<link rel="stylesheet" type="text/css" media="all" };
    print qq{href="/js/calendar-blue.css" title="blue">\n};
    print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellspacing="0" border="0" cellpadding="3">\n};

    print qq{<tr><td class="bra">$lex{'Aging Date'}</td><td class="la">\n};
    print qq{<input type="text" name="agingdate" size="12" id="agingdate">\n};
    print qq{<button type="reset" id="start_trigger">...</button> $lex{'Blank=Today'}};
    print qq{</td></tr>\n};

    print qq{<tr><td></td><td class="la"><input type="submit" value="$lex{Continue}">\n};
    print qq{</td></tr></table></form>\n};

    print qq{<script type="text/javascript">
     Calendar.setup({
        inputField     :    "agingdate", // id of the input field
        ifFormat       :    "%Y-%m-%d", // format of the input field
        button         :    "start_trigger", // trigger for the calendar (button ID)
        singleClick    :    false,        // double-click mode
        step           :    1             // show all years in drop-down boxes 
    })};

    print qq{</script>\n};
    print qq{</body></html>\n};

    exit;


}
