#! /usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('House League Report' => 'House League Report',
	   'Main' => 'Main',
	   'View/Download' => 'View/Download',
	   'View Log File' => 'View Log File',
	   'Students' => 'Students',
	   'Error' => 'Error',

	   );

use DBI;
use CGI;

my $maxlines = 28; # maximum number of lines before we start a new page....

eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, 
 $iddst) = localtime(time);
$year = $year + 1900;
$mon++;
$wday++;

my $currdate = "$dow[$wday], $month[$mon] $mday, $year";

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $title = $lex{'House League Report'};

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>[ <a href="$homepage">$lex{Main}</a> ]\n};

print qq{<h1>$title</h1>\n};

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $shortname = "houseleague$$";
my $filename = "$shortname.tex";

open(TEX,">$filename") || die "Can't open tex file";

my $papersize;
if ( $defaultpapersize ) {
    $papersize = $defaultpapersize;
} else {
    $papersize = 'letterpaper';
}

# removed inputenc package;
print TEX "\\documentclass[12pt,$papersize]{article}
\\usepackage{array}
%$a_latex_header
\\renewcommand{\\familydefault}{\\sfdefault}
\\pagestyle{empty}
\\setlength{\\textwidth}{7.50in}
\\setlength{\\textheight}{10in}
\\setlength{\\hoffset}{-0.5in}
\\setlength{\\voffset}{-1.4in}
\\setlength{\\parindent}{0in}
\\setlength{\\evensidemargin}{0in}
\\setlength{\\oddsidemargin}{0in}
\\setlength{\\extrarowheight}{4pt}
\n";

print TEX "\\begin{document}\n";

$sth = $dbh->prepare("select * from student 
  order by house, homeroom,lastname,firstname");
$sth->execute;

my $curhouse = "none";
my $curroom = -1;
my $studcount;
my $linecount;
my $first = 1;

while ( my $ref = $sth->fetchrow_hashref ) {
    my %r = %$ref;

    $oldhouse = $curhouse;
    $oldroom = $curroom;

    $curhouse = $r{house};
    $curroom = $r{homeroom};;

    if ( not $curhouse ) {
	$curhouse = 'No Houseleague Set';
    }

    
    if ( $oldhouse eq $curhouse ) { # We have another record for same house
	$linecount++;
	$studcount++;

	if ($linecount > $maxlines ) {
	    print TEX "\\hline\n\\end{tabular}\\\\ \n \\newpage \n";
	    $linecount = 0;
	    print TEX  "{\\large $lex{'House League Report'}}\\\\\n";
	    print TEX "\\begin{tabular}{|p{62mm}|p{16mm}|p{10mm}|p{10mm}|";
	    print TEX "p{10mm}|p{10mm}|p{10mm}|p{10mm}|p{10mm}|}";
	    print TEX "{\\small $currdate} & & & & & & & & \\\\ & & & & & & & & \\\\\n";
	    print TEX "{\\Large\\sf $curhouse} & & & & & & & & \\\\ \\hline\n";
	}

	print TEX  "\\textbf{ $r{lastname}, $r{firstname} ($r{homeroom}) }& & & & & & & & \\\\ ";
	print TEX "\\hline\n";

    } else {  # We are starting a new house (on new page)

	if ( not $first ) {
	    print TEX "\n\\end{tabular}\\\\ \n\\medskip\n\n\\textbf{\\large ";
	    print TEX $lex{Students}. ": $studcount}\n\\newpage\n";
	}
	$studcount = 1;
	$linecount = 0;
	$first = 0;
	
	print TEX "\n{\\large $lex{'House League Report'}}\\\\\n";
	print TEX "\\begin{tabular}{|p{62mm}|p{16mm}|p{10mm}|p{10mm}|p{10mm}|";
	print TEX "p{10mm}|p{10mm}|p{10mm}|p{10mm}|}";
	print TEX "{\\small $currdate} & & & & & & & & \\\\  & & & & & & & & \\\\ \n";
	print TEX "{\\Large\\sf $curhouse} & & & & & & & & \\\\ \\hline\n";
	print TEX "\\textbf{ $r{lastname}, $r{firstname} ($r{homeroom}) }& &  &  &  &  &  & & \\\\ ";
	print TEX "\\hline\n";
    }
    
}  # End of For loop for printing student names

# Print ending of report
if ( not $first ) {
    print TEX "\n\\end{tabular}\n\\medskip\n\n";
    print TEX " \\textbf{\\large $lex{Students}: $studcount}\\\\ \n \\end{document}\n";
}
close TEX;

system("$pdflatex $filename >pdflog$$.txt");
system("mv $shortname.pdf $downloaddir");
system("mv pdflog$$.txt $downloaddir");
system("rm -f $shortname.*");

print qq{<h3><a href="$webdownloaddir/$shortname.pdf">};
print qq{$lex{'View/Download'} $lex{'House League Report'}</a></h3>\n};
print qq{<p>[ <a href="$webdownloaddir/pdflog$$.txt">$lex{'View Log File'}</a> \n}; 
print qq{| <a href="$homepage">$lex{Main}</a> ]</p>\n};
print qq{</body></html>\n};
