#!/usr/bin/perl
# Copyright Les Richardson 2001-2025

# This file is part of Open Administration for Schools. Released under GPL Licensing.

my %lex = ('Reset' => 'Reset',
	   'Course' => 'Course',
	   'Courses' => 'Courses',
	   'Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'Continue' => 'Continue',
	   'Fields' => 'Fields',
	   'Field' => 'Field',
	   'Type' => 'Type',
	   'Enter Values' => 'Enter Values',
	   'Select from List' => 'Select from List',
	   'No Field Selected' => 'No Field Selected',
	   'Field Fill' => 'Field Fill',
	   'Grade' => 'Grade',
	   'Homeroom' => 'Homeroom',
	   'Student Group' => 'Student Group',
	   'Separate with Spaces' => 'Separate with Spaces',
	   'Blank=All' => 'Blank=All',
	   'Student' => 'Student',
	   'Contact' => 'Contact',
	   'Error' => 'Error',
	   'Record(s) Updated' => 'Record(s) Updated',
	   'Blank' => 'Blank',
	   'Students' => 'Students',
	   'Current' => 'Current',
	   'Withdrawn' => 'Withdrawn',
	   'Update' => 'Update',
	   'Select' => 'Select',

	   );


my $self = 'coursecodeview.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;
my $first;
if ( not %arr ) { $first = 1; }

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Show top of page.
my $title = qq{Course Code View};


print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};

print qq{<h1>$title</h1>\n};


showCodes();


#--------------
sub showCodes {
#--------------
    
    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    # Get the grades
    my $sth = $dbh->prepare("select distinct grade from sasked_courses 
      where grade is not NULL and grade != ''");
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    $sth->execute;
    my @grades;
    while ( my $gr = $sth->fetchrow ) {
	push @grades, $gr;
    }
    @grades = sort {$a <=> $b} @grades;

    # Get the types (locally developed, etc)
    my $sth = $dbh->prepare("select distinct ctype from sasked_courses 
     where ctype is not NULL order by ctype");
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    $sth->execute;
    my @types;
    while ( my $type = $sth->fetchrow ) {
	push @types, $type;
    }

    print qq{<h3>Saskatchewan Ministry of Education Courses</h3>\n};

    print qq{<form action="$self" method="post">\n};
    print qq{<table cellpadding="4" cellspacing="0" border="1" style="margin-bottom:1em;">\n};
    
    # Grade
    print qq{<tr><td class="bra">Select Grade</td><td>};
    foreach my $grade (@grades) {
	my $checked;
	if ( $arr{grade} eq $grade ) { $checked = qq{checked="checked"}; }
	print qq{<input type="radio" name="grade" value="$grade" $checked>$grade\n};
    }
    print qq{<input type="radio" name="grade" value="" $checked>ALL</td></tr>\n};

    # Dev Type
    print qq{<tr><td class="bra">Type</td><td><select name="type"><option value="$arr{type}">$arr{type}</option>\n};
    foreach my $type ( @types ) {
	print qq{<option>$type</option>\n};
    }
    print qq{<option value=""></option></select></td></tr>\n};

   
    # Active
    print qq{<tr><td class="bra">Active Only</td><td><input type="radio" name="active" value="1" };
    print qq{checked="checked">Yes\n};
    print qq{<input type="radio" name="active" value="0">No</td></tr>\n};


    # Skip French
    print qq{<tr><td class="bra">Show French Courses</td><td><input type="checkbox" name="showfrench" value="1" };
    if ( $arr{showfrench} ) { print qq{checked="checked"}; }
    print qq{></td></tr>\n};

    # Continue
    print qq{<tr><td colspan="2" class="la"><input type="submit" value="Continue"></td></tr>\n};
    print qq{</table></form>\n};

    if ( $first ) { # stop here.
	print qq{</body></html>\n};
	exit;
    }
    
    
    print qq{<table cellpadding="4" cellspacing="0" border="1" style="background-color:#EEE;">\n};
    print qq{<tr><th>Course</th><th>Code</th><th>Start</th><th>End</th><th>Grade</th>};
    print qq{<th>Development Type</th><th>Language</th><th>PAA/ART</th></tr>\n};
    
    print qq{<caption style="font-weight:bold;font-size:120%;">};
    print qq{Courses without end dates are active courses.</caption>\n};

    my @select;
    if ( $arr{grade}) {
	my $grade = qq{ grade = '$arr{grade}' };
	push @select, $grade;
    }
    if  ( $arr{active} ) {
	my $active = qq{ (enddate is NULL or enddate = '0000-00-00') };
	push @select, $active;
    }

    if  ( $arr{type} ) {
	my $type = qq{ ctype = '$arr{type}' };
	push @select, $type;
    }

    if ( not $arr{showfrench} ) { # reverse sense; no French by default.
	push @select, qq{ (lang is NULL or lang = 'English') };
    }

    
    if ( @select ) {
	$select = 'where '. join('and', @select);
    }
    
    print qq{<tr><td colspan="8">Select: $select</td></tr>\n};
    
    my $sth = $dbh->prepare("select * from sasked_courses $select order by cast(grade as int), title");
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    $sth->execute;
    
    
    # Loop through Courses
    my $count = 1;
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;
	if ( $r{enddate} eq '0000-00-00' ) { $r{enddate} = ''; }
	
	print qq{<tr><td>$count. $r{title}</td><td>$r{code}</td>};
	print qq{<td>$r{startdate}</td><td>$r{enddate}</td>};
	print qq{<td>$r{grade}</td><td>$r{ctype}</td><td>$r{lang}</td><td>$r{grptype}</td></tr>\n};
	$count++;
	if ( $count % 20 == 0 ) {
	    print qq{<tr><th>Course</th><th>Code</th><th>Start</th><th>End</th><th>Grade</th>};
	    print qq{<th>Development Type</th><th>Language</th></th><th>PAA/ART</th></tr>\n};
	}

	
    } # End of Course Loop

    print qq{</table></body></html>\n};

    exit;

} # end of selectChanges

