#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson
#  This file is part of Open Administration for Schools

use DBI;
use CGI;

# Pull completed courses from local copy of data.

my $self = 'viewcompletedsummary.pl';

my %lex = ( 'Main' => 'Main',
	    'Error' => 'Error',
	    'Grade' => 'Grade',
	    'Homeroom' => 'Homeroom',
	    'Group' => 'Group',
	    'Separate with Spaces' => 'Separate with Spaces',
	    'Blank=All' => 'Blank=All',
	    'Continue' => 'Continue',
	    'Report Card' => 'Report Card',
	    'School' => 'School',
	    'View' => 'View',
	    'Completed Courses' => 'Completed Courses',
	    'Select' => 'Select',
	    'Student' => 'Student',
	    'Blank=All' => 'Blank=All',
	    'Summary' => 'Summary',
	    'Details', => 'Details',


	    );


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


my $q = CGI->new;
my %arr = $q->Vars;
print $q->header( -charset, $charset ); 

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my @tim = localtime(time);
my $year = $tim[5] + 1900;
$tim[4]++;
for (0..4){if (length($tim[$_]) == 1){ $tim[$_] = '0'.$tim[$_];}}
my $currdate = "$year-$tim[4]-$tim[3]";
my $currtime = "$tim[2]:$tim[1]:$tim[0]";

my $title = "$lex{Summary} $lex{'Completed Courses'}";

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n};
print qq{</head><body>\n};
print qq{[ <a href="$reppage">Report Card</a> ]\n};

if ( not $arr{page} ) {
    print qq{<form action="updatecompletedcourses.pl" method="post" style="display:inline;">\n};
    print qq{<input type="submit" value="Update Completed Courses from Sask Ed">\n};
    print qq{</form><p></p>\n};
}

print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    getCourseHistory();
}


#----------------
sub showStartPage {
#----------------

    # Setup the form and start of table.
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellpadding="3" border="0" cellspacing="0">\n};
    
    print qq{<tr><td class="bla">$lex{Grade} <input type="text" name="grade" size="8"></td></tr>\n};

    print qq{<tr><td class="la">};
    print qq{<input type="submit" value="$lex{Continue}"></td></tr>\n};

    print qq{</table></form>\n};
    print qq{</body></html>\n};

    exit;

}


#-------------------
sub getCourseHistory {
#-------------------

    #foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }    

    my $grade = $arr{grade};

    if ( not $grade ) {
	print qq{<h3>No Entry</h3>\n};
	print qq{</body></html>\n};
	exit;
    }


    my $sth = $dbh->prepare("select lastname, firstname, provnum from student where grade = ?"); 
    $sth->execute( $grade );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }


    # Setup to get student data from table
    my $sth1 = $dbh->prepare("select sum(creditsearned) from sasked_completedcourses where provnum = ?"); 

    my %studentcredits;
    my %studentname;
    my %studentsort;

    while ( my ($lastname, $firstname, $provnum ) = $sth->fetchrow ) {

	if ( not $provnum ) {
	    print qq{<h3>Skipping $firstname $lastname. No provincial Number</h3>\n};
	    next;
	}

	# Get Total Credits.
	$sth1->execute( $provnum );
	 if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my $totalcredits = $sth1->fetchrow;

	my $padcredits = sprintf("%03d", $totalcredits);

	my $key = "$padcredits$lastname$firstname$provnum";
	$studentsort{$key} = $provnum;

	$studentcredits{$provnum} = $totalcredits;
	$studentname{$provnum} = "<b>$lastname</b>, $firstname";

    }


    if ( not %studentcredits ) {
	print qq{<h3>Students Not Found</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    print qq{<h3>Grade $grade</h3>\n};
    print qq{<table cellpadding="4" cellspacing="0" border="1">\n};
    print qq{<tr><th>Name</th><th>Credits</th><th></th></tr>\n};

    my $studcount = 1;

    foreach my $key ( sort keys %studentsort ) {
	my $provnum = $studentsort{$key};
	print qq{<tr><td>$studcount. $studentname{$provnum}</td><td>$studentcredits{$provnum}</td>};

	print qq{<td><form action="viewcompletedcourses.pl" method="post" target="_new">\n};
	print qq{<input type="hidden" name="$provnum" value="1">\n};
	print qq{<input type="hidden" name="page" value="2">\n};
	print qq{<input type="submit" value="$lex{Details}"></form></td>\n};

	print qq{</tr>\n};
	$studcount++;

    }

    print qq{</table></body></html>\n};

} # end of getCourseHistory
