#!/usr/bin/perl
#  Copyright 2001-2019 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

%lex = ('Edit' => 'Edit',
	'Main' => 'Main',
	'Error' => 'Error',
	'School Events' => 'School Events',
	'Select Month' => 'Select Month',
	'Save' => 'Save',
	'Community Events' => 'Community Events',
	'Staff Updates' => 'Staff Updates',
	'Record Updated' => 'Record Updated',
	'Upcoming Events' => 'Upcoming Events',
	'Data Updates' => 'Data Updates',
	'Resource Spending' => 'Resource Spending',
	'Facility Updates' => 'Facility Updates',
	'Other Updates' => 'Other Updates',
	'Update' => 'Update',
	'Other Records' => 'Other Records',
	'Land Based Learning' => 'Land Based Learning',
	
	 );

my $self = 'event_add.pl';

use CGI;
use DBI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = new CGI;
print $q->header(-charset, $charset ); 
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
my $title = "$lex{Edit} $lex{'School Events'}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};

print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};

print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    editRecord();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    writeRecord();
}




#----------------
sub showStartPage {
#----------------

    print qq{<table cellpadding="3" border="0" cellspacing="0" style="margin:1em 3em;">\n};
    print qq{<tr><th>$lex{'Select Month'}</th></tr>\n};

    # Setup Year-Months.
    my @months;
    my %months;

    my ($sy, $sm, $sd) = split('-', $schoolstart); # schoolstart is global var from config.
    my $yrmo = "$sy-$sm";
    push @months, $yrmo;
    $months{$yrmo} = "$s_month[$sm]-$sy";

    for my $i (1..10) {
	my $mo = $sm + $i;
	my $yr = $sy;
	if ( $mo > 12 ) {
	    $mo = $mo - 12;
	    $yr++;
	}
	my $yrmo = "$yr-$mo";
	push @months, $yrmo;
	$months{$yrmo} = "$s_month[$mo]-$yr";
    }

    foreach my $mo ( @months ) {

	print qq{<tr><td class="la">};
	print qq{<form action="$self" method="post">\n};
	print qq{<input type="hidden" name="page" value="1">\n};
	print qq{<input type="hidden" name="month" value="$mo">\n};
	print qq{<input type="submit" value="$months{$mo}">\n};
	print qq{</form></td></tr>\n};

    }

    print qq{</table>\n};
    print qq{</body></html>\n};

    exit;
}


#-------------
sub editRecord {
#-------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    my $month = $arr{month};
    my ($y,$m) = split('-', $month);
    $month .= '-01';

#    print "Month:$month<br>\n";

    # Load Existing Record (if any)
    my $sth = $dbh->prepare("select * from schoolevent where date = ?");
    $sth->execute( $month );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
    my $ref = $sth->fetchrow_hashref;
    my %r = %$ref;

    # Now show the form.
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="hidden" name="date" value="$month">\n};

    
    print qq{<table cellpadding="3" border="0" cellspacing="0" style="margin:1em 3em;">\n};
    print qq{<caption style="font-size:150%;font-weight:bold;">$month[$m] - $y</caption>\n};
    print qq{<tr><td></td><td class="la"><input type="submit" value="$lex{Save}"></td></tr>\n};

    print qq{<tr><td class="bra">$lex{'Community Events'}</td>};
    print qq{<td><textarea name="communityevents" rows="4" cols="70">$r{communityevents}</textarea></td></tr>\n};
    
    print qq{<tr><td class="bra">$lex{'Upcoming Events'}</td>};
    print qq{<td><textarea name="upcomingevents" rows="4" cols="70">$r{upcomingevents}</textarea></td></tr>\n};

    print qq{<tr><td class="bra">$lex{'Staff Updates'}</td>};
    print qq{<td><textarea name="staffupdates" rows="4" cols="70">$r{staffupdates}</textarea></td></tr>\n};
    
    print qq{<tr><td class="bra">$lex{'Data Updates'}</td>};
    print qq{<td><textarea name="dataupdates" rows="4" cols="70">$r{dataupdates}</textarea></td></tr>\n};
    
    print qq{<tr><td class="bra">$lex{'Resource Spending'}</td>};
    print qq{<td><textarea name="resourcespending" rows="4" cols="70">$r{resourcespending}</textarea></td></tr>\n};
    
    print qq{<tr><td class="bra">$lex{'Facility Updates'}</td>};
    print qq{<td><textarea name="facilityupdates" rows="4" cols="70">$r{facilityupdates}</textarea></td></tr>\n};
    
    print qq{<tr><td class="bra">$lex{'Land Based Learning'}</td>};
    print qq{<td><textarea name="landedu" rows="4" cols="70">$r{landedu}</textarea></td></tr>\n};

    print qq{<tr><td class="bra">$lex{'Other Updates'}</td>};
    print qq{<td><textarea name="otherupdates" rows="4" cols="70">$r{otherupdates}</textarea></td></tr>\n};

    print qq{<tr><td></td><td class="la"><input type="submit" value="$lex{Save}"></td></tr>\n};
    print qq{</table></form>\n};

    exit;

}


#--------------
sub writeRecord {
#--------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    # Check for existing record (so just update)
    $sth = $dbh->prepare("select * from schoolevent where date = ?");
    $sth->execute( $arr{date} );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;

    if ( $ref->{id} ) { # update existing
	my %r = %$ref;

	my $id = $r{id};
	delete $r{id};

	foreach my $key ( keys %r ) {
	    $sth = $dbh->prepare("update schoolevent set $key = ? where id = $id");
	    if ( $r{$key} ne $arr{$key} ) { # changed value
		$sth->execute( $arr{$key} );
		if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    }
	}

    } else { # add a new record
	my $sth = $dbh->prepare("insert into schoolevent 
             (date, communityevents,staffupdates,dataupdates,resourcespending,facilityupdates,otherupdates, upcomingevents, landedu)
             values(?,?,?,?,?,?,?,?,?)");
	$sth->execute( $arr{date}, $arr{communityevents},$arr{staffupdates},$arr{dataupdates},$arr{resourcespending},
		       $arr{facilityupdates},$arr{otherupdates}, $arr{upcomingevents}, $arr{landedu} );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }


    }

    print qq{<h3>$lex{'Record Updated'}</h3>\n};

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="submit" value="$lex{Update} $lex{'Other Records'}">\n};
    print qq{</form>\n};

    print qq{</body></html>\n};

    exit;

}
