#! /usr/bin/perl
#  Copyright 2001-2020 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'No Student(s) Found' => 'No Student(s) Found',
	   'Parent' => 'Parent',
	   'Access Control' => 'Access Control',
	   'Continue' => 'Continue',
	   'Homeroom' => 'Homeroom',
	   'Grade' => 'Grade',
	   'Blank=All' => 'Blank=All',
	   'Students' => 'Students',
	   'Select by' => 'Select by',
	   'Not Found' => 'Not Found',
	   'Error' => 'Error',
	   'Single Value Only' => 'Single Value Only',
	   'Check' => 'Check',
	   'Next Page' => 'Next Page',
	   'Report Card' => 'Report Card',
	   'Gradebook' => 'Gradebook',
	   'Disable' => 'Disable',
	   'Student' => 'Student',
	   'Lockout' => 'Lockout',
	   'Save' => 'Save',
	   'Records' => 'Records',
	   'Updated' => 'Updated',

	   );

my $self = 'setlockout.pl';

use DBI;
use CGI;


eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = "$lex{Parent} $lex{'Access Control'}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body style="padding:1em 5em;">\n};
print qq{<div>[ <a href="$homepage">$lex{Main}</a> ]</div>\n};

print qq{<h1>$title</h1>\n};

if ( not $arr{page} ) {
    showStartPage();
    
} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showStudents();

}  elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    setLockout();
}


#---------------
sub showStudents {
#---------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # passed either grade or homeroom

    
    my @students;
    my %students;

    if ( $arr{grade} ) {

	$sth = $dbh->prepare("select lastname, firstname, studnum, parent_lockout from student 
             where grade = ? order by lastname, firstname");
	$sth->execute( $arr{grade} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	while ( my ( $lastname, $firstname, $studnum, $lockout ) = $sth->fetchrow ) { 
	    push @students, $studnum;
	    $students{$studnum} = { 'lastname' => $lastname, 
				    'firstname' => $firstname, 
				    'lockout' => $lockout };
	}
	 
    } elsif ( $arr{homeroom} ) { # homeroom

	my $sth = $dbh->prepare("select lastname, firstname, studnum, parent_lockout from student 
             where homeroom = ? order by lastname, firstname");
	$sth->execute( $arr{homeroom} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	while ( my ($lastname, $firstname, $studnum, $lockout ) = $sth->fetchrow ) { 
	    push @students, $studnum;
	    $students{$studnum} = { lastname => $lastname, 
				    firstname => $firstname, 
				    lockout => $lockout };
	}


    } else { # all students

	$sth = $dbh->prepare("select lastname, firstname, studnum, parent_lockout from student 
          order by lastname, firstname");
	$sth->execute;
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	while ( my ($lastname, $firstname, $studnum, $lockout ) = $sth->fetchrow ) { 
	    push @students, $studnum;
	    $students{$studnum} = { lastname => $lastname, 
				    firstname => $firstname, 
				    lockout => $lockout };
	}
    }

    
    # Start Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    

    # Now Display Choices
    print qq{<table cellspacing="0" cellpadding="3" border="1">\n};
    print qq{<tr><th>$lex{Student}</th><th>$lex{'Report Card'}<br>$lex{Lockout}</th>};
    print qq{<th>$lex{Gradebook}<br>$lex{Lockout}</th></tr>\n};
	
    foreach my $studnum ( @students ) {
	my @vals = split(//, $students{$studnum}{lockout} );
	my ( $rcheck, $gcheck );
	foreach my $val ( @vals ) {
	    if ( $val eq 'R' ) { $rcheck = 'checked="checked"';}
	    if ( $val eq 'G' ) { $gcheck = 'checked="checked"';}
	}

	print qq{<tr><td class="la"><b>$students{$studnum}{lastname}</b>, };
	print qq{$students{$studnum}{firstname} ($studnum)</td>\n<td class="cn">}; # for legal html
	if ( $rcheck ) { print qq{<input type="hidden" name="R:$studnum" value="0">\n}; };
	if ( $gcheck ) { print qq{<input type="hidden" name="G:$studnum" value="0">\n}; };
	print qq{<input type="checkbox" name="R:$studnum" value="1" $rcheck></td>\n};
	print qq{<td class="cn"><input type="checkbox" name="G:$studnum" value="1" $gcheck></td>\n\n};

    }

    print qq{<tr><td class="cn" colspan="3"><input type="submit" value="$lex{Save}"></td></tr>\n};


    print qq{</table></form>\n};
    print qq{</body></html>\n};

    exit;

}


#-------------
sub setLockout {
#-------------

    foreach my $key ( sort keys %arr ) { 
	if ( $arr{$key} =~ m/\0/ ) { $arr{$key} = 1; }
	# Anything showing up will not be hidden by a value in the
	# field, so this value should be deleted. A 0 means existing key was unchecked.
    }

#    foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Prepare to Update
    my $sth = $dbh->prepare("update student set parent_lockout = ? where studnum = ?"); 
    my %students;

    # put in student hash
    foreach my $key ( keys %arr ) {
	my ( $type, $studnum ) = split(':', $key);
	$students{$studnum}{$type} = $arr{$key}; # could be zero or one value
    }

    # combine and update
    foreach my $studnum ( keys %students ) {
	my %locks = %{ $students{$studnum} };
	foreach my $key ( keys %locks ) { 
	    if ( not $locks{$key} ) { delete $locks{$key}; }
	} 

	my $string = join('', sort keys %locks );
#	print qq{$studnum - $string<br>\n};

	$sth->execute( $string, $studnum );
	if ($DBI::errstr) { print $DBI::errstr; }
    }

    if ( $DBI::errstr ) {
	print qq{<h3>$lex{Error}: $DBI::errstr</h3>\n};
    } else {
	print qq{<h3>$lex{Records} $lex{Updated}</h3>\n};
    }

    print qq{<div>[ <a href="$homepage">$lex{Main}</a> | };
    print qq{<a href="$self">Set More Lockouts</a> ]</div>\n};
    
    print qq{</body></html>\n};

    exit;

} # end of setLockout;




#----------------
sub showStartPage { 
#----------------

    # Get the grades
    my @grades;
    my $sth = $dbh->prepare("select distinct grade from student 
      where grade is not NULL and grade != ''");
    $sth->execute;
    if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $gr = $sth->fetchrow ) {
	push @grades, $gr;
    }
    @grades = sort {$a <=> $b} @grades;
    

    # Get the homerooms.
    my @homerooms;
    my $sth = $dbh->prepare("select distinct homeroom from student where 
     homeroom is not NULL and homeroom != ''");
    $sth->execute;
    if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $hr = $sth->fetchrow ) {
	push @homerooms, $hr;
    }

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};
    print qq{<tr><td class="bra">Select Grade</td>};
    print qq{<td><select name="grade"><option></option>};
    foreach my $grade ( @grades ) {
	print qq{<option>$grade</option>\n};
    }
    print qq{</select></td></tr>\n};

    print qq{<tr><td class="bcn">OR</td></tr>\n};

    print qq{<tr><td class="bra">Select Homeroom</td>};
    print qq{<td><select name="homeroom"><option></option>};
    foreach my $homeroom ( @homerooms ) {
	print qq{<option>$homeroom</option>\n};
    }
    print qq{</select></td></tr>\n};

    print qq{<tr><td colspan="2" class="ra">};
    print qq{<input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table>\n};
    print qq{</form></body></html>\n};

    exit;

}
