#!/usr/bin/perl
#  Copyright 2001-2018 Leslie Richardson

#  This file is part of Open Admin for Schools.

# Get Grade and Year-Month and display attendance for each day.

my %lex = ('Teacher' => 'Teacher',
	   'Error' => 'Error',
	   'Main' => 'Main',
	   'Attendance' => 'Attendance',
	   'Report' => 'Report',
	   'Month' => 'Month',
	   'Start' => 'Start',
	   'Continue' => 'Continue',
	   'Grade' => 'Grade',
	   'Student' => 'Student',
	   'Missing' => 'Missing',
	   'Value' => 'Value',
	   'View' => 'View',
	   'Hover' => 'Hover',
	   'Starting' => 'Starting',
	   'Ending' => 'Ending',
	   'No Students Selected' => 'No Students Selected',
	   'Open' => 'Open',
	   'End' => 'End',
	   'Select by' => 'Select by',
	   'Yearly' => 'Yearly',

	   );

my $self = 'feederAttView.pl';

my $closedcolor = '#AAA';
my $partclosedcolor = '#EEE';
my $notenrolledcolor = '#DDD';

use DBI;
use CGI;
use Cwd;
use Time::JulianDay;
use Number::Format qw(:all);


# Get current dir so know what path for config files.
my $configpath;
my $teachermode;
if ( getcwd() =~ /tcgi/ ){ # we are in tcgi
    $teachermode = 1;
    $configpath = '..'; # go back one to get to etc.
} else {
    $configpath = '../..'; # go back two to get to etc.
}


# only load passwords and users
eval require "$configpath/etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

eval require "$configpath/lib/libattend.pl";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

eval require "$configpath/lib/libschedule.pl";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Load global user and password
if ( not -e "$globdir/global.conf" ) {
    print qq{Cannot read the global.conf file!\n};
    print qq{</body></html>\n};
    exit;
}

eval require "$globdir/global.conf";
if ( $@ ) {
    print qq{$lex{Error} $@<br>\n};
    die $lex{Error}. " $@<br>\n";
}

if ( $oldbase{$dbase} ) { # We are an onion lake school
    %dbase = %oldbase;
}


# Load Remote database if $arr{db} defined.
my $dbhr;
if ( $arr{db} ) { # from start page
    my $db = $arr{db};
    my $dsn = "DBI:$dbtype:database=$db;host=$remotehost";
    $dbhr = DBI->connect($dsn,$remoteuser,$remotepassword);
    
} 


# Teachermode
if ( $teachermode ) { # running on teacher site
    $css = $tchcss;
    $homepage = $tchpage;
    $downloaddir = $tchdownloaddir;
    $webdownloaddir = $tchwebdownloaddir;
}


# Set Date
my @tim = localtime(time);
my $cyear = @tim[5] + 1900;
my $cmonth = @tim[4] + 1;
my $cday = @tim[3];
my $currdate = "$cyear-$cmonth-$cday";
my $currjd = julian_day( split('-', $currdate) );
if (length $cmonth == 1 ) { $cmonth = '0'. $cmonth; }
my $curryrmo = "$cyear-$cmonth";

my $prevyrmo;
if ( $cmonth == 1 ) {
    my $prevyr = $cyear - 1;
    $prevyrmo = "$prevyr-12";
} else {
    my $prevmo = $cmonth - 1;
    if (length $prevmo == 1 ) { $prevmo = '0'. $prevmo; }
    $prevyrmo = "$cyear-$prevmo";
}


my $title = "$lex{Yearly} $lex{Student} $lex{Attendance} $lex{Report}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{<style>th.dr, td.dr { border-right-style:double; border-right-width:3px; }</style>\n};

print qq{$chartype\n</head><body style="padding:1em;">\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{ <a href="/ssp.html">SSP</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    selectSchool();

} elsif ( $arr{page} == 1) {
    delete $arr{page};
    selectGroup();

} elsif ( $arr{page} == 2) {
    delete $arr{page};
    showReport();
} 



#-------------
sub showReport {
#-------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }
    
    my $studtable = 'studentwd';
    if ( $arr{showcurrent} ) {
	$studtable = 'studentall';
	delete $arr{showcurrent};
    }

    delete $arr{db};

    my $dbh = $dbhr; # change the handle to use remote db handle
    

    # Load Configuration Variables for this feeder school from remote DB.
    my $sth = $dbh->prepare("select id, datavalue from conf_system where filename = 'admin'");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while (	my ($id, $datavalue) = $sth->fetchrow ) {
	eval $datavalue;
	if ( $@ ) {
	    print "$lex{Error}: $@<br>\n";
	    die "$lex{Error}: $@\n";
	}
    }

    
    # Get students in that grade
    my @students;
    my $sth = $dbh->prepare("select studnum from $studtable where grade = ? order by lastname, firstname");
    $sth->execute( $arr{grade} );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $studnum = $sth->fetchrow ) {
	push @students, $studnum;
    }

   
   # Check for missing month entry
    if ( not $arr{startmonth} or ( not $arr{endmonth} ) ) {
	print qq{<h3>$lex{Missing} Start/End Month $lex{Value}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }


    print qq{<div style="font-weight:bold;font-size:120%;color:red;">};
    print qq{No Teacher Attendance Entry Checking is done!</div>\n};


    
    # Create hash of year-month values
    my @yearmonth;
    my ($yr, $mo ) = split('-', $arr{startmonth});
    my ($ey, $em ) = split('-', $arr{endmonth});
    
    # increment end month so we can get last days correctly.
    if ( $em == 12 ) {
	$em = '01';
	$ey++;
    } else {
	$em ++;
    };
    if ( length $em == 1 ) { $em = '0'. $em; };
    $arr{endmonth} = "$ey-$em";
	

    my $ym = $arr{startmonth};

    while ( $ym ne $arr{endmonth} ) {
	push @yearmonth, $ym;
	$mo++;
	if ( $mo > 12 ) {
	    $mo = 1;
	    $yr++;
	}
	if ( length $mo == 1 ) { $mo = '0'. $mo; }
	$ym = qq{$yr-$mo};
    }
    push @yearmonth, $ym; # final month push

   
    
    # Hash to store last days of the month.
    my %lastdays;
    my ($currym, $prevym);

    foreach my $ym ( @yearmonth ) {
	if (not $currym ) { $currym = $ym; next; } # skip first element
	$prevym = $currym;
	$currym = $ym;

	my $startjd = julian_day( split('-',$currym),1);
	my $prevjd = $startjd - 1; # end of previous month.
	my @date =  inverse_julian_day( $prevjd );
	$lastdays{$prevym} = $date[2];
    }
    pop @yearmonth;  # remove extra month added to get last day in last month.

#   foreach my $key ( sort keys %lastdays ) { print "YM:$key V:$lastdays{$key}<br>\n"; }
    
    delete $arr{startmonth};
    delete $arr{endmonth};
    # should only be student numbers left in %arr at this point.

    # Check for Students
    if ( not @students ) {
	print qq{<h3>$lex{'No Students Selected'}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    
#    foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }
    
    
    # Load student info and create sorting hash.
    my (%student, %sort );    # $student{studnum}{all fields} = value;
    my $sth = $dbh->prepare("select * from studentall where studnum = ?");
    foreach my $studnum ( @students ) {
	$sth->execute($studnum);
	if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	while ( my $ref = $sth->fetchrow_hashref ) {
	    $student{$studnum} = $ref;
	    $sort{"$ref->{lastname}$ref->{firstname}$studnum"} = $studnum;
	}
    }

    
    # Get days closed for the year or year fraction.
    my %daysclosed; # daysclosed{ym}{day} = fraction
    my %daysclosedcount; # daysclosedcount{ym} = total

    
    # Populate DaysOpen and DaysClosed hashes
    my $sth = $dbh->prepare("select date, dayfraction from dates where 
        month(date) = ? and year(date) = ?"); 
    foreach my $ym ( @yearmonth ) {
	
	my ($yr,$mo) = split '-', $ym;
	$sth->execute($mo, $yr);
	if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	
	my $closed; # sum of days closed fraction
	
	while ( my ($dt, $fraction ) = $sth->fetchrow ) {
	    my ($y,$m,$d) = split('-',$dt);
	    $d =~ s/^0//; # strip leading zeros.
	    $daysclosed{$ym}{$d} = $fraction;
	    $closed += $fraction;
	}
	$daysclosedcount{$ym} = $closed;
	
    }


# Testing Section.

#    foreach my $ym ( sort keys %daysclosed ) {
#	print "<br>YM:$ym $daysopen{$ym}<br>\n";
#	foreach my $day ( sort {$a <=> $b} keys %{ $daysclosed{$ym} } ) {
#	    print "K:$day V:$daysclosed{$ym}{$day}<br>\n"; 
#	}
#    }



=head  # Outline for teacher attendance checking.    

The teacher information in tattend has:
userid - teacher userid
attdate - date of attendance entry
subjects - (singular) subject subjsec OR homeroom in format HR:5/6
periods - again, now singular, the period that it was done for....


In order to check if a particular student's attendance was done, we have to:
a) Homeroom

Get students grade and homeroom and get attendance entry method.

If homeroom method, then get the teacher associated with this homeroom (only 1, check 'does attendance, too?). 
Then use this userid to check records with value: this userid, this subjects field (HR:homeroom),
Use tAttendHomeroom{ym}{day}{period} {userid}

This will give the attdate, and periods that attendance was done.

b) Subject (really Course)
With a subject entry method for a grade, we need the student timetable, 
and then find the matching teacher attendance table.
1) Get Day in Cycle, find courses student took.
2) Check if teacher attendance was done for that attdate, for that period, for that subjsec (subjects field).  
We don't care about userid, since student linkage is via subjsec not homeroom assignment.

create tAttendCourse{ym}{day}{period} {subjsec}

Checking for a particular date, period, we first need the day in cycle in order to get 
the timetable values for the student, which gives: Period->subjsec. Looping over the periods, 
we get the subjsec (course identifier),  we then check for this entry in tAttendCourse.

=cut



    # Teacher Attendance
    my (%tAttendHomeroom, %tAttendCourse);   
    # tAttendHomeroom{ym}{day}{period} {userid}    tAttendCourse{ym}{day}{period} {subjsec}

    
    my $sth = $dbh->prepare("select * from tattend where year(attdate) = ? and month(attdate) = ?"); 

    foreach my $ym ( @yearmonth ) {
	my ($yr,$mo) = split '-', $ym;
	$sth->execute($yr, $mo);
	if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	while ( my $ref = $sth->fetchrow_hashref ) {
	    
	    my %r = %$ref;
	    
	    my ($y,$m,$day) = split('-', $r{attdate});
	    $day =~ s/^0//; # strip leading zero

	    if ( $r{subjects} =~ m/HR:.+/ ) {  # or not $r{subjects} ) { # if a homeroom
		my $hr = $r{subjects};
		$hr =~ s/HR://; 
		$tAttendHomeroom{$ym}{$day}{ $r{periods} }{ $hr } = 1; # students linked by homeroom; # was userid
	    
	    } elsif ( $r{subjects} ) {
		$tAttendCourse{$ym}{$day}{ $r{periods} }{ $r{subjects} } = 1; # students linked by course.
		
	    } else { # blank 'subjects' field
		print qq{<div><b>Missing Teacher Attendance Subject/Homeroom field</b>};
		print qq{ Date:$r{attdate} Userid:$r{userid} Period:$r{periods}</div>\n};
	    } 
		
	} # get dates loop
    } # ym loop
          

#    use Data::Dumper;
#    print "Homeroom<br><pre>\n";
#    print Dumper %tAttendHomeroom;
#    print "</pre><br>\n";


#    print "Course<br><pre>\n";
#    print Dumper %tAttendCourse;
#    print "</pre><br>\n";


    
# For Subject based attendance, create a termjd{track}{start:end} = term to look up term of current date;
# MTrackTerm{$track}{$term}{ start => startdate, end => $enddate }
    
    my %termjd;
    foreach my $track ( keys %g_MTrackTerm ) {
	foreach my $term ( keys %{ $g_MTrackTerm{$track}} ) {
	    my $sdate = $g_MTrackTerm{$track}{$term}{start};
	    my $edate = $g_MTrackTerm{$track}{$term}{end};
	    my $sdatejd = julian_day( split('-',$sdate));
	    my $edatejd = julian_day( split('-',$edate));
	    $termjd{$track}{"$sdatejd:$edatejd"} = $term;
	}
    }

#    use Data::Dumper;
#    print "termjd<br><pre>\n";
#    print Dumper %termjd;
#    print "</pre><br>\n";



    # Global Timetable - load this and then each student will use a subset for their courses.
    my %ttb; # ttb{term}{subjsec}{dayincycle}{period}
    my $sth = $dbh->prepare("select * from schedat");
    $sth->execute;
    if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchall_hashref('id');
    foreach my $key ( sort keys %{ $ref } ) {
	foreach my $hkey ( sort keys %{ $ref->{$key}} ) {
	    my %r = %{ $ref->{$key} };
	    $ttb{ $r{term} }{ $r{subjsec} }{ $r{day} }{ $r{period} } = 1;
	}
    }
    
#    use Data::Dumper;
#    print "Timetable (%ttb)<br><pre>\n";
#    print Dumper %ttb;
#    print "</pre><br>\n";

    
    my $schoolstartjd = julian_day(split('-', $schoolstart));

    
    # get homerooms of teachers (in order to link to children by homeroom for tattend.
    my (%homeroom, %teachername); # %homeroom{homeroom} = $userid; # OLD:%homeroom{homeroom}{userid} = 1
    
    my $sth1 = $dbh->prepare("select lastname, firstname from staff where userid = ?");

    my $sth = $dbh->prepare("select userid, field_value from staff_multi where field_name = 'homeroom'");
    $sth->execute;
    if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while ( my ($userid, $rm ) = $sth->fetchrow ) {

	$sth1->execute($userid);
	if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my ($lastname, $firstname) = $sth1->fetchrow;

	
	# $homeroom{$rm}{$userid} = 1; # in case of more than one teacher in same homeroom...?
	$teachername{$userid} = "$firstname $lastname";
	$homeroom{$rm} = $userid; # only one teacher doing attendance. Too ugly otherwise
    }

    
    
    # Main Student Loop
    foreach my $key ( sort keys %sort ) { 

	my $studnum = $sort{$key};
	my %r = %{ $student{$studnum}}; # student record.
	my $teacher = $homeroom{ $r{homeroom}};
	my $homeroom = $r{homeroom};

	my ( @courses, %localttb ); # for this student;
	my ( $totaldaysopen, $totaldaysenrolled, $totaldaysabsent ); # total for statistics line.
    
        # Set Attendance Entry Method
	my $attmethod = $g_AttendanceEntryMethod{ $r{grade} };
	# Track
	my $track = $g_MTrackTermType{ $r{grade} };
	# PPD (Periods per Day attendance is taken
	my $ppd = $g_ppd{ $r{grade} };

	if ( not $ppd ) {
	    print qq{<div>Missing PPD for student:$studnum $r{lastname}, $r{firstname} Grade:$r{grade}<br>\n};
	    print qq{Using a PPD (Periods per Day for Attendance) of 2</div>\n};
	    $ppd = 2;
	}
	
#	print "Method: $attmethod Track:$track Grade:$r{grade}<br>\n";

	
	# get their enrollment for the year, and populate status, otherwise skip
	my @enrolblocks = findEnrollmentBlocks($studnum, $schoolstart, $schoolend, $dbh);
	if ( not $enrolblocks[0] ) { next; } # skip this student if no enrollment.
	

	# Heading
	print qq{<h3>$r{firstname} $r{lastname} ($studnum) };
	if ( $attmethod eq 'homeroom' and $teachername{$teacher} ) { # show homeroom teacher
	    print qq{ - Teacher $teachername{$teacher}};
	}
	print qq{</h3>\n};


	
	# populate status keys (ym values)
	my %enrol;
	foreach my $ym ( @yearmonth ) {  # enter all months, keys only, so far.
	    $enrol{$ym};
	}

	# Put in the trigger points (enrollment status change).
	foreach my $blockref ( @enrolblocks ) {
	    my ($sy,$sm,$sd) = split('-', $blockref->{start} );
	    $sd =~ s/^0//;
	    $enrol{"$sy-$sm"}{$sd} = 'e';
    
	    my ($ey,$em,$ed) = split('-', $blockref->{end} );
	    $ed =~ s/^0//;
	    $enrol{"$ey-$em"}{$ed} = 'w';
	}

	# Update the first day of each month with the enrollment status
	my $estatus;
	foreach my $ym ( @yearmonth ) {
	    my $first = 1;
	    foreach my $day (1..31) {
		
		# Logic to populate the first day of the month with an
		# estatus value, if no value already on the first.
		# This is the first value in the month;
		if ( $enrol{$ym}{$day} and $first ) { # if we have a trigger value.
		    if ( $day != 1 ) { # if this is not on the first, then put in the day 1 value
			# if an 'e'(enrol), then must have been withdrawn to that point
			if ($enrol{$ym}{$day} eq 'e' ) { 
			    $enrol{$ym}{1} = 'w';
			    $estatus = 'e';
			} else {
			    $enrol{$ym}{1} = 'e';
			    $estatus = 'w'
			}
		    }
		    $first = 0;
		}

		# The normal situation: if an enrollment, estatus is 'e'; if a withdraw, estatus is 'w'.
		if ( $enrol{$ym}{$day} ) {
		    $estatus = $enrol{$ym}{$day};
		}

	    } # end of days;

	    if ( $first ) { # no enrollment change;
		$enrol{$ym}{1} = $estatus;
	    }
	} # end of ym update loop

=head
	# Test the %enrol hash
	foreach my $ym ( sort keys %enrol ) {
	    foreach my $day ( sort keys %{ $enrol{$ym} } ) {
		print qq{YM:$ym Day:$day VAL:$enrol{$ym}{$day}<br>\n};
	    }
	}
=cut

	# Start the Main Table
	print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
	print qq{<caption style="font-weight:bold;font-size:120%;text-align:left;">};
	print qq{$lex{Hover} = $lex{View}, C = Closed, X = Weekend/Not Started, };
	print qq{NE = No Teacher Attendance Entry</caption>\n};

	
	# Heading;
	print qq{<tr><th>$lex{Month}</th>};
	foreach my $day (1..31) {
	    print qq{<th class="cn">$day</th>};
	    if ( $day % 6 == 0 ) { print qq{\n}; }
	}
	print qq{<th title="Days Open">$lex{Open}</th>};
	print qq{<th title="Days Attended / Days Enrolled = %Attendance">$lex{Attendance}</th></tr>\n};

	my $sth = $dbh->prepare("select * from attend where absdate = ? and studentid = ?");

	my ($currterm, $prevterm);
	
	# Loop through each month.
	foreach my $ym ( @yearmonth ) {

	    my ($y,$m) = split('-', $ym);
	    print qq{<tr><td>$month[$m], $y</td>};

	    my $lastday = $lastdays{$ym};

	    # IF subject attendance, create a hash for day in cycle for this month.
	    my %dayincycle;
	    if ( $attmethod eq 'subject' ) {
		for my $d ( 1..$lastday ) {
		    my $dic = findDayInCycle( "$ym-$d", $dbh );
		    #print "Day of Month:$d  Cycle Day:$dic<br>\n";
		    $dayincycle{$d} = $dic;
		}
	    }

	    my $daysabsent; # total count of days absent for the month.
	    my $daysenrolled; # total count of days enrolled for the month.
	    my $daysopen; # days school is open for the month
	    
	    my $estatus = $enrol{$ym}{1}; # daily value for enrollment status
	    my $tAttendMonthlyFlag;

	    
	    # Day Loop
	    foreach my $day ( 1..31 ) {

		my $tAttendFlag; # flag to indicate if teacher has missed attendance today
		my $tAttendMsg = "$lex{Missing} $lex{Teacher} $lex{Attendance}:";

		if ( $day > $lastday ) {
		    print qq{<td></td>\n};
		    next;
		}

		my $date = qq{$ym-$day};
		my $currjd = julian_day(split('-', $date));
		my $dow = day_of_week( $currjd );


		# Weekend or School Not Started Yet
		if ( $dow == 0 or $dow == 6 or $currjd < $schoolstartjd ) {
		    print qq{<td class="cn" style="font-size:150%;">X</td>\n};
		    next;
		}

	
		# Get Current Term, for subject attendance checking.
		my $term;
		if ( $attmethod eq 'subject' ) {
		    foreach my $key ( keys %{ $termjd{$track}} ) {
			my ($startjd, $endjd ) = split(':', $key);
			if ( $currjd >= $startjd and $currjd <= $endjd ) {
			    $term = $termjd{$track}{$key};
			    last;
			}
		    }

#		    if ( not $term ) { 
#			print qq{<h3>$lex{Error}: Term not found for $date</h3>\n};
#		    }
		}

		if ( $term ) {
		    $prevterm = $currterm;
		    $currterm = $term;
		}
#		print "Date:$date CT:$currterm PV:$prevterm<br>\n";		

		
		# Updated Enrollment status
		if ( $enrol{$ym}{$day} ) { # we have an enrollment change trigger
		    $estatus = $enrol{$ym}{$day};
		}
		

		# Fully Closed / Partially Closed PLUS Update Days enrolled (partial or complete)
		my $openfrac;  # fraction of the day open, to check below on attendance
		if ( $daysclosed{$ym}{$day} >0.99 ) { # full day closed
		    print qq{<td title="School Closed" class="bcn">C</td>\n};
		    next;
		} elsif ( $daysclosed{$ym}{$day} > 0.01 ) { # partially closed
		    $openfrac = round( 1 - $daysclosed{$ym}{$day}, 2);
		    $daysopen += $openfrac;
		    if ( $estatus eq 'e' ) { # enrolled!
			$daysenrolled += $openfrac;
		    }
		    # Note: no next here since we are going to print attendance for the partial day open.
		} else {  # full day open/enrolled
		    $daysopen++;
		    if ( $estatus eq 'e' ) { # enrolled!
			$daysenrolled++;
		    }
		}


		if ( $estatus ne 'e' ) { # not enrolled!
		    print qq{<td style="background-color:$notenrolledcolor;"></td>\n};
		    next;
		}

=head		
		# Check for teacher attendance entry
		if ( not $openfrac ) { # we don't want to mess with partial days open, 
		    # since we don't know which periods are 'off'
		    if ( $attmethod eq 'homeroom' ) {
			my $aflag;
			foreach my $period ( 1..$ppd ) {
			    if ( not $tAttendHomeroom{$ym}{$day}{$period}{$homeroom} ) {
				print "Missing Attendance:$ym - $day - $period - $teacher<br>\n";
				$tAttendFlag = 1;
				$tAttendMonthlyFlag = 1;
				$aflag = 1;
			    }
			}

			if ( $aflag ) { 
			    print qq{<td>NE</td>\n};
			    next;
			}

		    
		    } else { # subject attendance
			
			if ( $currterm != $prevterm and $prevterm ) {  # we have a term change....
			
			    # Get Courses Student is enrolled in for this term.
			    my $sth = $dbh->prepare("select subjcode from eval where studnum = ? and term = ?");
			    $sth->execute( $studnum, $term );
			    if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

			    @courses = ();
			    %localttb = ();
			
			    while ( my $subjsec = $sth->fetchrow ) {
				push @courses, $subjsec;

				if ( $ttb{$term}{$subjsec} ) { # we have a timetable entry for this subject
				    foreach my $day ( keys %{ $ttb{$term}{$subjsec} } ) {
					foreach my $period ( keys %{ $ttb{$term}{$subjsec}{$day} } ) {
					    $localttb{$subjsec}{$day}{$period} = 1;
					}
				    }
				}
			    }

			    if ( not @courses or not %localttb ) { $tAttendFlag = 1; }
			}


			my $dayincycle = $dayincycle{$day};
			# print "Date:$date  Day:$day DIC:$dayincycle<br>\n";

			my $sth = $dbh->prepare("select id from tattend 
                          where attdate = ? and subjects = ? and periods = ?");
		    
			# Get todays courses and their periods. (may be more than 1 or same...)
			my $firstatt = 1;
			foreach my $subjsec ( @courses ) {
			    if ( $localttb{$subjsec}{$dayincycle} ) {
				foreach my $period ( sort keys %{ $localttb{$subjsec}{$dayincycle} } ) {
				    $sth->execute( $date, $subjsec, $period );
				    if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
				    my $id = $sth->fetchrow;
				    if ( not $id ) { # no entry
					$tAttendFlag = 1;
					$tAttendMonthlyFlag = 1;
					$tAttendMsg .= " $subjsec P$period,";
				    }
				}
			    } # end of timetable entry exists loop for this subject today
			} # end of courses loop
		    
		    } # end of subject attendance teacher entry check
		} # end of fractional day open conditional.


		if ( $tAttendFlag ) {
		    print qq{<td title="$tAttendMsg">NE</td>\n};
		    next; # day
		}
=cut
		
		# Get Attendance for today
		$sth->execute( $date, $studnum );
		if ( DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
		my $abscount;
		while ( my $ref = $sth->fetchrow_hashref ) {
		    if ( $ref->{reason} =~ m/Absent/ ) {
			$abscount++;
		    }
		}
		
		my $absent = round($abscount / $ppd, 2);
		$daysabsent += $absent;

		if ( $openfrac and $absent > $openfrac ) {
		    $absent = $openfrac;  # because we can't be more absent than school is open!
		}
		
		my $display;
		if ( $absent < 0.01 ) { 
		    $display = 'P';
		} elsif ( $absent > 0.99 ) {
		    $display = 'A';
		} else {
		    $display = $absent. 'A';
		}

		my $partdaystyle;
		if ( $openfrac ) {
		    $partdaystyle = qq{style="background-color:$partclosedcolor;"};
		}
		print qq{<td class="cn" $partdaystyle >$display</td>\n};

	    }

	    if ( $override{$ym} ) {
		$daysopen = $override{$ym};
		if ( $daysenrolled > $daysopen ) {
		    $daysenrolled = $override{$ym};
		}
	    }
	    
	    print qq{\n<td class="cn">$daysopen</td>\n};

	    if ( $tAttendMonthlyFlag ) { # no stats shown, since missing attendance entry at some point.
		print qq{<td>$lex{Error}</td></tr>\n};
		next;
	    }
	    
	    my ($percentattend, $dayspresent, $ratio);
	    if ( $daysenrolled ) {
		$dayspresent = $daysenrolled - $daysabsent;
		$ratio = $dayspresent .' / '. $daysenrolled;
		$percentattend = '('. round( $dayspresent * 100 / $daysenrolled, 1). '%)';

		$totaldaysenrolled += $daysenrolled;
	
	    }
	    
	    $totaldaysopen += $daysopen;
	    $totaldaysabsent += $daysabsent;
	    
	    print qq{<td>$ratio $percentattend</td>};
	    print qq{</tr>\n};
	    
	} # year month loop

	# Statistics Line
	my $totaldayspresent = $totaldaysenrolled - $totaldaysabsent;
	
	my $totalpercentattend;
	if ( $totaldaysenrolled ) {
	    $totalpercentattend = round( $totaldayspresent * 100 / $totaldaysenrolled, 1);
	}

	print qq{<tr><th>Statistics</th><th colspan="10">Percent Attendance: $totalpercentattend%</th>\n};
	print qq{<th colspan="14">Days Present / Absent / Enrolled: $totaldayspresent / $totaldaysabsent };
	print qq{/ $totaldaysenrolled</th>\n};;
	print qq{<th colspan="7">Days Open: $totaldaysopen</th>\n};
	print qq{</tr>\n};
	
	print qq{</table><p></p>\n\n};


	# Enrollment Table.
	print qq{<table cellpadding="3" cellspacing="0" border="1" style="margin-bottom:1.5em;">\n};
	print qq{<caption>Enrollment</caption>\n};
	print qq{<tr><th>$lex{Start}</th><th>$lex{End}</th></tr>\n};
	foreach my $ref ( @enrolblocks ) {
	    print qq{<tr><td>$ref->{start}</td><td>$ref->{end}</td></tr>\n};
	}
	print qq{</table><hr>\n};
	# foreach my $key ( sort keys %{ $ref } ) { print "K:$key V:$ref->{$key}<br>\n";  }

	# Page Break
	print qq{<div style="page-break-after:always;"></div>\n};
	

    } # student loop


    print qq{</body></html>\n};

    exit;

} # end of showReport




#----------------
sub selectSchool { 
#----------------

    if ( not @g_FeederSchools ) {
	print qq{<h3>No Feeder Schools Found</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    
    # Get remote databases
    my $remotedbase = 'information_schema';
    my $dsnr = "DBI:$dbtype:database=$remotedbase;host=$remotehost";
    my $dbhr = DBI->connect($dsnr,$remoteuser,$remotepassword);


    my $sth = $dbhr->prepare("select distinct table_schema from TABLES order by table_schema");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my %remotedb;


    # add all feeder school previous years to the remotedb hash.
    while ( my $db = $sth->fetchrow ) {
	if ( $db eq 'mysql' or $db eq 'information_schema' ) { next; }

	
	foreach my $dbase ( @g_FeederSchools ) {
	    # print qq{DB:$db<br>\n};
	    if ( $db =~ m/$dbase/ ) {
		# print "Match! $dbase - $db<br>\n";
		$remotedb{$db} = 1;
	    }
	}
    }


    print qq{<h3>Select Feeder School and Year</h3>\n};

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="0" };
    print qq{style="padding:0.5em;border:1px solid gray;">\n};
    print qq{<caption><b>Note</b> 2016 = 2015-2016 School Year</caption>\n};

    
    foreach my $db ( sort keys %remotedb ) { 
	print qq{<tr><td class="la"><input type="radio" name="db" value="$db"> $db</td></tr>\n};
    }


    print qq{</table><p><input type="submit" value="Continue"></p>\n};
    print qq{</form>\n};
    
    print qq{</body></html>\n};
    
    exit;

}

    

#---------------
sub selectGroup {
#---------------
    
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # passed db to view.

#    my $dsn = "DBI:$dbtype:dbname=$arr{db}";
#    my $dbh = DBI->connect($dsn,$guser,$gpassword);
    
    my (@grades, @schoolyears );


    # Load Configuration Variables for this school year in order to get dates.
    my $sth = $dbhr->prepare("select id, datavalue from conf_system where filename = 'admin'");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while (	my ($id, $datavalue) = $sth->fetchrow ) {
	eval $datavalue;
	if ( $@ ) {
	    print "$lex{Error}: $@<br>\n";
	    die "$lex{Error}: $@\n";
	}
    }

    print qq{<h3>Feeder School - $arr{db}</h3>\n};

    
    # Get Grades
    $sth = $dbhr->prepare("select distinct grade from studentall 
      where grade is not NULL and grade != ''");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $gr = $sth->fetchrow ) {
	push @grades, $gr;
    }
    @grades = sort {$a <=> $b} @grades;


    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="hidden" name="db" value="$arr{db}">\n};
    
    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};


    # Select Grade
    print qq{<tr><td class="bra">$lex{'Select by'} $lex{Grade}</td>};
    print qq{<td><select name="grade"><option></option>\n};
    foreach my $gr ( @grades ) {
	print qq{<option>$gr</option>\n};
    }
    print qq{</select></td></tr>\n};


    # Starting and Ending Months.
    my ($sy, $sm, $sd) = split('-', $schoolstart); # schoolstart is global var from config.
    if ( length( $sm ) == 1 ) { $sm = '0'. $sm; }
    my $yrmo = "$sy-$sm";
    push @months, $yrmo;
    $months{$yrmo} = "$s_month[$sm]-$sy";

    for my $i (1..10) {
	my $mo = $sm + $i;
	if ( length( $mo ) == 1 ) { $mo = '0'. $mo; }
	my $yr = $sy;
	if ( $mo > 12 ) {
	    $mo = $mo - 12;
	    if ( length( $mo ) == 1 ) { $mo = '0'. $mo; }
	    $yr++;
	}
	my $yrmo = "$yr-$mo";
	push @months, $yrmo;
	$months{$yrmo} = "$s_month[$mo]-$yr";
    }


    # Starting Month
    print qq{<tr><td class="bra">$lex{Starting} $lex{Month}</td>};
    print qq{<td class="la"><select name="startmonth"><option value="$months[0]">$months{$months[0]}</option>\n}; 

    foreach my $mo ( @months ) {
	print qq{<option value="$mo">$months{$mo}</option>\n};
    }
    print qq{</select></td></tr>\n};


    # Ending Month
    print qq{<tr><td class="bra">$lex{Ending} $lex{Month}</td>};
    print qq{<td class="la"><select name="endmonth"><option></option>\n};

    foreach my $mo ( @months ) {
	print qq{<option value="$mo">$months{$mo}</option>\n};
    }
    print qq{</select></td></tr>\n};

    
    # Show Current Students
    print qq{<tr><td class="bra">Show Current Students</td>};
    print qq{<td><input type="checkbox" name="showcurrent" value="1"></td></tr>\n};


    # Continue
    print qq{<tr><td class="ra"><input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table>\n};
    print qq{</form></body></html>\n};

    exit;

}

