#!/usr/bin/perl
#  Copyright 2001-2025 Leslie Richardson

#  This file is part of Open Admin for Schools.

# View Land Based Education Records


my %lex = ('Main' => 'Main',
	   'Error' => 'Error',
	   'Continue' => 'Continue',
	   'Start Date' => 'Start Date',
	   'End Date' => 'End Date',

	   );

use DBI;
use CGI;
use Cwd;

my $self = 'landView.pl';

my $editScript = './landEdit.pl';

eval require "../../etc/admin.conf";
if ( $@ ) {
    print "$lex{Error}: $self: $@<br>\n";
    die "$lex{Error}: $self: $@\n";
}


# Get current dir so know what CSS to display and shift settings.
if ( getcwd() !~ /tcgi/ ) { # we are in cgi, not teacher tcgi
    $tchcss = $css;
    $tchpage = $homepage;
    $tchdownloaddir = $downloaddir;
    $tchwebdownloaddir = $webdownloaddir;
}


my $q = new CGI;
print $q->header( -charset, $charset);
my %arr = $q->Vars;

my $userid = $ENV{'REMOTE_USER'};
$userid = 'Fred';

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Page Header
my $title = qq{View Land Based Education Records};
print qq{$doctype\n<html><head><title>$title</title>\n}; 
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};

if ( not $arr{page} ) { # calendar popup.
    print qq{<link rel="stylesheet" type="text/css" media="all" };
    print qq{href="/js/calendar-blue.css" title="blue">\n};
    print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};
}


print qq{$chartype\n</head><body style="padding:1em 2em;">\n};

print qq{[ <a href="$tchpage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showLBEvents();
}


#----------
sub fmtDate {
#----------

    my ( $year, $mon, $day ) = split /-/, shift;
    return "$year-$s_month[$mon]-$day";
}



#----------------
sub showStartPage {
#----------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    # Setup Year-Months.
    my @months;
    my %months;

    my ($sy, $sm, $sd) = split('-', $schoolstart); # schoolstart is global var from config.
    my $yrmo = "$sy-$sm";
    push @months, $yrmo;
    $months{$yrmo} = "$s_month[$sm]-$sy";

    for my $i (1..10) {
	my $mo = $sm + $i;
	my $yr = $sy;
	if ( $mo > 12 ) {
	    $mo = $mo - 12;
	    $yr++;
	}
	my $yrmo = "$yr-$mo";
	push @months, $yrmo;
	$months{$yrmo} = "$s_month[$mo]-$yr";
    }


    print qq{<table cellspacing="0" border="0" cellpadding="3">\n};
    print qq{<tr><th>Select Month</th><th># Recs</th></tr>\n};

    my $sth = $dbh->prepare("select count(*) from landedu where year(date) = ? and month(date) = ? ");
    
    # month is passed as 2025-03 format
    foreach my $mo ( @months ) { # mo is yyyy-mm
	
	# Count Records for each month
	my ($y,$m) = split('-', $mo);
	$sth->execute($y,$m);
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $count = $sth->fetchrow;
	
	print qq{<tr><td>\n};
	print qq{<form action="$self" method="post">\n};
	print qq{<input type="hidden" name="page" value="1">\n};
	print qq{<input type="hidden" name="month" value="$mo">\n};
	print qq{<input type="submit" value="$months{$mo}"></form>\n};
	print qq{</td><td>$count</td></tr>\n};
    }

    print qq{</table>\n};
    print qq{</body></html>\n};

    exit;

}


#---------------
sub showLBEvents {
#---------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # just passed year-month
   
    my $sth = $dbh->prepare("select * from landedu where year(date) = ? and month(date) = ? ");
    my ($y,$m) = split('-', $arr{month} );
    $sth->execute($y,$m);
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    my $mview = $month[$m];

    
    my $first = 1;
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;

	if ( $first ) { # start the table.
		print qq{<table cellpadding="3" cellspacing="0" border="1" style="margin:0.5em;">\n};
		print qq{<caption style="font-weight:bold;font-size:120%;">$mview, $y Records</caption>\n};

		print qq{<tr><th>Date</th><th>Hours</th><th>Grades</th><th>Author</th>};
		print qq{<th>Description</th><th></th></tr>\n};
		$first = 0;
	}

	print qq{<tr><td>$r{date}</td><td>$r{hours}</td><td>$r{grades}</td><td>$r{author}</td>};
	print qq{<td style="width:40ch;">$r{description}</td>\n};

	# Edit
	print qq{<td><form action="$editScript" method="post" target="_blank">\n};
	print qq{<input type="hidden" name="id" value="$r{id}">\n};
	print qq{<input type="submit" value="Edit / Delete"></form></td>\n};

	print qq{</tr>\n};

    }
    
    if ( not $first ) {
	print qq{</table>\n};
    } else {
	print qq{<h3>No Records Found</h3>\n};
    }


    print qq{<p>[ <a href="$self">View Other Months</a> ]\n};
    print qq{</body></html>\n};

    exit;

} # end of showAccident
