#! /usr/bin/perl
#  Copyright 2001-2025 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Continue' => 'Continue',
	   'Homeroom' => 'Homeroom',
	   'Grade' => 'Grade',
	   'Select by' => 'Select by',
	   'Error' => 'Error',
	   'Sort by' => 'Sort by',
	   'Name' => 'Name',

	   'Common Math Assessment' => 'Common Math Assessment',
	   'Report' => 'Report',
	   'OR' => 'OR',
	   'No Selection' => 'No Selection',
	   'School Year' => 'School Year',
	   'Schools' => 'Schools',
	   'Select' => 'Select',
	   'Start Date' => 'Start Date',
	   'End Date' => 'End Date',


	   );

my $self = 'cmaRpt6.pl'; # same as central report 3.
my $passmark = 3;  # need 3 or greater to have a pass.


use DBI;
use CGI;
use Cwd;
use Number::Format qw(:all);

my  $configpath = '../../..';
if ( getcwd() =~ /tcgi/ ){ # we are in tcgi
    $configpath = '../..';
}

eval require "$configpath/etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $iddst) = localtime(time);
$year = $year + 1900;
$wday++; $mon++;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get current dir so know what CSS to display;
if ( getcwd() =~ /tcgi/ ){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}


my $title = "$lex{'Common Math Assessment'} &mdash; $lex{Report} 6";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};


print qq{$chartype\n</head><body style="padding:1em 5em;">\n};
print qq{<div>[ <a href="$homepage">$lex{Main}</a> ]</div>\n};

print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showReport();
}


#-------------
sub showReport {
#-------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $schoolyear = $arr{schoolyear};
    delete $arr{schoolyear};

    my $prepost = $arr{prepost};
    delete $arr{prepost};


    my $sth1 = $dbh->prepare("select lastname, firstname, sex from studentall where studnum = ?");

    my $first = 1;
    my %score;

    my $sth = $dbh->prepare("select * from mathca_scores where prepost = ? and schoolyear = ?");
    $sth->execute( $prepost, $schoolyear );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $ref = $sth->fetchrow_hashref ) {

	my %r = %$ref;

	$first = 0;

	$sth1->execute( $r{studnum} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	my ($ln, $fn, $gender ) = $sth1->fetchrow;

	my $pass;
	if ( $r{score} >= $passmark ) { 
	    $score{$r{tgrade} }{'pass'}++;
	} else {
	    $score{$r{tgrade}}{'fail'}++;
	}

    }

    if ( $first ) { # no records from this school
	print qq{<h3>No records Found</h3>\n};
	print qq{</body></html>\n};
	exit;
    }



    print qq{<div style="font-size:120%;font-weight:bold;padding:0.4em;">$alldbase{$dbase}<br>};
    print qq{School Year $schoolyear - Type $prepost</div>\n};

    print qq{<table cellspacing="0" cellpadding="3" border="1">\n};
    print qq{<tr><th>Grade</th><th>Total</th><th>Pass<br>Number</th><th>Pass<br>Percent</th></tr>\n};

    my ( $totalcount, $passcount );

    foreach my $grade ( sort {$a <=> $b} keys %score ) {
	my $total = $score{$grade}{'pass'} + $score{$grade}{'fail'};
	$totalcount += $total;

	my $percent = 0;
	if ( $total ) {
	    $percent = format_number( $score{$grade}{'pass'} / $total * 100, 2) ;
	}
	$percent .= '%';
	my $passnumber = $score{$grade}{'pass'};
	$passcount += $passnumber;

	if (not $passnumber ) { $passnumber = '0'; }
	print qq{<tr><td>$grade</td><td>$total</td>};
	print qq{<td>$passnumber</td><td>$percent</td></tr>\n};

    }


    # Total Row
    my $totalpercent;
    if ( $totalcount ) {
	$totalpercent = format_number( $passcount / $totalcount * 100, 2) ;
	$totalpercent .= '%';
    }
    print qq{<tr style="background-color:#CCC;font-weight:bold;"><td>Total</td><td>$totalcount</td>};
    print qq{<td>$passcount</td><td>$totalpercent</td></tr>\n};


    print qq{</table>\n};

    print qq{</body></html>\n};

    exit;


} # end of showReport




#----------------
sub showStartPage { # Entry Values for Custom Script
#----------------

    my @schoolyears;
    # Get School Years
    $sth = $dbh->prepare("select distinct schoolyear from mathca_scores");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $yr = $sth->fetchrow ) {
	push @schoolyears, $yr;
    }
    @schoolyears = reverse sort @schoolyears;


    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};


    # School Year
    print qq{<tr><td class="bra">$lex{'School Year'}</td>};
    print qq{<td><select name="schoolyear">\n};
    foreach my $yr ( @schoolyears ) {
	print qq{<option>$yr</option>\n};
    }
    print qq{</select></td></tr>\n};

    # Pre/Post Test
    print qq{<tr><td class="bra">Test Type</td><td class="la">};
    print qq{<select name="prepost"><option value="pretest">Pretest</option>\n};
    print qq{<option value="posttest">Posttest</option></select></td></tr>\n};

    # Continue
    print qq{<tr><td class="ra"><input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table>\n};
    print qq{</form></body></html>\n};

    exit;

}
