#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Birthday' => 'Birthday',
	   'Report' => 'Report',
	   'Main' => 'Main',
	   'Month' => 'Month',
	   'Day' => 'Day',
	   'Name' => 'Name',
	   'Birthdate' => 'Birthdate',
	   'Error' => 'Error',
	   'School' => 'School',
	   'Continue' => 'Continue',
	   'No Records Found' => 'No Records Found',
	   'Age' => 'Age',
	   'Staff' => 'Staff',

	   );

my $self = 'rptstaffbirthday.pl';

use DBI;
use CGI;
use Cwd;

my %milestones = (29 => 1, 39 => 1, 49 => 1, 59 => 1, 69 => 1);

# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
my %arr = $q->Vars;
print $q->header( -charset, $charset );

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, 
 $iddst) = localtime(time);
$year += 1900;
$mon++;
$wday++;
my $currldate = "$dow[$wday], $month[$mon] $mday, $year";
my $currdate = qq{$year-$mon-$mday};

# Get current dir so know what CSS to display;
if ( getcwd() =~ /tcgi/ ){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}

# print table head
my $title = qq{$lex{Staff} $lex{Birthday} $lex{Report}};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body><a name="top"></a>\n};
print qq{[ <a href="$homepage">$lex{Main}</a> | <a href="$eoypage">EOY</a> ]\n};
print qq{<h1>$title</h1>\n};
print qq{<h3>$currldate</h3>\n};


if ( not $arr{page} ) {
    showStartPage();
    
} else {
    delete $arr{page};
}
 

my $sth = $dbh->prepare("select lastname, firstname, birthdate, userid from staff");
$sth->execute;
if ( $DBI::errstr ) {print $DBI::errstr; die $DBI::errstr; }

my %missing;
my %records;
while ( my ( $lastname, $firstname, $birthdate, $userid ) = $sth->fetchrow ) {
    if ( not $birthdate or $birthdate eq '0000-00-00' ) { 
	$missing{"$lastname$firstname"} = qq{$lastname:$firstname};
	next;
    }
    my ($yr,$mon,$day) = split '-', $birthdate;
    $records{"$mon$day$userid"} = "$lastname:$firstname:$birthdate:$userid";
}
    
my $first = 1;
foreach my $key ( sort keys %records ) {
    my ($lastname, $firstname, $birthdate, $userid) = split(':', $records{$key});
    
    if ( $first ) {
	print qq{<table border="1" cellpadding="3" cellspacing="0" };
	print qq{style="margin-bottom:1em;page-break-after:always;">\n};
	print qq{<tr><th>$lex{Month}</th><th>$lex{Day}</th><th>$lex{Name}</th>\n};
	if ( $arr{showage} ) {
	    print qq{<th>$lex{Birthdate}</th><th>$lex{Age}</th></tr>\n};
	}
	$first = 0;
    }


    my ($yr,$mon,$day) = split '-', $birthdate;
    my $age = calcAge($birthdate,$currdate);
    my ($y,$m) = split(':', $age);

    
    my $style = 'text-align:center;';
    if ( $milestones{$y} ) {
#	print qq{YEAR:$y<br>\n};
	$style = "font-weight:bold;text-align:center;font-size:120%;"; }
    
    $age = $y.'Y,'.$m. 'M';
    
    print qq{<tr><td class="ra">$month[$mon]</td>\n};
    print qq{<td>$day</td><td><b>$lastname</b>, $firstname</td>};
    if ( $arr{showage} ) {
	print qq{<td>$birthdate</td><td style="$style">$age</td></tr>\n};
    }
}

print qq{</table>\n};


print qq{<table border="1" cellpadding="3" cellspacing="0" };
print qq{style="margin-bottom:1em;page-break-after:always;">\n};
print qq{<tr><th>Missing Birthdates</th></tr>\n};

foreach my $key ( sort keys %missing ) {
    my $val = $missing{$key};
    my ($ln, $fn ) = split(':', $val);
    print qq{<tr><td><b>$ln</b>, $fn</td></tr>\n};
}
print qq{</table>\n};

print qq{</body></html>\n};



#----------------
sub showStartPage {
#----------------

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<div><input type="checkbox" name="showage" value="1">Show Staff Age</div>};

    print qq{<p><input type="submit" value="$lex{Continue}"></p></form>\n};

    print qq{</body></html>\n};

    exit;
}


#----------
sub calcAge {
#----------

    # Passed (birthdate, $currdate)
    my $birthDate = shift;
    my $currentDate = shift;
    my ($byear,$bmonth,$bday) = split('-',$birthDate);
    my ($cyear,$cmonth,$cday) = split('-',$currentDate);
    my $age = $cyear - $byear;
    my $month = $cmonth - $bmonth;

    if ($cmonth < $bmonth){
	$month = $month + 12;
	if ($cday < $bday){ $month--;}
	$age--;
    }
    elsif ($cmonth == $bmonth and $cday < $bday){
	$age--; 
	$month = 11;
    } elsif ($cmonth > $bmonth and $cday < $bday) {
	$month--;
    }
    return "$age:$month";
}
