#!/usr/bin/perl
#  Copyright 2001-2021 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('View' => 'View',
	   'Staff' => 'Staff',
	   'Main' => 'Main',
	   'No Records Found' => 'No Records Found',
	   'Error' => 'Error',
	   'Edit' => 'Edit',
	   'Delete' => 'Delete',
	   'Leave' => 'Leave',
	   'Eoy' => 'Eoy',
	   
	   );


use DBI;
use CGI;
use Cwd;

my $self = 'staffViewSecondary.pl';
my $editscript = './staffEditSecondary.pl';
my $deletescript = './staffDeleteSecondary.pl';


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Print Page Header
my $title = "$lex{View} $lex{Staff} Secondary";

print qq{$doctype\n<html><head><title>$title</title>
 <link rel="stylesheet" href="$css" type="text/css">
 </head>\n};

print qq{<body style="margin:1em;">\n};
print qq{[ <a href="$homepage">$lex{Main}</a> | };
print qq{<a href="$eoypage">$lex{Eoy}</a> ]\n};

if ( $arr{page} == 1 ) {
    delete $arr{page};
    deleteRecord();
}



$sth = $dbh->prepare("select * from staff_secondary order by lastname, firstname");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

print qq{<h1>$title</h1>\n};

my $first = 1;

while ( my $ref = $sth->fetchrow_hashref ) {
    my %r = %$ref;

    if ( $first ) {
	print qq{<table border="1" cellpadding="3" cellspacing="0">\n};
	print qq{<tr><th>Name</th><th>Userid</th><th>Password</th><th>Band</th>};
	print qq{<th colspan="2"></th></tr>\n};
	$first = 0;
    }
    
    print qq{<tr><td><b>$r{lastname}</b>, $r{firstname}</td>\n};
    print qq{<td>$r{userid}</td><td>$r{password}</td><td>$r{band}</td>\n};

    # Edit Button
    print qq{<td><form action="$editscript" method="post" };
    print qq{style="display:inline;">\n};
    print qq{<input type="hidden" name="id" value="$r{id}">\n};
    print qq{<input type="submit" value="$lex{Edit}">\n};
    print qq{</form></td>};

    # Delete Button
    print qq{<td><form action="$self" method="post" };
    print qq{style="display:inline;">\n};
    print qq{<input type="hidden" name="id" value="$r{id}">\n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<input type="submit" value="$lex{Delete}">\n};
    print qq{</form></td>};

    print qq{</tr>\n\n};

}

print qq{</table>\n};

if ( $first ) {
    print qq{<h3>$lex{'No Records Found'}</h3>\n};
    print qq{</body></html>\n};
    exit;
}

print qq{<p>[ <a href="$homepage">$lex{Main}</a> | };
print qq{<a href="$eoypage">$lex{Eoy}</a> ]</p>\n};

print qq{</body></html>\n};

#---------------
sub deleteRecord {
#---------------

    # foreach my $key ( sort keys %arr ) { print "K:$key Val:$arr{$key}<br>\n"; }
    
    my $id = $arr{id};
    my $sth1 = $dbh->prepare("select * from staff_secondary where id = ?");
    
    my $sth = $dbh->prepare("delete from staff_secondary where id = ?");
    
    $sth1->execute($id);
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth1->fetchrow_hashref;
    my %r = %$ref;

    # Delete the record
    $sth->execute($id);
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    print qq{<h3>Record of $r{firstname} $r{lastname} deleted</h3>\n};

    print qq{[ <a href="./staffViewSecondary.pl">View/Edit Secondary Users</a> ]\n};

    print qq{</body></html>\n};
    exit;
}
