#!/usr/bin/perl
#  Copyright 2001-2025 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ( 'Delete' => 'Delete',
	    'Staff Member' => 'Staff Member',
	    'Main' => 'Main',
	    'Eoy' => 'Eoy',
	    'Are you sure' => 'Are you sure',
	    'deleted' => 'deleted',
	    'Name' => 'Name',
	    'User Id' => 'User Id',
	    'Subject' => 'Subject',
	    'Count' => 'Count',
	    'Error' => 'Error',
	    'Yes' => 'Yes',
	    'Edit' => 'Edit',
	    
	    );

my $self = 'staffdel.pl';
my $passwd = 'ogimow'; # Note: name of scalar

use CGI;
use DBI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

# Load audit write function
eval require "../../lib/libaudit.pl";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

$dsn = "DBI:$dbtype:dbname=$dbase";
$dbh = DBI->connect($dsn,$user,$password);


$sth = $dbh->prepare("select lastname, firstname, userid from staffwd where userid = ?"); 
$sth->execute( $arr{userid} );
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
my ( $lastname, $firstname, $userid ) = $sth->fetchrow;


print qq{$doctype\n<html><head><title>$lex{Delete} $lex{'Staff Member'}</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$eoypage">$lex{Eoy}</a> ]\n};

print qq{<h1>Permanently $lex{Delete} Withdrawn $lex{'Staff Member'}</h1>\n};

if ( $arr{deleteflag} ) {
    delete $arr{deleteflag};
    deleteRecord();
}

# Get Course Count
my $sth = $dbh->prepare("select count(*) from subject where teacher = ?");
$sth->execute( $arr{userid} );
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
my $coursecount = $sth->fetchrow;


print qq{<form action="$self" method="post">\n};
print qq{<input type="hidden" name="name" value="$firstname $lastname">\n};
print qq{<input type="hidden" name="deleteflag" value="1">\n};
print qq{<input type="hidden" name="userid" value="$userid">\n};

print qq{<table cellpadding="3" cellspacing="0" border="0" style="border:1px solid gray;margin:1em;padding:0.5em;">};
print qq{ <tr><td class="bra">$lex{Name}</td><td>$firstname $lastname</td></tr>\n};
print qq{<tr><td class="bra">$lex{'User Id'}</td><td>$userid</td></tr>\n};

print qq{<tr><td class="bra">Course Count</td><td>$coursecount</td></tr>\n};


print qq{<tr><td class="bra">Password</td><td><input type="text" style="width:8ch;" name="password"></td></tr>\n};

print qq{<tr><td colspan="2" class="bla">$lex{Delete} Withdrawn $lex{'Staff Member'}</td></tr>\n};
print qq{<tr><td colspan="2" class="bla">$lex{'Are you sure'}? };
print qq{<input type="submit" value="$lex{Yes}, $lex{'Delete'} $lex{'Staff Member'}"></td></tr>\n};

print qq{</table>\n};

print qq{</form></body></html>\n};


#---------------
sub deleteRecord {
#---------------

    # foreach my $key (keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # userid, name, password passed.

    if ( not $arr{password} ) {
	print qq{<h3>No Password Entered</h3>\n};
	print qq{</body></html>\n};
	exit;
	
    } elsif ( $arr{password} ne $passwd ) {
	print qq{<h3>Password is not correct</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    delete $arr{password}; # don't want passed password stored in audit record

   
    
    # Load Current Record for Audit Function
    $sth = $dbh->prepare("select * from staffwd where userid = ?");
    $sth->execute( $arr{userid} );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $sref = $sth->fetchrow_hashref; # staff record reference
    my %sr = %$sref;
    

	
    # Add Audit record.
    my %audit;
    $audit{userid} = $ENV{REMOTE_USER};
    $audit{ipaddr} = $ENV{REMOTE_ADDR};
    $audit{scriptname} = $self;
    $audit{tablename} = 'staffwd';
    $audit{tableid} = $sr{id};
    $audit{startval} = $sref; 
    $audit{endval} = \%arr;

    addAudit( \%audit, $dbh );

    
    my $sth = $dbh->prepare("delete from staffwd where userid = ?");
    $sth->execute( $arr{userid} );


    if ($DBI::errstr) {
	print qq{<h3>$lex{Error}: $DBI::errstr<br>\n};
	print qq{<div>Record NOT removed</div>\n};
	
    } else {
	print qq{<h3>$arr{name} $lex{deleted}.</h3>\n};
    }

    print qq{<p>[ <a href="staffdeled.pl">$lex{Edit}/$lex{Delete} };
    print qq{Other Staff Members</a> ]</p>\n};

    print qq{</body></html>\n};

    exit;

}
