#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Staff' => 'Staff',
	   'Preregistration' => 'Preregistration',
	   'Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'Staff Member' => 'Staff Member',
	   'User Id' => 'User Id',
	   'Home' => 'Home',
	   'Room' => 'Room',
	   'Course' => 'Course',
	   'Edit' => 'Edit',
	   'Error' => 'Error',
	   'Grade' => 'Grade',
	   'Access' => 'Access',
	   'Position' => 'Position',
	   'Count' => 'Count',
	   'Red' => 'Red',
	   'Withdraw' => 'Withdraw',
	   'Delete' => 'Delete',

	   'Restore' => 'Restore',
	   'Withdrawn' => 'Withdrawn',
	   
	   );


use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;


# Select table to view; staff or prereg_staff;
my ($table, $tableview);
if ( $arr{tbl} ){ # view prereg_staff table
    $table = 'prereg_staff';
    $tableview = qq{<span style="color:red;">$lex{Preregistration}</span>$lex{Staff}};
} else {
    $table = 'staff';
    $tableview = $lex{Staff};
}

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
my $title = "$lex{Edit} / $lex{Withdraw} / $lex{Restore} $tableview";

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head>\n};

print qq{<body style="padding:1.5em;">[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{ <a href="$eoypage">$lex{Eoy}</a> ]\n};
print qq{<h1>$title</h1>\n};


# select values from staff/prereg_staff table.
$sth = $dbh->prepare("select id, lastname, firstname, userid, certification1
  from $table order by lastname, firstname");
$sth->execute;
if (DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }


print qq{<table cellpadding="3" border="1" cellspacing="0">\n};
print qq{<caption style="color:red;font-weight:bold;">$lex{Red} = $lex{Home} $lex{Room} $lex{Error}</caption>\n};
print qq{<tr><th>$lex{'Staff Member'}</th><th>$lex{'User Id'}</th><th>$lex{Position}</th><th>Cert#</th>};
print qq{<th>$lex{Home}<br>$lex{Room}</th><th>$lex{Home}<br>$lex{Grade}</th>\n};
print qq{<th>$lex{Access}</th><th>$lex{Course}<br>$lex{Count}</th>};
print qq{<th>$lex{Edit}</th>};
if ( $table eq 'staff' ) {
    print qq{<th>$lex{Withdraw}</th></tr>\n};
} else {
    print qq{<th>$lex{Withdraw}</th></tr>\n};
}


my $sth1 = $dbh->prepare("select count(*) from subject where teacher = ?");

my $sth2 = $dbh->prepare("select field_value from staff_multi
  where field_name = ? and userid = ?");

while ( my ( $id, $lastname, $firstname, $userid, $certification1 ) = $sth->fetchrow) {

    # Get subject count
    $sth1->execute( $userid );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $count = $sth1->fetchrow;

    # Load Homerooms, if any
    my @homerooms;
    $sth2->execute( 'homeroom', $userid );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( $hr = $sth2->fetchrow ) {
        push @homerooms, $hr;
    }

    # Load Grades
    my @grades;
    $sth2->execute( 'grade', $userid );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( $gr = $sth2->fetchrow ) {
	push @grades, $gr;
    }

    # Load Positions (Jobs)
    $sth2->execute( 'position', $userid );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $positions;
    my $first = 1;
    while ( $pos = $sth2->fetchrow ) {
	if ( not $first ) { $positions .= ', '; } else { $first = 0; }
	$positions .= $pos;
    }


    # Load Access Controls
    $sth2->execute( 'access', $userid );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $access;
    while ( $ac = $sth2->fetchrow ) {
	$access .= $ac. ' ';
    }

    my $errorstyle; # red color if not homeroom teachers;
    if ( (@grades and not @homerooms ) or ( not @grades and @homerooms )) { #error
	$errorstyle = qq{style="color:red;font-weight:bold;"};
    }

    print qq{<tr><td><b>$lastname</b>, $firstname</td><td>$userid</td>};
    print qq{<td>$positions</td><td>$certification1</td>\n};
    print qq{<td class="cn" $errorstyle>};
    foreach my $hr ( sort {$a <=> $b}  @homerooms ) { print qq{$hr }; }
    print qq{</td><td class="cn" $errorstyle>};
    foreach my $gr ( sort {$a <=> $b}  @grades ) { print qq{$gr }; }
    print qq{</td><td class="cn">$access</td><td class="cn">$count</td>\n};

    # Edit Button
    print qq{<td><form action="staffed.pl" method="post">\n};
    print qq{<input type="hidden" name="id" value="$id">\n};
    if ( $arr{tbl} ) {
	print qq{<input type="hidden" name="tbl" value="prereg">\n};
    }
    print qq{<input type="submit" value="$lex{Edit}"></form></td>\n};

    
    if ( $table eq 'staff' ) {
	# Withdraw Button
	print qq{<td><form action="staffwithdraw.pl" method="post">\n};
	print qq{<input type="hidden" name="page" value="1">\n};
	print qq{<input type="hidden" name="userid" value="$userid">\n};
	print qq{<input type="submit" value="$lex{Withdraw}"></form>\n};
	print qq{</td></tr>\n};


    } else { # table is prereg
	# Delete Button
	print qq{<td><form action="staffdel.pl" method="post">\n};
	print qq{<input type="hidden" name="id" value="$id">\n};
	print qq{<input type="hidden" name="tbl" value="prereg">\n};	
	print qq{<input type="submit" value="$lex{Delete}"></form>\n};
	print qq{</td></tr>\n};
    }

}

print qq{</table>\n\n};



# Now show withdrawn staff
print qq{<h2>Withdrawn Staff</h2>\n};
print qq{<table cellpadding="3" border="1" cellspacing="0">\n};
print qq{<tr><th>$lex{'Staff Member'}</th><th>$lex{'User Id'}</th><th>Cert#</th>};
print qq{<th>$lex{Restore}</th><th>Delete</th></tr>\n};

# select values from staff/prereg_staff table.
my $sth = $dbh->prepare("select id, lastname, firstname, userid, certification1
  from staffwd order by lastname, firstname");
$sth->execute;
if (DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

while ( my ( $id, $lastname, $firstname, $userid, $certification1 ) = $sth->fetchrow) {

    print qq{<tr><td><b>$lastname</b>, $firstname</td><td>$userid</td>};
    print qq{<td>$certification1</td>\n};

    # Restore/Reinstate Button
    print qq{<td><form action="staffrestore.pl" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<input type="hidden" name="userid" value="$userid">\n};
    print qq{<input type="submit" value="$lex{Restore}"></form>\n};
    print qq{</td>\n};

    # Perm Delete Button
    print qq{<td><form action="staffdel.pl" method="post">\n};
    print qq{<input type="hidden" name="userid" value="$userid">\n};
    print qq{<input type="submit" value="Permanently $lex{Delete}"></form>\n};
    print qq{</td></tr>\n};

    
}

print qq{</table>};

print qq{</body></html>\n};
