#!/usr/bin/perl
#  Copyright 2001-2019 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my $self = 'viewTransaction.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = "View Transactions - RAW";

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};


print qq{$chartype\n</head><body>\n};
print qq{[ <a href="$homepage">Main</a> ]\n};

print qq{<h1>$title</h1>\n};

showReport();



#-------------
sub showReport {
#-------------

    my $sth = $dbh->prepare("select * from staff_payjrl order by id");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    my $first = 1;
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;

	if ( $first ) {
	    print qq{<table border="1" cellpadding="3" cellspacing="0">\n};
	    # print qq{<caption style="font-weight:bold;font-size:120%;">$header</caption>\n};
	    print qq{<tr><th>Staff</th><th>Date</th>};
	    print qq{<th>Category</th><th>Hours</th><th>Comment</th></tr>\n};
	    $first = 0;
	}

	print qq{<tr><td>$r{userid}</td><td>$r{date}</td><td>$r{category}</td>};
	print qq{<td>$r{hours}</td><td>$r{comment}</td></tr>\n};

    }

    print qq{</table>\n};
    print qq{</body></html>\n};

    exit;

} # end of showReport
