#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Edit' => 'Edit',
	   'Students' => 'Students',
	   'Current' => 'Current',
	   'Withdrawn' => 'Withdrawn',
	   'Withdrawn Students' =>  'Withdrawn Students',
	   'Preregistered' =>  'Preregistered',
	   'No Student(s) Found' => 'No Student(s) Found',
	   'Error' => 'Error',
	   'Main' => 'Main',

	   );

my $cols = 3; # number of columns to display


use DBI;
use CGI;

eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my @students = ();
my %studentname = ();
my @studids = ();
my $sth = $dbh->prepare("select studid, lastname, firstname, studnum 
 from studentwd order by lastname, firstname");
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
while ( my ( $id, $lastname, $firstname, $studnum ) = $sth->fetchrow ){
    $studentname{$id} = "<b>$lastname</b>, $firstname ($studnum)";
    push @studids, $id;
}

my $records = $#studids + 1;
my $rows = roundup( $records / $cols );

foreach my $col ( 1..$cols ) {
    foreach my $row ( 1..$rows ) {
	my $id = shift @studids; # get id.
	$students[$row][$col] = $id;
    }
}



my $title = "$lex{Edit} $lex{Students}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">
$chartype\n};
print qq{</head><body>[ <a href="$homepage">$lex{Main}</a> |\n};

print qq{<a href="#curr">$lex{Current} $lex{Students}</a> |\n};
print qq{<a href="#withdrawn">$lex{Withdrawn} $lex{Students}</a> |\n};
print qq{<a href="#prereg">$lex{Preregistered} $lex{Students}</a> ]\n};

print qq{<h1>$title</h1>\n};


print qq{<a name="curr"></a>\n};
print qq{<h2>$lex{Current} $lex{Students}</h2>\n};

showStudents('student');

# End of Current Students



# --------- Withdrawn Students -------
print qq{<a name="withdrawn"></a>\n};
print qq{<h2>$lex{Withdrawn} $lex{Students}</h2>\n};

showStudents( 'studentwd' );

# End of Withdrawn Students


# -------- Preregistered Students ----------
print qq{<a name="prereg"></a>\n};
print qq{<h2>$lex{Preregistered} $lex{Students}</h2>\n};

showStudents( 'prereg' );

# End of Preregistered Students
print qq{</body></html>\n};




#----------
sub roundup { # round up a value.
#----------
    my $n = shift;
    return(($n == int($n)) ? $n : int($n + 1))
}



#---------------
sub showStudents {
#---------------

    my $table = shift;

    my $tb;
    if ( $table eq 'studentwd' ) { $tb = 'wd'; }
    if ( $table eq 'prereg' ) { $tb = 'prereg'; }

    my (@students, %studentname, %studentnum, @studids);
    my $sth = $dbh->prepare("select studid, lastname, firstname, studnum 
     from $table order by lastname, firstname");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
    while ( my ( $id, $lastname, $firstname, $studnum ) = $sth->fetchrow ){
	$studentname{$id} = "<b>$lastname</b>, $firstname";
	$studentnum{$id} = $studnum;
	push @studids, $id;
    }

    my $records = $#studids + 1;
    my $rows = roundup( $records / $cols );

    foreach my $col ( 1..$cols ) {
	foreach my $row ( 1..$rows ) {
	    my $id = shift @studids; # get id.
	    $students[$row][$col] = $id;
	}
    }

    print qq{<table border="0" cellpadding="3" cellspacing="0" };
    print qq{style="border:1px solid black;padding:0.5em;margin-bottom:1em;">\n};

    my $count = 0;
#    print qq{<tr>};

    # print out data structure
    for my $row ( 1 .. $#students ) {
	print qq{<tr>};
	for my $col ( 1 .. $#{ $students[$row] } ) {
	    if ( $col == 0 ) { next; }
	    my $id = $students[$row][$col];

	    if ( $id and $tb ) {
		print qq{<td><a href="studed.pl?tb=$tb&id=$id">$studentname{$id}</a> ($studentnum{$id})</td>\n};
	    } elsif ( $id ) {
		print qq{<td><a href="studed.pl?id=$id">$studentname{$id}</a> ($studentnum{$id})</td>\n};
	    } else { 
		print qq{<td></td>\n};
	    }
	}
	print qq{</tr>\n};
    }


    if ( not @students ) {
	print qq{<tr><td colspan="3" class="bcn">$lex{'No Student(s) Found'}</td></tr>\n};
    }

    print qq{</table>\n};

    return;

}  # End of showStudents
