#! /usr/bin/perl
#  Copyright 2001-2025 Leslie Richardson

#  This file is part of Open Admin for Schools.


my %lex = ('Main' => 'Main',
	   'Continue' => 'Continue',
	   'Homeroom' => 'Homeroom',
	   'Grade' => 'Grade',
	   'Select by' => 'Select by',
	   'Error' => 'Error',
	   'Sort by' => 'Sort by',
	   'Name' => 'Name',
	   'Common Math Assessment' => 'Common Math Assessment',
	   'Report' => 'Report',
	   'OR' => 'OR',
	   'No Selection' => 'No Selection',
	   'School Year' => 'School Year',
	   'Show Withdrawn' => 'Show Withdrawn',


	   );

my $self = 'hideStudent.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $iddst) = localtime(time);
$year = $year + 1900;
$wday++; $mon++;
my $currsdate = "$year-$mon-$mday";
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";
#my $currjd = julian_day( split('-', $currsdate) );

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = "Hide Students Temporarily";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body style="padding:1em 5em;">\n};

print qq{<div>[ <a href="$homepage">$lex{Main}</a> | <a href="./restoreStudent.pl">Restore Student</a> ]</div>\n};

print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    selectStudents();
    
} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    moveStudents();
}



#----------------
sub showStartPage { # Entry Values for Custom Script
#----------------

    my (@homerooms, @grades, @schoolyears );
    # Get Homerooms
    my $sth = $dbh->prepare("select distinct homeroom from student 
      where homeroom is not NULL and homeroom != ''");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $hr = $sth->fetchrow ) {
	push @homerooms, $hr;
    }
    @homerooms = sort {$a <=> $b} @homerooms;

    # Get Grades
    $sth = $dbh->prepare("select distinct grade from student 
      where grade is not NULL and grade != ''");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $gr = $sth->fetchrow ) {
	push @grades, $gr;
    }
    @grades = sort {$a <=> $b} @grades;

    # Get School Years
    $sth = $dbh->prepare("select distinct schoolyear from mathca_scores");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $yr = $sth->fetchrow ) {
	push @schoolyears, $yr;
    }
    @schoolyears = reverse sort @schoolyears;


    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};


    # print qq{<div><input type="submit" value="$lex{Continue}"></div>\n};

    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};


    # Select Grade
    print qq{<tr><td class="bra">$lex{'Select by'} $lex{Grade}</td>};
    print qq{<td><select name="grade"><option></option>\n};
    foreach my $gr ( @grades ) {
	print qq{<option>$gr</option>\n};
    }
    print qq{</select></td></tr>\n};

    # OR
    print qq{<tr><td colspan="2" style="text-align:center;">$lex{OR}</td></tr>\n};


    # Select Homeroom
    print qq{<tr><td class="bra">$lex{'Select by'} $lex{Homeroom}</td>};
    print qq{<td><select name="homeroom"><option></option>\n};
    foreach my $hr ( @homerooms ) {
	print qq{<option>$hr</option>\n};
    }
    print qq{</select></td></tr>\n};

    print qq{<tr><td class="ra"><input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table>\n};
    print qq{</form></body></html>\n};

    exit;

}




#-----------------
sub selectStudents {
#-----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # passed grade, homeroom
    
    if ( $arr{grade} and $arr{homeroom} ) {
	print qq{<h3>Select either Homeroom OR Grade, not both </h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    if ( not $arr{grade} and not $arr{homeroom} ) {
	print qq{<h3>Missing Homeroom OR Grade</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    # start form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};

    
    my ($select, $selectval, @grades, $classname);
    
    if ( $arr{grade} ) {
	$select = "where grade = ?";
	$selectval = $arr{grade};
	push @grades, $arr{grade};
	$classname = "Grade $arr{grade} Students";

    } elsif ( $arr{homeroom} ) {
	$select = "where homeroom = ? and grade = ?";
	$selectval = $arr{homeroom};
	$classname = "Homeroom $arr{homeroom} Students";

	my $sth = $dbh->prepare("select distinct grade from student where homeroom = ? 
           and grade != '' and grade is not NULL order by grade");
	$sth->execute( $arr{homeroom} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	while ( my $gr = $sth->fetchrow ) {
	    push @grades, $gr;
	}
	@grades = sort @grades;

    } else {
	print qq{<h3>$lex{'No Selection'}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

#    print qq{Grades:@grades SELECT:$select VAL:$selectval<br>\n};

    
    foreach my $grade ( @grades ) {

	# Now Select the students to display; skip any withdrawn kids w/o data.
	my $sth = $dbh->prepare("select * from student
				$select order by lastname, firstname");
	if ( $arr{homeroom} ) { # add on grade selector to only get part of the class.
	    $sth->execute( $selectval, $grade );
	} else {
	    $sth->execute( $selectval );
	}
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }


	# Loop through all students
	my $first = 1;

	print qq{<div style="margin:1em;">Grade $grade Students</div>\n};
	
	while ( my $ref = $sth->fetchrow_hashref ) {
	    my %r = %$ref;

	    my $studnum = $r{studnum};

	    if ($first ) {
		print qq{<table cellpadding="2" cellspacing="0" border="1">\n};
		print qq{<caption style="font-weight:bold;">Select Students to Move to };
		print qq{Temporary Student Storage</caption>\n};
		print qq{<tr><th>Name</th><th>Stud#</th><th>Birthdate</th><th>Select</th></tr>\n};
		$first = 0;
	    }

	    print qq{<tr><td><b>$r{lastname}</b>, $r{firstname} $r{initial}</td><td class="cn">$r{studnum}</td>};
	    print qq{<td>$r{birthdate}</td><td class="cn"><input type="checkbox" name="$studnum" value="1">\n};
	}
    }

    print qq{</table>\n};

    print qq{<div><input type="submit" value="Continue"></div>\n};
    print qq{</form>\n};
    
    print qq{</body></html>\n};

    exit;

} # end of selectStudents



#------------------
sub moveStudents {
#------------------

    # print qq{<div>Move Students</div>\n};
    # foreach my $key (keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # passed list of students to move by studnum
     

    my $sth = $dbh->prepare("select * from student where studnum = ?");
    
    # Insert each Student Record into student_temp table
    foreach my $studnum ( keys %arr ) {

	# Get the full record.
	$sth->execute($studnum);
	if ( $DBI::errstr) {
	    print qq{<div>Error loading student # $studnum. Skipping</div>\n};
	    next;
	}
	my $ref = $sth->fetchrow_hashref;
	%r = %$ref;

	# Insert
	my (@field, @value);
	foreach my $field ( keys %r ) {
	    if ( $field eq 'studid' ) { next; } # skip autoincrement field
	    push @field, $field;

	    $newvalue = $dbh->quote( $r{$field} );
	    push @value, $newvalue;
	}
	
	my $values = join(',', @value);
	my $fields = join(',', @field);
	
	my $sth1 = $dbh->prepare("insert into student_temp ($fields) values( $values )");
	$sth1->execute;
	if ( $DBI::errstr) {
	    print qq{<div>Insert student failed for ($r{firstname} $r{lastname}. Skipping</div>\n};
	    next;
	}
	print qq{<div><b>$r{firstname} $r{lastname}</b> moved to temporary student table.</div>\n};

	
	# Delete Original Student Record from student table
	my $sth = $dbh->prepare("delete from student where studnum = ?"); 
	$sth->execute( $studnum );
	if ( $DBI::errstr) {
	    print qq{<h3>Error: Delete of Current Student failed for $r{firstname} $r{lastname}</div>\n};
	    exit;
	}
    }

    print qq{<p>[ <a href="$homepage">$lex{Main}</a> ]</p>\n};
    print qq{</body></html>\n};

    
} # end of moveStudents
