#! /usr/bin/perl
#  Copyright 2001-2025 Leslie Richardson

#  This file is part of Open Admin for Schools.


my %lex = ('Main' => 'Main',
	   'Continue' => 'Continue',
	   'Homeroom' => 'Homeroom',
	   'Grade' => 'Grade',
	   'Select by' => 'Select by',
	   'Error' => 'Error',
	   'Sort by' => 'Sort by',
	   'Name' => 'Name',
	   'Common Math Assessment' => 'Common Math Assessment',
	   'Report' => 'Report',
	   'OR' => 'OR',
	   'No Selection' => 'No Selection',
	   'School Year' => 'School Year',
	   'Show Withdrawn' => 'Show Withdrawn',


	   );

my $self = 'restoreStudent.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $iddst) = localtime(time);
$year = $year + 1900;
$wday++; $mon++;
my $currsdate = "$year-$mon-$mday";
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";
#my $currjd = julian_day( split('-', $currsdate) );

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = "RestoreStudents to Current Student Table";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body style="padding:1em 5em;">\n};

print qq{<div>[ <a href="$homepage">$lex{Main}</a> | <a href="./hideStudent.pl">Hide Student</a> ]</div>\n};

print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    moveStudentsBack();
}



#----------------
sub showStartPage { # Display Students in the student_temp table.
#----------------

    my $sth = $dbh->prepare("select * from student_temp order by lastname, firstname"); 


    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};


    # print qq{<div><input type="submit" value="$lex{Continue}"></div>\n};

    my $first = 1;
    
    $sth->execute();
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $ref = $sth->fetchrow_hashref ) {
	%r = %$ref;

	if ( $first ) {
	    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
	    print qq{<caption>Temporary Student Table</caption>\n};
	    print qq{<tr><th>Student</th><th>Grade</th><th>Birthdate</th><th>Select</th></tr>\n};
	    print qq{<tr><td class="la" colspan="4">};
	    print qq{<input type="submit" value="Move to Current Student Table"></td></tr>\n};

	    $first = 0;
	}

	print qq{<tr><td><b>$r{lastname}</b>, $r{firstname} ($r{studnum})</td><td>$r{grade}</td>};
	print qq{<td>$r{birthdate}</td>};
	print qq{<td><input type="checkbox" name="$r{studnum}" value="1"></td></tr>\n};
	
    }

    print qq{<tr><td class="la" colspan="4"><input type="submit" value="Move to Current Student Table"></td></tr>\n};
    
    print qq{</table>\n};
    print qq{</form>\n};
    
    if ( $first ) { # no records
	print qq{<h3>No Records Found</h3>\n};
    }
    
    print qq{</body></html>\n};

    exit;

}




#-----------------
sub selectStudents {
#-----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # passed grade, homeroom
    
    if ( $arr{grade} and $arr{homeroom} ) {
	print qq{<h3>Select either Homeroom OR Grade, not both </h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    if ( not $arr{grade} and not $arr{homeroom} ) {
	print qq{<h3>Missing Homeroom OR Grade</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    # start form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};

    
    my ($select, $selectval, @grades, $classname);
    
    if ( $arr{grade} ) {
	$select = "where grade = ?";
	$selectval = $arr{grade};
	push @grades, $arr{grade};
	$classname = "Grade $arr{grade} Students";

    } elsif ( $arr{homeroom} ) {
	$select = "where homeroom = ? and grade = ?";
	$selectval = $arr{homeroom};
	$classname = "Homeroom $arr{homeroom} Students";

	my $sth = $dbh->prepare("select distinct grade from student where homeroom = ? 
           and grade != '' and grade is not NULL order by grade");
	$sth->execute( $arr{homeroom} );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	while ( my $gr = $sth->fetchrow ) {
	    push @grades, $gr;
	}
	@grades = sort @grades;

    } else {
	print qq{<h3>$lex{'No Selection'}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

#    print qq{Grades:@grades SELECT:$select VAL:$selectval<br>\n};

    
    foreach my $grade ( @grades ) {

	# Now Select the students to display; skip any withdrawn kids w/o data.
	my $sth = $dbh->prepare("select * from student
				$select order by lastname, firstname");
	if ( $arr{homeroom} ) { # add on grade selector to only get part of the class.
	    $sth->execute( $selectval, $grade );
	} else {
	    $sth->execute( $selectval );
	}
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }


	# Loop through all students
	my $first = 1;

	print qq{<div style="margin:1em;">Grade $grade Students</div>\n};
	
	while ( my $ref = $sth->fetchrow_hashref ) {
	    my %r = %$ref;

	    my $studnum = $r{studnum};

	    if ($first ) {
		print qq{<table cellpadding="2" cellspacing="0" border="1">\n};
		print qq{<caption style="font-weight:bold;">Select Students to Move to };
		print qq{Temporary Student Storage</caption>\n};
		print qq{<tr><th>Name</th><th colspan="2">Select</th></tr>\n};
		$first = 0;
	    }

	    print qq{<tr><td><b>$r{lastname}</b>, $r{firstname}</td><td>$r{studnum}</td>};
	    print qq{<td><input type="checkbox" name="$studnum" value="1">\n};
	}
    }

    print qq{</table>\n};

    print qq{<div><input type="submit" value="Continue"></div>\n};
    print qq{</form>\n};
    
    print qq{</body></html>\n};

    exit;

} # end of selectStudents



#------------------
sub moveStudentsBack { # to current student table
#------------------

    # print qq{<div>Move Students Back</div>\n};
    # foreach my $key (keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # passed list of students to move by studnum
     

    my $sth = $dbh->prepare("select * from student_temp where studnum = ?");
    
    # Insert each Student Record into current student table
    foreach my $studnum ( keys %arr ) {

	# Get the full record for temporary student table
	$sth->execute($studnum);
	if ( $DBI::errstr) {
	    print qq{<div>Error loading temp student # $studnum. Skipping</div>\n};
	    next;
	}
	my $ref = $sth->fetchrow_hashref;
	%r = %$ref;

	# Insert into Current
	my (@field, @value);
	foreach my $field ( keys %r ) {
	    if ( $field eq 'studid' ) { next; } # skip autoincrement field
	    push @field, $field;

	    $newvalue = $dbh->quote( $r{$field} );
	    push @value, $newvalue;
	}
	
	my $values = join(',', @value);
	my $fields = join(',', @field);
	
	my $sth1 = $dbh->prepare("insert into student ($fields) values( $values )");
	$sth1->execute;
	if ( $DBI::errstr) {
	    print qq{<div>Insert into student failed for ($r{firstname} $r{lastname}. Skipping</div>\n};
	    exit;
	    next;
	}
	print qq{<div><b>$r{firstname} $r{lastname}</b> moved to current student table.</div>\n};
    
	# Delete Original Student Record from student_temp table
	my $sth = $dbh->prepare("delete from student_temp where studnum = ?"); 
	$sth->execute( $studnum );
	if ( $DBI::errstr) {
	    print qq{<h3>Error: Delete of Temporary Student failed for $r{firstname} $r{lastname}</div>\n};
	    exit;
	}
    }

    print qq{<p>[ <a href="$homepage">$lex{Main}</a> ]</p>\n};
    print qq{</body></html>\n};

    
} # end of moveStudentsBack
